import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
/*
 * makeBB.java
 *
 * Created on 8 de Novembro de 2007, 20:40
 */

/**
 *
 * @author  Administrator
 */
public class makeBB extends javax.swing.JFrame {
    
    /** Cria uma nova instncia do makeBB */
    public makeBB() {
        this.PalavrasReservadas = new Vector();
        this.raiz = new DefaultMutableTreeNode("Blocos basicos");
        this.PalavrasReservadas.add("if");
        this.PalavrasReservadas.add("goto");
        this.PalavrasReservadas.add("<");
        this.PalavrasReservadas.add(">");
        this.PalavrasReservadas.add("<=");
        this.PalavrasReservadas.add(">=");
        this.PalavrasReservadas.add("-");
        this.PalavrasReservadas.add("+");
        this.PalavrasReservadas.add("*");
        this.PalavrasReservadas.add("/");
        this.PalavrasReservadas.add("=");
        this.maior = false;
        this.maior = false;
        this.arquivoOtimizado = new String();
        initComponents();
        model = (DefaultTreeModel) this.arvore.getModel();
        this.jFrame2.setSize(350,450);
        this.jFrame2.setLocation(50,50);
        this.inst = new Vector<String>();
        this.BBs = new Vector<BB>();
        this.pas = new filtro();
        this.pc = 1;
        this.idBB = 1;
        this.criabb.setEnabled(false);
        this.otimizar.setEnabled(false);
        this.salvar.setEnabled(false);
        this.mostrar.setEnabled(false);
        this.mostraOtimozado.setEnabled(false);
    }
   
    /**
     *metodo que retorna a primeira posicao que a string word aparece dentro da string inst
     */
   public int PosicaoPalavraReservada(String word, String inst){
        String temp = new String();
        int i = -1;
        for(i = 0; (i+word.length()) <= inst.length()+1;i++){
            temp = inst.substring(i, i + word.length());
            if(temp.compareTo(word)==0)
                break;
        }
        return i;
    }
    
   /**
    *metodo que retorna o total de palavras reservadas contidas na instrucao inst de acordo
    *com a lista de palavras reservadas PalavrasReservadas<Vector>
    */
    public int TotalPalavrasReservadas(String inst){
        int palavras = 0;
        Vector aux = new Vector();
        String temp = new String();
        char[] cinst = inst.toCharArray();
        for(int i = 0; i < this.PalavrasReservadas.size(); i++){
            temp = this.PalavrasReservadas.get(i);
            if(temp.compareTo("<") == 0 && inst.contains(temp) == true)
                menor = true;
            else if(temp.compareTo(">") == 0 && inst.contains(temp) == true)
                maior = true;
            else if(temp.compareTo("<=") == 0 && inst.contains(temp) == true){
                menor = false;
                palavras--;
            }
            else if(temp.compareTo(">=") == 0 && inst.contains(temp) == true){
                maior = false;
                palavras--;
            }
            if(inst.contains(temp) == true){
                palavras++;
            }
        }
        return palavras;
    }
    
    /**
     *metodo que retorna um vetor que contem todas as palavras reservadas contidas na instrucao inst
     */
    public String[] getPalavrasReservadas(String inst){
        String [] t;
        String temp;
        t = new String[this.TotalPalavrasReservadas(inst)];
        int d = 0;
        for(int i = 0; i < this.PalavrasReservadas.size(); i++){
            temp = this.PalavrasReservadas.get(i);
            if(inst.contains(temp) == true){
                if(temp.compareTo("<") == 0 && this.menor == true){
                    t[d] = temp;
                    d++;
                }else if(temp.compareTo(">") == 0 && this.maior == true){
                    t[d] = temp;
                    d++;
                }else if(temp.compareTo(">=") == 0 && this.maior == false){
                    t[d] = temp;
                    d++;
                }else if(temp.compareTo("<=") == 0 && this.menor == false){
                    t[d] = temp;
                    d++;
                }else if(temp.compareTo(">") != 0 && temp.compareTo("<") != 0 && temp.compareTo("<=") != 0 && temp.compareTo(">=") != 0){
                    t[d] = temp;
                    d++;
                }
            }
        }
        return t;
    }

    /**
     *metodo que retorna um vetor que contem todos os tokens da instrucao passada como parmetro
     */
    public String[] getTokens(String inst){
        String [] p;
        String [] p2;
        int pos[];
        Vector aux = new Vector();
        String temp = new String();
        char[] cinst = inst.toCharArray();

        p2 = this.getPalavrasReservadas(inst);
        pos = new int[this.TotalPalavrasReservadas(inst)];
        for(int i = 0; i < this.TotalPalavrasReservadas(inst); i++){
            pos[i] = this.PosicaoPalavraReservada(p2[i],inst);
        }
        Arrays.sort(pos);
        temp = new String();
        p = new String[1];
        if(pos.length == 1 && p2[0].compareToIgnoreCase("goto") == 0){
            p = new String[2];
            p[0] = this.PalavraAt(pos[0],inst);
            p[1] = inst.substring(pos[0]+4,inst.length());
        }else if(pos.length == 1 && p2[0].compareToIgnoreCase("goto") != 0){
            p = new String[3];
            p[0] = inst.substring(0,pos[0]);
            p[1] = this.PalavraAt(pos[0],inst);
            p[2] = inst.substring(pos[0]+p[1].length(),inst.length());
        }else if(pos.length == 2){
            p = new String[5];
            p[0] = inst.substring(0,pos[0]);
            p[1] = this.PalavraAt(pos[0],inst);
            p[2] = inst.substring(pos[0]+p[1].length(),pos[1]);
            p[3] = this.PalavraAt(pos[1],inst);
            p[4] = inst.substring(pos[1]+p[3].length(),inst.length());
        }else if(pos.length == 3){
            p = new String[6];
            p[0] = this.PalavraAt(pos[0],inst);
            p[1] = inst.substring(pos[0]+p[0].length(),pos[1]);
            p[2] = this.PalavraAt(pos[1],inst);
            p[3] = inst.substring(pos[1]+p[2].length(),pos[2]);
            p[4] = this.PalavraAt(pos[2],inst);
            p[5] = inst.substring(pos[2]+p[4].length(),inst.length());
        }        
        return p;
    }
    
    /**
     *metodo que retorna a palavra reservada que possui o caractere inicia
     *na posicao pos da instrucao inst
     */
    public String PalavraAt(int pos,String inst){
        String retorno = new String();
        char [] temp = inst.toCharArray();
        for(int i = pos; i < temp.length;i++){
            retorno += temp[i];
            if(inst.contains(retorno) == true && this.PalavrasReservadas.contains(retorno) == true){
                if(retorno.compareTo("<") == 0 && this.menor == true)
                    break;
                else if(retorno.compareTo(">") == 0 && this.maior == true)
                    break;
                else if(retorno.compareTo(">=") == 0 && this.maior == false)
                    break;
                else if(retorno.compareTo("<=") == 0 && this.menor == false)
                    break;
                else if(retorno.compareTo("<") == 0 && this.menor == false)
                    continue;
                else if(retorno.compareTo(">") == 0 && this.maior == false)
                    continue;
                else break;
            }
        }
        return retorno;
    }
    
    /**
     *metodo que realiza a segunda parte das otimizacoes
     *relacionadas as constantes que estao armazenadas nas variveis
     */
    public int otimizacao2(){
        String temp = new String();
        String result = new String();
        String tokens[];
        int cont = 0;
        BB aux;
        Vector<String> att1;
        Vector<String> att2;
        att1 = new Vector<String>();
        att2 = new Vector<String>();
        for(int i = 0; i < this.BBs.size(); i++){
            aux = BBs.get(i);
            att1 = new Vector();
            att2 = new Vector();
            for(int j = aux.Inicial; j <= aux.Final; j++){
                temp = this.inst.get(j).replaceAll(" ","");
                if(this.verificaLabel(temp) == true){
                    int p = temp.indexOf(':');
                    temp = temp.substring(p+1,temp.length());
                }
                tokens = this.getTokens(temp);
               //instrucao de atribuicao
                if(tokens.length > 1 && tokens[1].compareTo("=") == 0 && tokens.length == 3){
                    if(att1.contains(tokens[0]) == false){
                        att1.add(tokens[0]);
                        att2.add(tokens[2]);
                    }else{
                        int posicao = att1.indexOf(tokens[0]);
                        att2.add(posicao,tokens[2]);
                    }
                    //atribuicao com 1 operador
                }else if(tokens.length > 1 && tokens[1].compareTo("=") == 0 && tokens.length == 5){
                    if(att1.contains(tokens[2]) == true || att1.contains(tokens[4]) == true){
                        //verificacao para o primeiro operador - caso 0
                        if(att1.indexOf(tokens[2]) >= 0 && att2.get(att1.indexOf(tokens[2])).compareTo("0") == 0){
                            if(tokens[3].compareTo("+") == 0){
                                result = tokens[0]+tokens[1]+tokens[4];
                                this.inst.set(j,result);
                                cont ++;
                                this.resultado2.append("\nOtimizacao realizada na instrucao "+j);
                            }
                            //verificacao para o segundo operador
                        }else if(att1.indexOf(tokens[4]) >= 0 && att2.get(att1.indexOf(tokens[4])).compareTo("0") == 0){
                            if(tokens[3].compareTo("+") == 0){
                                result = tokens[0]+tokens[1]+tokens[2];
                                this.inst.set(j,result);
                                cont ++;
                                this.resultado2.append("\nOtimizacao realizada na instrucao "+j);
                            }else if(tokens[3].compareTo("-") == 0){
                                result = tokens[0]+tokens[1]+tokens[2];
                                this.inst.set(j,result);
                                cont ++;
                                this.resultado2.append("\nOtimizacao realizada na instrucao "+j);
                            }
                            //casos do 1
                        }else if(att2.indexOf(tokens[2]) >= 0 && att2.get(att1.indexOf(tokens[2])).compareTo("1") == 0){
                            if(tokens[3].compareTo("*") == 0){
                                result = tokens[0]+tokens[1]+tokens[4];
                                this.inst.set(j,result);
                                cont ++;
                                this.resultado2.append("\nOtimizacao realizada na instrucao "+j);
                            }
                            //verificacao para o segundo operador
                        }else if(att1.indexOf(tokens[4]) >= 0 && att2.get(att1.indexOf(tokens[4])).compareTo("1") == 0){
                            if(tokens[3].compareTo("*") == 0){
                                result = tokens[0]+tokens[1]+tokens[2];
                                this.inst.set(j,result);
                                cont ++;
                                this.resultado2.append("\nOtimizacao realizada na instrucao "+j);
                            }else if(tokens[3].compareTo("/") == 0){
                                result = tokens[0]+tokens[1]+tokens[2];
                                this.inst.set(j,result);
                                cont ++;
                                this.resultado2.append("\nOtimizacao realizada na instrucao "+j);
                            }
                        }//casos do 2
                        //var = 2
                        //var1 = var3 * var = var1 = var3 + var3
                        //var1 = var * var3 = var1 = var3 + var3
                        else if(att2.indexOf(tokens[2]) >= 0 && att2.get(att1.indexOf(tokens[2])).compareTo("2") == 0){
                            if(tokens[3].compareTo("*") == 0){
                                result = tokens[0]+tokens[1]+tokens[4]+"+"+tokens[4];
                                this.inst.set(j,result);
                                cont ++;
                                this.resultado2.append("\nOtimizacao realizada na instrucao "+j);
                            }
                            //verificacao para o segundo operador
                        }else if(att1.indexOf(tokens[4]) >= 0 && att2.get(att1.indexOf(tokens[4])).compareTo("2") == 0){
                            if(tokens[3].compareTo("*") == 0){
                                result = tokens[0]+tokens[1]+tokens[2]+"+"+tokens[2];
                                this.inst.set(j,result);
                                cont ++;
                                this.resultado2.append("\nOtimizacao realizada na instrucao "+j);
                            }else if(tokens[3].compareTo("/") == 0){
                                result = tokens[0]+tokens[1]+tokens[2]+"*0.5";
                                this.inst.set(j,result);
                                cont ++;
                                this.resultado2.append("\nOtimizacao realizada na instrucao "+j);
                            }
                        }
                    }
                }
            }
        }
        return cont;
    }
    
    /**
     *metodo que realiza a terceira parte das otimizacoes
     *relacionadas a inicializacoes desnecessarias de variaveis
     *var1 = 0 -> desnecessario
     *var2 = 3
     *var1 = 0
     *var3 = var1 + var2
     */
        private int otimizacao3(){
        String temp = new String();
        String result = new String();
        String tokens[];
        int cont = 0;
        BB aux;
        att1 = new Vector<String>();
        att2 = new Vector<String>();
        for(int i = 0; i < this.BBs.size(); i++){
            aux = BBs.get(i);
            att1 = new Vector();
            att2 = new Vector();
            //System.out.println("\nBloco Basico "+i);
            for(int j = aux.Inicial; j <= aux.Final; j++){
                temp = this.inst.get(j);
                //temp = this.inst.get(j).replaceAll(" ","");
                System.out.println("\n"+temp+"- j: "+j);
                //if(this.verificaLabel(temp) == true){
                //    int p = temp.indexOf(':');
                //    temp = temp.substring(p+1,temp.length());
               // }
                //System.out.println("\n"+temp+"- j: "+j);
                tokens = this.getTokens(temp);
                System.out.println("\ntotal de tokens: "+tokens.length+"\nTokens:");
                System.out.print(j+" - ");
                for(int s = 0; s < tokens.length;s++){
                    System.out.print("["+tokens[s]+"]");
                }
                //instrucao de atribuicao
                
            }
        }
        return cont;
    }
    
    /**
     *metodo que verifica se dentro de um conjunto de variaveis existe
     *uma das variaveis contidas no Vector att1
     */
    public boolean contem(String [] vars){
        boolean f = false;
        if(this.att1.size() > 0){
            for(int i = 0; i < this.att1.size(); i++){
                String temp = att1.get(i);
                for(int j = 0; j < vars.length; j++){
                    if(vars[j].compareTo(temp) == 0)
                        f = true;
                }
            }
        }
        return f;
    }
    
    /**
     *metodo que realiza as otimizacoes
     *
     * X + 0 = 0 + X = X, 
     * X - 0 = X, 
     * X * 1 = 1 * X = X, 
     * X / 1 = X, 
     * 2 * X = X * 2 = X + X, 
     * X / 2 = X * 0.5
     *
     */
    public String otimizacao1(String inst){
        String result = new String();
        String antes, atual;
        int att = 0;
        String tokens[] = this.getTokens(inst);
        if(tokens.length == 5){
            if(tokens[3].compareTo("+") == 0){
                if(tokens[2].compareTo("0") == 0){
                    result = tokens[0]+tokens[1]+tokens[4];
                }else if(tokens[4].compareTo("0") == 0){
                    result = tokens[0]+tokens[1]+tokens[2];
                }
            }else if(tokens[3].compareTo("-") == 0){
                if(tokens[4].compareTo("0") == 0){
                    result = tokens[0]+tokens[1]+tokens[2];
                }
            }else if(tokens[3].compareTo("*") == 0){
                if(tokens[2].compareTo("1") == 0){
                    result = tokens[0]+tokens[1]+tokens[4];
                }else if(tokens[4].compareTo("1") == 0){
                    result = tokens[0]+tokens[1]+tokens[2];
                }else if(tokens[2].compareTo("2") == 0){
                    result = tokens[0]+tokens[1]+tokens[4]+"+"+tokens[4];
                }else if(tokens[4].compareTo("2") == 0){
                    result = tokens[0]+tokens[1]+tokens[2]+"+"+tokens[2];
                }
            }else if(tokens[3].compareTo("/") == 0 && tokens[4].compareTo("2") == 0){
                result = tokens[0]+tokens[1]+tokens[2]+"*"+"0.5";
            }else if(tokens[3].compareTo("/") == 0 && tokens[4].compareTo("1") == 0){
                result = tokens[0]+tokens[1]+tokens[2];
            }
        }        
        if(result.length() == 0)
            result = inst;
        return result;
    }
    
    /**
    * funcao que adiciona no vector somente os comandos entre o begin e o end
    */
    public void addInst(){
        boolean flag = false;
        String entrada = new String();
        try{
            while(in.ready()){
                if(flag == false){
                    entrada = in.readLine().trim();
                    this.arquivoOtimizado += entrada + "\n";//serve para armazenar a parte do codigo que nao e
                                                            //manipulada, para ser gravada no possivel codigo
                                                            //otimizado a ser gravado pelo usuario
                    if(entrada.compareToIgnoreCase("begin") == 0){
                        flag = true;
                    }
                }else{
                    entrada = in.readLine().trim();
                    while(entrada.length() == 0)
                            entrada = in.readLine().trim();
                    StringTokenizer st = new StringTokenizer(entrada);
                    if(this.verificaLabel(entrada) == true && (st.countTokens() == 1)){
                        String aux = in.readLine().trim();
                        while(aux.length() == 0)
                            aux = in.readLine().trim();
                        if(aux.substring(0,3).compareToIgnoreCase("end") != 0)
                            entrada += aux;
                    }
                    if(entrada.substring(0,3).compareToIgnoreCase("end") == 0 || entrada.substring(0,3).compareToIgnoreCase("end.") == 0){
                        break;
                    }else{
                        inst.add(entrada);
                    }
                }
            }
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    
    /**
     * metodo que verifica se a instrucao atual he um label
     */
    public boolean verificaLabel(String instrucao){
        boolean achou = false;
        if(instrucao.substring(0,1).compareTo("L") == 0){
            achou = true;
        }
        return achou;
    }
    
    /**
     * metodo que verifica se a instrucao atual possui um desvio condicional ou incondicional
     */
    public boolean verificaDesvio(String instrucao){
        boolean achou = false;
        StringTokenizer tokens = new StringTokenizer(instrucao);
        while(tokens.hasMoreTokens()){
            String temp = tokens.nextToken();
            if(temp.compareToIgnoreCase("goto") == 0 ){
                achou = true;
            }
        }
        return achou;
    }
    
    /**
     * funcao que ira criar os blocos basicos
     */
    public void criaBBS(){
        String temp = new String();
        BB bb = new BB();
        for(int i = 0; i < inst.size(); i++){
            temp = inst.get(i);
            if(i == 0){
                bb = new BB();
                bb.Inicial = i;
            }else{
                //instrucao he alvo de goto ( possui um label )
                if((this.verificaLabel(temp) == true) && (this.verificaDesvio(temp) == false)){
                    bb.Final = i - 1;
                    BBs.add(bb);
                    bb = new BB();
                    bb.Inicial = i;
                    //caso seja a ultima instrucao (label para o fim do codigo)
                    if(i == inst.size() - 1){
                        bb = new BB();
                        bb.Inicial = i;
                        bb.Final = i;
                        BBs.add(bb);
                    }
                }else if((this.verificaLabel(temp) == false) && (this.verificaDesvio(temp) == true)){
                    bb.Final = i;
                    i++;
                    BBs.add(bb);
                    bb = new BB();
                    bb.Inicial = i;
                    //caso seja a ultima instrucao (label para o fim do codigo)
                    if(i == inst.size() - 1){
                        bb = new BB();
                        bb.Inicial = i;
                        bb.Final = i;
                        BBs.add(bb);
                    }
                    //instrucao he alvo de goto e possui desvio!
                }else if((this.verificaLabel(temp) == true) && (this.verificaDesvio(temp) == true)){
                    bb.Final = i - 1;
                    BBs.add(bb);
                    bb = new BB();
                    bb.Inicial = i;
                    bb.Final = i;
                    BBs.add(bb);
                    i++;
                    bb = new BB();
                    bb.Inicial = i;
                    //caso seja a ultima instrucao (label para o fim do codigo)
                    if(i == inst.size() - 1){
                        bb = new BB();
                        bb.Inicial = i;
                        bb.Final = i;
                        BBs.add(bb);
                    }
                    //caso seja a ultima instrucao (label para o fim do codigo)
                }else if(i == inst.size() - 1){
                    bb.Final = i;
                    BBs.add(bb);
                }
            }
        }
    }
    
    /**
     *metodo que serve para abrir o dialogo para selecionar o arquivo que contem
     *o codigo de 3 enderecos a ser otimizado
     */
    public int GetFile(){
        int abriu = 1;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(pas);
        fileChooser.setFileSelectionMode( JFileChooser.FILES_ONLY );
        int result = fileChooser.showOpenDialog(null);
        if ( result != JFileChooser.CANCEL_OPTION ){
            try{
                in = new BufferedReader(new FileReader(fileChooser.getSelectedFile()));
                abriu = 0;
                this.resultado2.setText("Arquivo "+fileChooser.getSelectedFile()+" aberto com sucesso!");
            }catch(Exception e){}
        }else
            abriu = 2;
        return abriu;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Cdigo Gerado ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jFrame1 = new javax.swing.JFrame();
        jScrollPane4 = new javax.swing.JScrollPane();
        areasobre = new javax.swing.JTextArea();
        jButton1 = new javax.swing.JButton();
        jFrame2 = new javax.swing.JFrame();
        jScrollPane5 = new javax.swing.JScrollPane();
        resultado4 = new javax.swing.JTextArea();
        jButton2 = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        resultado = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        criabb = new javax.swing.JButton();
        otimizar = new javax.swing.JButton();
        salvar = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        resultado2 = new javax.swing.JTextArea();
        jSeparator1 = new javax.swing.JSeparator();
        jLabel2 = new javax.swing.JLabel();
        jSeparator2 = new javax.swing.JSeparator();
        sair2 = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        mostrar = new javax.swing.JButton();
        reiniciar = new javax.swing.JButton();
        mostraOtimozado = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        arvore = new javax.swing.JTree();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        abrir = new javax.swing.JMenuItem();
        sobre = new javax.swing.JMenuItem();
        jSeparator3 = new javax.swing.JSeparator();
        sair = new javax.swing.JMenuItem();

        jFrame1.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        jFrame1.setTitle("Sobre o Otimizador de cC\u00f3digo de 3 Endere\u00e7os");
        jFrame1.setAlwaysOnTop(true);
        jFrame1.setResizable(false);
        areasobre.setColumns(20);
        areasobre.setEditable(false);
        areasobre.setRows(15);
        jScrollPane4.setViewportView(areasobre);

        jButton1.setMnemonic('f');
        jButton1.setText("Fechar");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                esconder(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jFrame1Layout = new org.jdesktop.layout.GroupLayout(jFrame1.getContentPane());
        jFrame1.getContentPane().setLayout(jFrame1Layout);
        jFrame1Layout.setHorizontalGroup(
            jFrame1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 413, Short.MAX_VALUE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jFrame1Layout.createSequentialGroup()
                .addContainerGap(338, Short.MAX_VALUE)
                .add(jButton1)
                .addContainerGap())
        );
        jFrame1Layout.setVerticalGroup(
            jFrame1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jFrame1Layout.createSequentialGroup()
                .add(jScrollPane4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 272, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButton1)
                .addContainerGap())
        );
        jFrame2.setTitle("Codigo otimizado");
        resultado4.setColumns(20);
        resultado4.setEditable(false);
        resultado4.setFont(new java.awt.Font("Arial", 1, 14));
        resultado4.setRows(5);
        jScrollPane5.setViewportView(resultado4);

        jButton2.setMnemonic('f');
        jButton2.setText("fechar");
        jButton2.setAlignmentY(0.0F);
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                esconderC(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jFrame2Layout = new org.jdesktop.layout.GroupLayout(jFrame2.getContentPane());
        jFrame2.getContentPane().setLayout(jFrame2Layout);
        jFrame2Layout.setHorizontalGroup(
            jFrame2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 653, Short.MAX_VALUE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jFrame2Layout.createSequentialGroup()
                .addContainerGap(580, Short.MAX_VALUE)
                .add(jButton2)
                .addContainerGap())
        );
        jFrame2Layout.setVerticalGroup(
            jFrame2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jFrame2Layout.createSequentialGroup()
                .add(jScrollPane5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 295, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButton2)
                .addContainerGap())
        );

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Otimizador de C\u00f3digo de 3 endere\u00e7os");
        setResizable(false);
        resultado.setColumns(20);
        resultado.setEditable(false);
        resultado.setFont(new java.awt.Font("Times New Roman", 1, 14));
        resultado.setRows(5);
        jScrollPane1.setViewportView(resultado);

        jLabel1.setText("C\u00f3digo de 3 endere\u00e7os");

        criabb.setText("Criar Blocos");
        criabb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                criarbbs(evt);
            }
        });
        criabb.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                criabbAncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });

        otimizar.setText("Otimizar c\u00f3digo");
        otimizar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                iniciarOtimizacao(evt);
            }
        });

        salvar.setText("Salvar C\u00f3digo");
        salvar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                salvarCodigo(evt);
            }
        });

        resultado2.setColumns(20);
        resultado2.setEditable(false);
        resultado2.setLineWrap(true);
        resultado2.setRows(5);
        jScrollPane2.setViewportView(resultado2);

        jLabel2.setText("Resultados");

        sair2.setMnemonic('s');
        sair2.setText("Sair");
        sair2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sair2ActionPerformed(evt);
            }
        });

        jLabel3.setText("Blocos B\u00e1sicos");

        mostrar.setText("Mostrar Blocos");
        mostrar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mostra(evt);
            }
        });

        reiniciar.setText("Reiniciar");
        reiniciar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                reiniciarVariaveis(evt);
            }
        });

        mostraOtimozado.setText("Mostrar c\u00f3digo otimizado");
        mostraOtimozado.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mostrarOtimizado(evt);
            }
        });

        arvore.setToolTipText("blocos basicos");
        arvore.setExpandsSelectedPaths(false);
        arvore.setName("arvore");
        this.arvore = new JTree(this.raiz);
        jScrollPane3.setViewportView(arvore);

        jMenu1.setMnemonic('a');
        jMenu1.setText("Arquivo");
        jMenu1.setFont(new java.awt.Font("Tahoma", 1, 12));
        abrir.setFont(new java.awt.Font("Tahoma", 1, 11));
        abrir.setMnemonic('c');
        abrir.setText("Carregar c\u00f3digo");
        abrir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openfile(evt);
            }
        });

        jMenu1.add(abrir);

        sobre.setMnemonic('o');
        sobre.setText("Sobre");
        sobre.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sobreActionPerformed(evt);
            }
        });

        jMenu1.add(sobre);

        jMenu1.add(jSeparator3);

        sair.setFont(new java.awt.Font("Tahoma", 1, 11));
        sair.setMnemonic('s');
        sair.setText("Sair");
        sair.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sairActionPerformed(evt);
            }
        });

        jMenu1.add(sair);

        jMenuBar1.add(jMenu1);

        setJMenuBar(jMenuBar1);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 626, Short.MAX_VALUE))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .addContainerGap()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(layout.createSequentialGroup()
                                    .add(criabb, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 127, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                    .add(mostrar, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 158, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 57, Short.MAX_VALUE)
                                .add(otimizar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(mostraOtimozado, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 195, Short.MAX_VALUE))
                            .add(layout.createSequentialGroup()
                                .add(27, 27, 27)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(jLabel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 157, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 357, Short.MAX_VALUE)))))
                    .add(layout.createSequentialGroup()
                        .add(13, 13, 13)
                        .add(salvar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 125, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(reiniciar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 92, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 349, Short.MAX_VALUE)
                        .add(sair2))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 636, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel2))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jSeparator2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 626, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(jLabel3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(jScrollPane3)
                    .add(jScrollPane1))
                .add(7, 7, 7)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(criabb)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(otimizar)
                        .add(mostrar)
                        .add(mostraOtimozado)))
                .add(14, 14, 14)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 85, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 11, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(sair2)
                    .add(reiniciar)
                    .add(salvar))
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void criabbAncestorAdded(javax.swing.event.AncestorEvent evt) {//GEN-FIRST:event_criabbAncestorAdded
// TODO adicione seu cdigo de manipulao aqui:
    }//GEN-LAST:event_criabbAncestorAdded

    
    /**
     *metodo que abre uma caixa de dialogo para salvar o codigo de 3 enderecos 
     *otimizado, se assim o usuario desejar
     */
    private void salvarCodigo(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_salvarCodigo
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(pas);
        fileChooser.setFileSelectionMode( JFileChooser.FILES_ONLY );
        int result = fileChooser.showSaveDialog(null);
        String arquivo = new String();
        this.arquivoOtimizado += "end.";
        if ( result != JFileChooser.CANCEL_OPTION ){
            try{
                arquivo = fileChooser.getSelectedFile().toString();
                int size = arquivo.length();
                if(arquivo.substring(size-4,size).compareToIgnoreCase(".pas") != 0)
                    arquivo += ".pas";
                 FileOutputStream saida = new FileOutputStream(arquivo);
                 saida.write(arquivoOtimizado.getBytes());
                 saida.close();
                this.resultado2.setText("Arquivo "+arquivo+" salvo com sucesso!");
            }catch(Exception e){}
        }
    }//GEN-LAST:event_salvarCodigo

    /**
     *metodo que esconde a janela "sobre" do programa
     */
    private void esconderC(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_esconderC
        this.jFrame2.dispose();
    }//GEN-LAST:event_esconderC

    /**
     *metodo que carrega o codigo otimizado em um outro frame para que o 
     *usuario possa analiza-lo
     **/
    private void mostrarOtimizado(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mostrarOtimizado
        String temp = new String();
        for(int i = 0; i < this.inst.size(); i++){
            temp += i+" - "+this.inst.get(i)+"\n";
        }
        this.arquivoOtimizado += temp + "\nend";
        this.resultado4.setText(temp);
        this.jFrame2.setVisible(true);
    }//GEN-LAST:event_mostrarOtimizado

    /**
     *metodo que inicia a otimizacao de codigo, pegando cada instrucao e passando-a
     *para um outro metodo que verifica se he possivel otimizar tal instrucao
     */
    private void iniciarOtimizacao(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_iniciarOtimizacao
        String temp = new String();
        String temp2 = new String();
        BB aux;
        int cont = 0;
        //realiza a otimizacao 1
        for(int i = 0; i < this.BBs.size(); i++){
            aux = BBs.get(i);
            for(int j = aux.Inicial; j <= aux.Final; j++){
                temp = this.inst.get(j);
                temp2 = this.otimizacao1(temp);
                this.inst.set(j,temp2);
                this.arquivoOtimizado += temp2+"\n";
                if(temp.compareTo(temp2) != 0){
                    this.resultado2.append("\notimizacao 0 realizada na instrucao "+j);
                    cont ++;
                }
            }
        }
        
       cont += this.otimizacao2();
       
       //cont += this.otimizacao3();
        
        if(cont == 0){
            this.resultado2.append("\nNao foi realizada nenhuma otimizacao neste codigo!");
        }else{
            this.resultado2.append("\nforam realizadas "+cont+" atualizacoes neste codigo!");
            this.mostraOtimozado.setEnabled(true);
            this.salvar.setEnabled(true);
        }
    }//GEN-LAST:event_iniciarOtimizacao

    /*
     *metodo que abre um frame que contem informacoes sobre o programa
     */
    private void sobreActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sobreActionPerformed
         String temp = new String();
        this.jFrame1.setLocation(50,50);
        this.jFrame1.setSize(370,600);
        temp += "  Universidade Catolica Dom Bosco\n\n";
        temp += "  Programa que realiza a construcao de blocos basicos\n";
        temp += "  para programas em codigo de 3 enderecos e realiza\n";
        temp += "  otimizacoes sobre simplificacoes algebricas em cada\n";
        temp += "  bloco basico.";
        temp += "  \n\n  Programa criado pelos alunos:\n";
        temp += "  \tErick Pereira de Oliveira\n";
        temp += "  \tRenato Bezerra Herebia\n\n";
        temp += "  como trabalho 2 da disciplina de Compiladores 2\n  ministrada pelo professor:\n\n";
        temp += "  \tProf. Dr. Ricardo Ribeiro dos Santos";
        temp += " \n\n As simplificacoes implementadas so as seguintes:";
        temp += " \n\t X + 0 = 0 + X = X";
        temp += " \n\tX - 0 = X";
        temp += " \n\tX * 1 = 1 * X = X";
        temp += " \n\tX / 1 = X";
        temp += " \n\t2 * X = X * 2 = X + X";
        temp += " \n\tX / 2 = X * 0.5";
        temp += "\nEssas otimizacoes tambem sao feitas quando o valor \nda constante esta armazenado";
        temp += "\n em uma variavel.\n";
        this.areasobre.setText(temp);
        this.jFrame1.setVisible(true);
    }//GEN-LAST:event_sobreActionPerformed

    /**
     *metodo que esconde a janela que possui informacoes sobre o programa
     */
    private void esconder(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_esconder
        this.jFrame1.setVisible(false);
    }//GEN-LAST:event_esconder

    /**
     *metodo chamado pelo botao "REINICIAR", que serve para reiniciar todas as
     *variaveis do programa para que um novo codigo possa ser analisado
     */
    private void reiniciarVariaveis(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_reiniciarVariaveis
        this.inst = new Vector<String>();
        this.arquivoOtimizado = new String();
        this.BBs = new Vector<BB>();
        this.pas = new filtro();
        this.pc = 1;
        this.idBB = 1;
        this.criabb.setEnabled(false);
        this.otimizar.setEnabled(false);
        this.salvar.setEnabled(false);
        this.mostrar.setEnabled(false);
        this.mostraOtimozado.setEnabled(false);
        this.resultado.setText("");
        this.resultado2.setText("");
        for(int i = 0; i < this.raiz.getChildCount();i++)
            raiz.remove(i);
        raiz.setAllowsChildren(false);
        raiz.removeAllChildren();
        this.arvore.removeAll();
        raiz.setAllowsChildren(true);
        model.reload();
        model = (DefaultTreeModel) this.arvore.getModel();
        this.abrir.setEnabled(true);
    }//GEN-LAST:event_reiniciarVariaveis

    /**
     *metodo que carrega todos os blocos basicos na arvore que ira representa-los
     */
    private void mostra(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mostra
        String temp = new String();
        for(int i = 0; i < this.raiz.getChildCount();i++)
            raiz.remove(i);
        raiz.setAllowsChildren(false);
        raiz.removeAllChildren();
        this.arvore.removeAll();
        raiz.setAllowsChildren(true);
        model.reload();
        model = (DefaultTreeModel) this.arvore.getModel();
        BB aux;
        DefaultMutableTreeNode t, filho;
        for(int i = 0; i < this.BBs.size(); i++){
            aux = BBs.get(i);
            temp += "\nBB "+i;
            t = new DefaultMutableTreeNode("Bloco Basico "+i);
            for(int j = aux.Inicial; j <= aux.Final; j++){
                temp += "\n "+j+" - "+this.inst.get(j);
                filho = new DefaultMutableTreeNode(j+" - "+this.inst.get(j));
                t.add(filho);
            }
            this.model.insertNodeInto(t,raiz,i);
        }
    }//GEN-LAST:event_mostra

    /**
     *metodo que inicia a criacao dos blocos basicos
     */
    private void criarbbs(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_criarbbs
        this.criaBBS();
        this.mostrar.setEnabled(true);
        this.otimizar.setEnabled(true);
        this.resultado2.append("\nBlocos Basicos Criados com sucesso!");
    }//GEN-LAST:event_criarbbs

    /**
     *metodo que serve para chamar e analisar o que a funcao de abertura de 
     *arquivo ira retornar, para saber se o arquivo foi ou nao aberto com
     *sucesso
     */
    private void openfile(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openfile
        int abriu = this.GetFile();
        if(abriu == 0){
            this.abrir.setEnabled(false);
            String temp = new String();
            this.addInst();
            for(int i = 0; i < this.inst.size(); i++){
                temp += i+" - "+this.inst.get(i)+"\n";
            }
            this.resultado.setText(temp);
            this.criabb.setEnabled(true);
        }else if(abriu == 1)
            this.resultado2.setText("Arquivo inexistente!");
        else if(abriu == 2)
            this.resultado2.setText("Acao cancelada!");
    }//GEN-LAST:event_openfile

    /**
     *metodo chamado pelo item do menu denominado SAIR, que fecha o programa
     */
    private void sair2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sair2ActionPerformed
        System.exit(0);
    }//GEN-LAST:event_sair2ActionPerformed

    /**
     *metodo chamado pelo botao SAIR que fecha o programa
     */
    private void sairActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sairActionPerformed
        System.exit(0);
    }//GEN-LAST:event_sairActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new makeBB().setVisible(true);
            }
        });
    }
    
    // Declarao de variveis - no modifique//GEN-BEGIN:variables
    private javax.swing.JMenuItem abrir;
    private javax.swing.JTextArea areasobre;
    private javax.swing.JTree arvore;
    private javax.swing.JButton criabb;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JFrame jFrame1;
    private javax.swing.JFrame jFrame2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JButton mostraOtimozado;
    private javax.swing.JButton mostrar;
    private javax.swing.JButton otimizar;
    private javax.swing.JButton reiniciar;
    private javax.swing.JTextArea resultado;
    private javax.swing.JTextArea resultado2;
    private javax.swing.JTextArea resultado4;
    private javax.swing.JMenuItem sair;
    private javax.swing.JButton sair2;
    private javax.swing.JButton salvar;
    private javax.swing.JMenuItem sobre;
    // Fim da declarao de variveis//GEN-END:variables
    
    //declaracao de variaveis que nao sao da interface grafica
    private BufferedReader in;
    //vector que aramazena todas as instrucoes do codigo de 3 enderecos
    //neste caso, a posicao no vector sera a id da instrucao
    /**
     *Vector que armazena todas as instrues do cdigo em 3 endereos
     */
    protected Vector<String> inst;
    //Estrutura que armazena os blocos basicos
    /**
     *Estrutura que armazena os blocos bsicos
     */
    protected Vector<BB> BBs;
    private int pc;
    private int idBB;
    private filtro pas;
    private String arquivoOtimizado;
    //nodo raiz para a arvore que representara os blocos basicos
    private DefaultMutableTreeNode raiz;
    //modelo para manipulacao da arvore que representa os bloco basicos
    private DefaultTreeModel model;
    /**
     *Estrutura que armazena todas as palavras reservadas que podem estar presentes nos codigos de 3 endereos
     */
    protected Vector<String> PalavrasReservadas;
    private Vector<String> att1;
    private Vector<String> att2;
    private boolean maior, menor;
    
        /**
         *Estrutura dos Blocos Bsicos
         */
	public class BB{
                /**
                 *Varivel que armazena a identificao do bloco bsico
                 */
		public int id;
                /**
                 *Varivel que indica qual  a instruo inicial deste bloco bsico
                 */
		public int Inicial;
                /**
                 *Varivel que indica qual  a instruo final deste bloco bsico
                 */
		public int Final;		
	}
    
    //classe usada para filtrar os arquivos no filechooser de abertura e escrita de arquivos
    class filtro extends FileFilter{
        public boolean accept(File f){
            return (f.getName().toLowerCase().endsWith(".pas") || f.isDirectory() || f.getName().toLowerCase().endsWith(".*"));
        }
        public String getDescription(){
            return "Arquivo com instrucoes de 3 enderecos";
        }
    }
}
