# /hades/testsuite/awt/checkAwtRobot.py
#
# simple script to check whether we may use the java.awt.Robot class
# for automatic GUI testing
#
# 22.08.01 fnh
#
from java.awt import Frame
from java.awt import Rectangle
from java.awt import Robot
from java.lang import Thread
from hades.gui import ImageCanvas



def checkAwtRobot():
	robot = Robot()
	if (robot == None):
		print "FAIL: could not create java.awt.Robot"
		return
	else:
		print "pass: created java.awt.Robot"
	robot.mouseMove( 100, 100 )


def testMakeScreenShot():
	# x y w h 
	testMakeScreenShot( 100, 100, 500, 300 )



def testMakeScreenShot( x, y, w, h ):
	frame = Frame( "Robot ScreenShot" )
	robot = Robot()
	image = robot.createScreenCapture( Rectangle(x,y,w,h) )
	imageCanvas = ImageCanvas( image )
	frame.add( "Center", imageCanvas )
	frame.setSize( 500, 300 )
	frame.show()
	Thread.currentThread().sleep( 2000 )
	frame.setVisible( 0 )
	frame = None
	print "pass: screenshot via Robot works."


# now run the test:
print "EXEC: check java.awt.Robot..."
checkAwtRobot()
testMakeScreenShot( 200, 50, 400, 300 )
