# /hades/testsuite/awt/checkWindowManager.py
#
# simple script to check the Java <-> window manager interaction:
# we try to create some Frames, resize and move them, etc. and
# check whether the parameters are respected by the window manager.
#
# 22.08.01 fnh
#
from java.awt import Dimension
from java.awt import Frame
from java.awt import Point
from java.awt import Rectangle
from java.awt import Toolkit
from java.lang import Thread

frame = None


def checkWindowCreate():
	global frame 
	frame = Frame()
	if (frame == None):
		raise error, "FAIL: could not create a java.awt.Frame"
		return
	frame.setTitle( "checkWindowManager.py" )
	frame.setSize( 300, 200 )
	frame.show()
	return
	


def checkWindowPlacement():
	positions = [
     Point( 0, 0 ), Point( 100, 50 ), Point( 200, 300 ), Point( 500, 500 )
  ]
	ok = 1
	for i in range( len(positions) ):
		frame.setLocation( positions[i] )
		Thread.currentThread().sleep( 100 )
		pos = frame.getLocationOnScreen()
		if (pos.x != positions[i].x) or (pos.y != positions[i].y):
			print "FAIL: window placement mismatch:", pos, "vs.", positions[i]
			ok = 0
	if (ok == 1):
		print "pass: window placement works"
	return



def checkWindowResizing():	
	frame.setLocation( 50, 70 )
	sizes = [
    Dimension(10,10), Dimension(200,300), Dimension(640,480),
    Dimension(10,1000), Dimension(1000,50), Dimension(2048,2048)
  ]
	ok = 1
	for i in range( len(sizes) ):
		frame.setSize( sizes[i] )
		frame.validate()
		Thread.currentThread().sleep( 100 )
		size = frame.getSize()
		if (size.width != sizes[i].width) or (size.height != sizes[i].height):
			print "FAIL: window size mismatch:", size, "vs.", sizes[i]
			ok = 0
	if (ok == 1):
		print "pass: window resizing works"
	return


	return


def checkWindowMaximize():
	toolkit = Toolkit.getDefaultToolkit()
	screenSize = toolkit.getScreenSize()	
	frame.setBounds( 0, 0, screenSize.width, screenSize.height )
	Thread.currentThread().sleep( 100 )
	bounds = frame.getBounds()
	if ((bounds.x != 0) or (bounds.y != 0) 
		or (bounds.width != screenSize.width)
		or (bounds.height != screenSize.height)):
		print "FAIL: frame not maximized:", bounds, "vs.", screenSize
	else:
		print "pass: window maximized"
	frame.setBounds( 100, 100, 200, 50 )
	return



def checkWindowManager():
	print "EXEC: checkWindowManager..." 
	checkWindowCreate()
	checkWindowPlacement()
	checkWindowResizing()
	checkWindowMaximize()
	frame.setVisible( 0 )
	return


# now run the tests...
checkWindowManager()

