# /hades/testsuite/awt/checkHadesConsole.py
#
# simple script to check the Hades message console and its file logging
# properties. We create a console, show its window, open and close
# a logfile.
#
# 22.08.01 fnh
#
from java.awt import Dimension
from java.awt import Frame
from java.awt import Point
from java.awt import Rectangle
from java.lang import Thread

from hades.gui import Console

frame = None


def createConsole():
	global console
	console = Console.getConsole()
	if (console == None):
		raise error, "FAIL: could not create Hades console."

	console.setMaxLines( 50 ) 
	console.show()
	print "pass: console created"
	


def twothousandMessages():
	for i in range(0,2000):  # this is 0..1999, but not 2000...
		square = 1.0*i*i
		cube = square*i
		s = " " + repr(i) + " " + repr(square) + " " + repr(cube)
		console.message( s )


def checkFileLogging():
	s1 = "Old a new log file names:" 
	s2 = console.getLogfileName() 
	console.setLogfileName( "checkHadesConsole.log" )
	console.openLogStream()
	console.message( s1 + "\n" + s2 )
	console.message( console.getLogfileName() )
	console.message( "Printing a list of 2000 integers, squares, and cubes." )
	twothousandMessages()
	console.closeFlushLogStream()
	print "pass: console file logging seems to work."  



def checkHadesConsole():
	print "EXEC: checking the Hades console..."
	createConsole()
	twothousandMessages()
	checkFileLogging()
	console.setMaxLines( 300 )
	console.setVisible( 0 )
	print "pass: Hades console works."


# now run the tests...
checkHadesConsole()
