   package mars.venus;
   import mars.*;
   import javax.swing.*;
   import java.awt.*;
   import java.awt.event.*;
   import javax.swing.event.*;
   import java.io.*;
   import java.net.*;

/*
Copyright (c) 2003-2006,  Pete Sanderson and Kenneth Vollmar

Developed by Pete Sanderson (psanderson@otterbein.edu)
and Kenneth Vollmar (kenvollmar@missouristate.edu)

Permission is hereby granted, free of charge, to any person obtaining 
a copy of this software and associated documentation files (the 
"Software"), to deal in the Software without restriction, including 
without limitation the rights to use, copy, modify, merge, publish, 
distribute, sublicense, and/or sell copies of the Software, and to 
permit persons to whom the Software is furnished to do so, subject 
to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR 
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

(MIT license, http://www.opensource.org/licenses/mit-license.html)
 */

	/**
	  *  Top level container for Venus GUI.
	  *   @author Sanderson and Team JSpim
	  **/
	  
	  /* Heavily modified by Pete Sanderson, July 2004, to incorporate JSPIMMenu and JSPIMToolbar
	   * not as subclasses of JMenuBar and JToolBar, but as instances of them.  They are both
		* here primarily so both can share the Action objects.
		*/
	
    public class VenusUI extends JFrame{
      VenusUI mainUI;
      JMenuBar menu;
      JToolBar toolbar;
      MainPane mainPane; 
      RegistersPane registersPane; 
      RegistersWindow registersTab;
      Coprocessor1Window coprocessor1Tab;
      Coprocessor0Window coprocessor0Tab;
      MessagesPane messagesPane;
      JSplitPane splitter, horizonSplitter;
      JPanel north;
   
      private int frameState; // see windowActivated() and windowDeactivated()
     	
   	// PLEASE PUT THESE TWO (& THEIR METHODS) SOMEWHERE THEY BELONG, NOT HERE
      private static boolean reset= true; // registers/memory reset for execution
      private static boolean started = false;  // started execution
      Editor editor;
      JTextArea sourceEditArea;
   	
   	// components of the menubar
      private JMenu file, run, window, help, edit, settings;
      private JMenuItem fileNew, fileOpen, fileClose, fileSave, fileSaveAs, filePrint, fileExit;
      private JMenuItem editUndo, editRedo, editCut, editCopy, editPaste;
      private JMenuItem runGo, runStep, runBackstep, runReset, runAssemble, runStop, runPause, runClearBreakpoints;
      private JCheckBoxMenuItem settingsLabel, settingsValueDisplayBase, settingsAddressDisplayBase,
              settingsExtended, settingsAssembleOnOpen, settingsAssembleAll;
		private JMenuItem settingsExceptionHandler;
      private JMenuItem helpHelp, helpAbout;
         
      // components of the toolbar
      private JButton Undo, Redo, Cut, Copy, Paste;
      private JButton New, Open, Save, SaveAs, Print;
      private JButton Run, Assemble, Reset, Step, Backstep, Stop, Pause;
      private JButton Help;
   
      // The "action" objects, which include action listeners.  One of each will be created then
   	// shared between a menu item and its corresponding toolbar button.  This is a very cool
   	// technique because it relates the button and menu item so closely
   	
      private Action fileNewAction, fileOpenAction, fileCloseAction, fileSaveAction;
      private Action fileSaveAsAction, filePrintAction, fileExitAction;
      EditUndoAction editUndoAction;
      EditRedoAction editRedoAction;
      private Action editCutAction, editCopyAction, editPasteAction;
      private Action runAssembleAction, runGoAction, runStepAction, runBackstepAction, runResetAction, 
                     runStopAction, runPauseAction, runClearBreakpointsAction;
      private Action settingsLabelAction, settingsValueDisplayBaseAction, settingsAddressDisplayBaseAction,
                     settingsExtendedAction, settingsAssembleOnOpenAction, settingsAssembleAllAction,
							settingsExceptionHandlerAction;    
      private Action helpHelpAction, helpAboutAction;
   
   
    /**
      *  Constructor for the Class. Sets up a window object for the UI
   	*   @param s Name of the window to be created.
   	**/     
   
       public VenusUI(String s) {
         super(s);
         mainUI = this;
			
         double screenWidth  = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
         double screenHeight = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		   // basically give up some screen space if running at 800 x 600
			double messageWidthPct = (screenWidth<1000.0)? 0.67 : 0.73;
			double messageHeightPct = (screenWidth<1000.0)? 0.12 : 0.15;
			double mainWidthPct = (screenWidth<1000.0)? 0.67 : 0.73;
			double mainHeightPct = (screenWidth<1000.0)? 0.60 : 0.65;
			double registersWidthPct = (screenWidth<1000.0)? 0.18 : 0.22;
			double registersHeightPct = (screenWidth<1000.0)? 0.72 : 0.80;
						
			Dimension messagesPanePreferredSize = new Dimension((int)(screenWidth*messageWidthPct),(int)(screenHeight*messageHeightPct)); 
			Dimension mainPanePreferredSize = new Dimension((int)(screenWidth*mainWidthPct),(int)(screenHeight*mainHeightPct));
			Dimension registersPanePreferredSize = new Dimension((int)(screenWidth*registersWidthPct),(int)(screenHeight*registersHeightPct));
			
     	   // the "restore" size (window control button that toggles with maximize)
      	// I want to keep it large, with enough room for user to get handles
         //this.setSize((int)(screenWidth*.8),(int)(screenHeight*.8));

         Globals.setGui(this);
         Globals.initialize();			

			
      	// No good reason for this to be global, should be with edit pane.
         sourceEditArea = new JTextArea();
//         Globals.initialize();
      	//  image courtesy of NASA/JPL.  
         URL im = this.getClass().getResource(Globals.imagesPath+"RedMars16.gif");
         if (im == null) {
            System.out.println("Internal Error: images folder or file not found");
            System.exit(0);
         }				
         Image mars = Toolkit.getDefaultToolkit().getImage(im);
         this.setIconImage(mars);
			// Everything in frame will be arranged on JPanel "center", which is only frame component.
			// "center" has BorderLayout and 2 major components:
			//   -- panel (jp) on North with 2 components
			//      1. toolbar
			//      2. run speed slider.
			//   -- split pane (horizonSplitter) in center with 2 components side-by-side
			//      1. split pane (splitter) with 2 components stacked
			//         a. main pane, with 2 tabs (edit, execute)
			//         b. messages pane with 2 tabs (mars, run I/O)
			//      2. registers pane with 3 tabs (register file, coproc 0, coproc 1)
			// I should probably run this breakdown out to full detail.  The components are created
			// roughly in bottom-up order; some are created in component constructors and thus are
			// not visible here.
			
         registersTab = new RegistersWindow();
         coprocessor1Tab = new Coprocessor1Window();
         coprocessor0Tab = new Coprocessor0Window();
         registersPane = new RegistersPane(mainUI, registersTab,coprocessor1Tab, coprocessor0Tab);
         registersPane.setPreferredSize(registersPanePreferredSize);
         mainPane= new MainPane(mainUI, sourceEditArea, registersTab, coprocessor1Tab, coprocessor0Tab);
         mainPane.setPreferredSize(mainPanePreferredSize);
         messagesPane= new MessagesPane();
         messagesPane.setPreferredSize(messagesPanePreferredSize);
         splitter= new JSplitPane(JSplitPane.VERTICAL_SPLIT, mainPane, messagesPane);
         splitter.setOneTouchExpandable(true);
         splitter.resetToPreferredSizes();
         horizonSplitter = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, splitter, registersPane);
         horizonSplitter.setOneTouchExpandable(true);
         horizonSplitter.resetToPreferredSizes();
      
		   // due to dependencies, do not set up menu/toolbar until now.
         this.createActionObjects();
         menu= this.setUpMenuBar();
		   this.setJMenuBar(menu);
			
         toolbar= this.setUpToolBar();

         JPanel jp = new JPanel(new FlowLayout(FlowLayout.LEFT));
         jp.add(toolbar);
         jp.add(RunSpeedPanel.getInstance());
			JPanel center= new JPanel(new BorderLayout());
         center.add(jp, BorderLayout.NORTH);
         center.add(horizonSplitter);
      				

			
         this.getContentPane().add(center);
      
         FileStatus.reset();
			// The following has side effect of establishing menu state
         FileStatus.set(FileStatus.NO_FILE);  
      				
         // This is invoked when opening the app.  It will set the app to
		   // appear at full screen size.
         this.addWindowListener(
                new WindowAdapter() {
                   public void windowOpened(WindowEvent e) {
                     mainUI.setExtendedState(JFrame.MAXIMIZED_BOTH); 
                  }
               });

        // This is invoked when exiting the app through the X icon.  It will in turn
        // check for unsaved edits before exiting.
         this.addWindowListener(
                new WindowAdapter() {
                   public void windowClosing(WindowEvent e) {
                     if (mainUI.editor.editsSavedOrAbandoned()) {
                        System.exit(0);
                     } 
                  }
               });
      			
      	// The following will handle the windowClosing event properly in the 
      	// situation where user Cancels out of "save edits?" dialog.  By default,
      	// the GUI frame will be hidden but I want it to do nothing.
         this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

         this.pack();
         this.setVisible(true);
      }
   	
   	
    /*
     * Action objects are used instead of action listeners because one can be easily shared between
     * a menu item and a toolbar button.  Does nice things like disable both if the action is
     * disabled, etc.
     */
       private void createActionObjects() {
         Toolkit tk = Toolkit.getDefaultToolkit();
         Class cs = this.getClass(); 
         try {
            fileNewAction = new FileNewAction("New", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"New22.gif"))),
                                            "Create a new file for editing", new Integer(KeyEvent.VK_N),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_N, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);		
            fileOpenAction = new FileOpenAction("Open ...", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Open22.gif"))),
               									  "Open a file for editing", new Integer(KeyEvent.VK_O),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_O, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            fileCloseAction = new FileCloseAction("Close", null,
                                            "Close the current file", new Integer(KeyEvent.VK_C),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_W, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);						
            fileSaveAction = new FileSaveAction("Save", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Save22.png"))),//"Save24.gif"))),
               									  "Save the current file", new Integer(KeyEvent.VK_S),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_S, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            fileSaveAsAction = new FileSaveAsAction("Save as ...", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"SaveAs22.png"))),//"SaveAs24.gif"))),
               									  "Save current file with different name", new Integer(KeyEvent.VK_A),
               									  null, mainUI);	
            filePrintAction = new FilePrintAction("Print ...", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Print22.gif"))),
               									  "Print current file", new Integer(KeyEvent.VK_P),
               									  null, mainUI);	
            fileExitAction = new FileExitAction("Exit", null,
               	                         "Exit Mars", new Integer(KeyEvent.VK_X),
               									  null, mainUI);	
            editUndoAction = new EditUndoAction("Undo", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Undo22.png"))),//"Undo24.gif"))),
               									  "Undo last edit", new Integer(KeyEvent.VK_U),
                                            KeyStroke.getKeyStroke( KeyEvent.VK_Z, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            editRedoAction = new EditRedoAction("Redo", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Redo22.png"))),//"Redo24.gif"))),
               									  "Redo last edit", new Integer(KeyEvent.VK_R),
                                            KeyStroke.getKeyStroke( KeyEvent.VK_Y, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);			
            editCutAction = new EditCutAction("Cut", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Cut22.gif"))),
               									  "Cut", new Integer(KeyEvent.VK_C),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_X, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            editCopyAction = new EditCopyAction("Copy", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Copy22.png"))),//"Copy24.gif"))),
               									  "Copy", new Integer(KeyEvent.VK_O),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_C, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            editPasteAction = new EditPasteAction("Paste", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Paste22.png"))),//"Paste24.gif"))),
               									  "Paste", new Integer(KeyEvent.VK_P),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_V, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            runAssembleAction = new RunAssembleAction("Assemble",  
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Assemble22.png"))),//"MyAssemble24.gif"))),
               									  "Assemble the current file and clear breakpoints", new Integer(KeyEvent.VK_A),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_F3, 0), //.VK_A, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);			
            runGoAction = new RunGoAction("Go", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Play22.png"))),//"Play24.gif"))),
               									  "Run the current program", new Integer(KeyEvent.VK_G),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_F5, 0), //.VK_G, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            runStepAction = new RunStepAction("Step", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"StepForward22.png"))),//"MyStepForward24.gif"))),
               									  "Run one step at a time", new Integer(KeyEvent.VK_T),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_F7, 0), //.VK_T, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            runBackstepAction = new RunBackstepAction("Backstep", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"StepBack22.png"))),//"MyStepBack24.gif"))),
               									  "Undo the last step", new Integer(KeyEvent.VK_B),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_F8, 0), //.VK_B, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            runPauseAction = new RunPauseAction("Pause", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Pause22.png"))),//"Pause24.gif"))),
               									  "Pause the currently running program", new Integer(KeyEvent.VK_P),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_F9, 0), //.VK_P, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            runStopAction = new RunStopAction("Stop", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Stop22.png"))),//"Stop24.gif"))),
               									  "Stop the currently running program", new Integer(KeyEvent.VK_S),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_F11, 0), //.VK_S, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);
            runResetAction = new RunResetAction("Reset", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Reset22.png"))),//"MyReset24.gif"))),
               									  "Reset MIPS memory and registers", new Integer(KeyEvent.VK_R),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_F12,0),//.VK_R, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);	
            runClearBreakpointsAction = new RunClearBreakpointsAction("Clear all breakpoints",
                                            null,
               									  "Clears all execution breakpoints set since the last assemble.",
               									  new Integer(KeyEvent.VK_K),
               									  KeyStroke.getKeyStroke( KeyEvent.VK_K, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()),
               									  mainUI);  
            settingsLabelAction = new SettingsLabelAction("Show Labels Window (symbol table)",
                                            null,
               									  "Toggle visibility of Labels window (symbol table) in the Execute tab",
               									  null,null,
               									  mainUI);
            settingsValueDisplayBaseAction = new SettingsValueDisplayBaseAction("Display values in hexadecimal",
                                            null,
               									  "Toggle between hexadecimal and decimal display of memory/register values",
               									  null,null,
               									  mainUI);
            settingsAddressDisplayBaseAction = new SettingsAddressDisplayBaseAction("Display addresses in hexadecimal",
                                            null,
               									  "Toggle between hexadecimal and decimal display of memory addresses",
               									  null,null,
               									  mainUI);
            settingsExtendedAction          = new SettingsExtendedAction("Permit extended (pseudo) instructions and formats",
                                            null,
               									  "If set, MIPS extended (pseudo) instructions are formats are permitted.",
               									  null,null,
               									  mainUI);    
            settingsAssembleOnOpenAction    = new SettingsAssembleOnOpenAction("Assemble file upon opening and set File Open dialog.",
                                            null,
               									  "If set, a file will be automatically assembled as soon as it is opened.  File Open dialog will show most recently opened file.",
               									  null,null,
               									  mainUI);
            settingsExceptionHandlerAction  = new SettingsExceptionHandlerAction("Exception Handler",
                                            null,
               									  "If set, the specified exception handler file will be included in all Assemble operations.",
               									  null,null,
               									  mainUI);
            settingsAssembleAllAction       = new SettingsAssembleAllAction("Assemble operation applies to all files in current directory.",
                                            null,
               									  "If set, all files in current directory will be assembled when Assemble operation is selected.",
               									  null,null,
               									  mainUI);            helpHelpAction = new HelpHelpAction("Help", 
                                            new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Help22.png"))),//"Help24.gif"))),
               									  "Help", new Integer(KeyEvent.VK_H),
               									  KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0),
               									  mainUI);	
            helpAboutAction = new HelpAboutAction("About ...",null, 
                                            "Information about Mars", null,null, mainUI);	
         } 
             catch (NullPointerException e) {
               System.out.println("Internal Error: images folder not found, or other null pointer exception while creating Action objects");
					e.printStackTrace();
               System.exit(0);
            }
      }
   
    /*
     * build the menus and connect them to action objects (which serve as action listeners
     * shared between menu item and corresponding toolbar icon).
     */
    
       private JMenuBar setUpMenuBar() {
      
         Toolkit tk = Toolkit.getDefaultToolkit();
         Class cs = this.getClass(); 
         JMenuBar menuBar = new JMenuBar();
         file=new JMenu("File");
         file.setMnemonic(KeyEvent.VK_F);
         edit = new JMenu("Edit");
         edit.setMnemonic(KeyEvent.VK_E);
         run=new JMenu("Run");
         run.setMnemonic(KeyEvent.VK_R);
         //window = new JMenu("Window");
         //window.setMnemonic(KeyEvent.VK_W);
         settings = new JMenu("Settings");
         settings.setMnemonic(KeyEvent.VK_S);
         help = new JMenu("Help");
         help.setMnemonic(KeyEvent.VK_H); 
      	// slight bug: user typing alt-H activates help menu item directly, not help menu
      
         fileNew = new JMenuItem(fileNewAction);
         fileNew.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"New16.gif"))));
         fileOpen = new JMenuItem(fileOpenAction);
         fileOpen.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Open16.gif"))));
         fileClose = new JMenuItem(fileCloseAction);
         fileClose.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"MyBlank16.gif"))));
         fileSave = new JMenuItem(fileSaveAction);
         fileSave.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Save16.png"))));//"Save16.gif"))));
         fileSaveAs = new JMenuItem(fileSaveAsAction);
         fileSaveAs.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"SaveAs16.png"))));//"SaveAs16.gif"))));
         filePrint = new JMenuItem(filePrintAction);
         filePrint.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Print16.gif"))));
         fileExit = new JMenuItem(fileExitAction);
         fileExit.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"MyBlank16.gif"))));
         file.add(fileNew);
         file.add(fileOpen);
         file.add(fileClose);
         file.addSeparator();
         file.add(fileSave);
         file.add(fileSaveAs);
         file.addSeparator();
         file.add(filePrint);
         file.addSeparator();
         file.add(fileExit);
      	
         editUndo = new JMenuItem(editUndoAction);
         editUndo.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Undo16.png"))));//"Undo16.gif"))));
         editRedo = new JMenuItem(editRedoAction);
         editRedo.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Redo16.png"))));//"Redo16.gif"))));      
         editCut = new JMenuItem(editCutAction);
         editCut.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Cut16.gif"))));
         editCopy = new JMenuItem(editCopyAction);
         editCopy.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Copy16.png"))));//"Copy16.gif"))));
         editPaste = new JMenuItem(editPasteAction);
         editPaste.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Paste16.png"))));//"Paste16.gif"))));
         edit.add(editUndo);
         edit.add(editRedo);
         edit.addSeparator();
         edit.add(editCut);
         edit.add(editCopy);
         edit.add(editPaste);
      
         runAssemble = new JMenuItem(runAssembleAction);
         runAssemble.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Assemble16.png"))));//"MyAssemble16.gif"))));
         runGo = new JMenuItem(runGoAction);
         runGo.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Play16.png"))));//"Play16.gif"))));
         runStep = new JMenuItem(runStepAction);
         runStep.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"StepForward16.png"))));//"MyStepForward16.gif"))));
         runBackstep = new JMenuItem(runBackstepAction);
         runBackstep.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"StepBack16.png"))));//"MyStepBack16.gif"))));
         runReset = new JMenuItem(runResetAction);
         runReset.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Reset16.png"))));//"MyReset16.gif"))));
         runStop = new JMenuItem(runStopAction);
         runStop.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Stop16.png"))));//"Stop16.gif"))));
         runPause = new JMenuItem(runPauseAction);
         runPause.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Pause16.png"))));//"Pause16.gif"))));
         runClearBreakpoints = new JMenuItem(runClearBreakpointsAction);
         runClearBreakpoints.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"MyBlank16.gif"))));
      
         run.add(runAssemble);
         run.add(runGo);
         run.add(runStep);
         run.add(runBackstep);
         run.add(runPause);
         run.add(runStop);
         run.add(runReset);
         run.addSeparator();
         run.add(runClearBreakpoints);
      	
         settingsLabel = new JCheckBoxMenuItem(settingsLabelAction);
         settingsLabel.setSelected(Globals.getSettings().getLabelWindowVisibility());
         settingsValueDisplayBase = new JCheckBoxMenuItem(settingsValueDisplayBaseAction);
         settingsValueDisplayBase.setSelected(Globals.getSettings().getDisplayValuesInHex());//mainPane.getExecutePane().getValueDisplayBaseChooser().isSelected());
         // Tell the corresponding JCheckBox in the Execute Pane about me -- it has already been created.
         mainPane.getExecutePane().getValueDisplayBaseChooser().setSettingsMenuItem(settingsValueDisplayBase);
         settingsAddressDisplayBase = new JCheckBoxMenuItem(settingsAddressDisplayBaseAction);
         settingsAddressDisplayBase.setSelected(Globals.getSettings().getDisplayAddressesInHex());//mainPane.getExecutePane().getValueDisplayBaseChooser().isSelected());
         // Tell the corresponding JCheckBox in the Execute Pane about me -- it has already been created.
         mainPane.getExecutePane().getAddressDisplayBaseChooser().setSettingsMenuItem(settingsAddressDisplayBase);
         settingsExtended = new JCheckBoxMenuItem(settingsExtendedAction);
         settingsExtended.setSelected(Globals.getSettings().getExtendedAssemblerEnabled());
         settingsAssembleOnOpen = new JCheckBoxMenuItem(settingsAssembleOnOpenAction);
         settingsAssembleOnOpen.setSelected(Globals.getSettings().getAssembleOnOpenEnabled());
      	settingsAssembleAll = new JCheckBoxMenuItem(settingsAssembleAllAction);
         settingsAssembleAll.setSelected(Globals.getSettings().getAssembleAllEnabled());
      	settingsExceptionHandler = new JMenuItem(settingsExceptionHandlerAction);
			      	
         settings.add(settingsLabel);
         settings.add(settingsExtended);
			settings.add(settingsAssembleOnOpen);
			settings.add(settingsAssembleAll);
         settings.add(settingsAddressDisplayBase);
         settings.add(settingsValueDisplayBase);
			settings.addSeparator();
			settings.add(settingsExceptionHandler);
      			
         helpHelp = new JMenuItem(helpHelpAction);
         helpHelp.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"Help16.png"))));//"Help16.gif"))));
         helpAbout = new JMenuItem(helpAboutAction);
         helpAbout.setIcon(new ImageIcon(tk.getImage(cs.getResource(Globals.imagesPath+"MyBlank16.gif"))));
         help.add(helpHelp);
         help.addSeparator();
         help.add(helpAbout);
      
         menuBar.add(file);
         menuBar.add(edit);
         menuBar.add(run);
         menuBar.add(settings);
         JMenu toolMenu = new ToolLoader().buildToolsMenu();
         if (toolMenu != null) menuBar.add(toolMenu);
         menuBar.add(help);
      	
      	// experiment with popup menu for settings. 3 Aug 2006 PS
         //setupPopupMenu();
      	
         return menuBar;
      }
   
    /**
     * build the toolbar and connect items to action objects (which serve as action listeners
     * shared between toolbar icon and corresponding menu item).
     */
   
       public JToolBar setUpToolBar() {
         JToolBar toolBar = new JToolBar();
      	
         New = new JButton(fileNewAction);
         New.setText("");
         Open = new JButton(fileOpenAction);
         Open.setText(""); 
         Save = new JButton(fileSaveAction);
         Save.setText("");
         SaveAs = new JButton(fileSaveAsAction);
         SaveAs.setText("");
         Print= new JButton(filePrintAction);
         Print.setText("");
      
         Undo = new JButton(editUndoAction);
         Undo.setText(""); 
         Redo = new JButton(editRedoAction);
         Redo.setText("");   	
         Cut= new JButton(editCutAction);
         Cut.setText("");
         Copy= new JButton(editCopyAction);
         Copy.setText("");
         Paste= new JButton(editPasteAction);
         Paste.setText("");
      	
         Run = new JButton(runGoAction);
         Run.setText("");
         Assemble = new JButton(runAssembleAction);
         Assemble.setText(""); 
         Step = new JButton(runStepAction);
         Step.setText(""); 
         Backstep = new JButton(runBackstepAction);
         Backstep.setText("");
         Reset = new JButton(runResetAction);
         Reset.setText(""); 
         Stop = new JButton(runStopAction);
         Stop.setText("");
         Pause = new JButton(runPauseAction);
         Pause.setText("");      	
         Help= new JButton(helpHelpAction);
         Help.setText("");
         
         toolBar.add(New);
         toolBar.add(Open);
         toolBar.add(Save);
         toolBar.add(SaveAs);
         toolBar.add(Print);
         toolBar.add(new JToolBar.Separator());
         toolBar.add(Undo);
         toolBar.add(Redo);
         toolBar.add(Cut);
         toolBar.add(Copy);
         toolBar.add(Paste);
         toolBar.add(new JToolBar.Separator());
         toolBar.add(Assemble);
         toolBar.add(Run);   
         toolBar.add(Step);
         toolBar.add(Backstep);
         toolBar.add(Pause);
         toolBar.add(Stop);
         toolBar.add(Reset);
         toolBar.add(new JToolBar.Separator());
         toolBar.add(Help);
         toolBar.add(new JToolBar.Separator());
      	
         return toolBar;
      }
      
   	
    /** Determine from FileStatus what the menu state (enabled/disabled)should 
     * be then call the appropriate method to set it.  Current states are:
     *
     * setMenuStateInitial: set upon startup and after File->Close
     * setMenuStateEditingNew: set upon File->New
     * setMenuStateEditing: set upon File->Open or File->Save or erroneous Run->Assemble
     * setMenuStateRunnable: set upon successful Run->Assemble
     * setMenuStateRunning: set upon Run->Go
     * setMenuStateTerminated: set upon completion of simulated execution
     */
       public void setMenuState(int status) {
         switch (status) {
            case FileStatus.NO_FILE:
               setMenuStateInitial();
               break;
            case FileStatus.NEW_NOT_EDITED:
               setMenuStateEditingNew();
               break;
            case FileStatus.NEW_EDITED:
               setMenuStateEditingNew();
               break;
            case FileStatus.NOT_EDITED:
               setMenuStateEditing();
               break;
            case FileStatus.EDITED:
               setMenuStateEditing();
               break;
            case FileStatus.RUNNABLE:
               setMenuStateRunnable();
               break;
            case FileStatus.RUNNING:
               setMenuStateRunning();
               break;
            case FileStatus.TERMINATED:
               setMenuStateTerminated();
               break;
            default:
               System.out.println("Invalid File Status: "+status);
               break;
         }
      }
     
     
       void setMenuStateInitial() {
         fileNewAction.setEnabled(true);
         fileOpenAction.setEnabled(true);
         fileCloseAction.setEnabled(false);
         fileSaveAction.setEnabled(false);
         fileSaveAsAction.setEnabled(false);
         filePrintAction.setEnabled(false);
         fileExitAction.setEnabled(true);
         editUndoAction.setEnabled(false);
         editRedoAction.setEnabled(false);
         editCutAction.setEnabled(false);
         editCopyAction.setEnabled(false);
         editPasteAction.setEnabled(false);
         runAssembleAction.setEnabled(false);
         runGoAction.setEnabled(false);
         runStepAction.setEnabled(false);
         runBackstepAction.setEnabled(false);
         runResetAction.setEnabled(false);
         runStopAction.setEnabled(false);
         runPauseAction.setEnabled(false);
         runClearBreakpointsAction.setEnabled(false);
         helpHelpAction.setEnabled(true);
         helpAboutAction.setEnabled(true);
         editUndoAction.updateUndoState();
         editRedoAction.updateRedoState();
      }
   
       void setMenuStateEditing() {
      /* Note: undo and redo are handled separately by the undo manager*/  
         fileNewAction.setEnabled(true);
         fileOpenAction.setEnabled(true);
         fileCloseAction.setEnabled(true);
         fileSaveAction.setEnabled(true);
         fileSaveAsAction.setEnabled(true);
         filePrintAction.setEnabled(true);
         fileExitAction.setEnabled(true);
         editCutAction.setEnabled(true);
         editCopyAction.setEnabled(true);
         editPasteAction.setEnabled(true);
         runAssembleAction.setEnabled(true);
         runGoAction.setEnabled(false);
         runStepAction.setEnabled(false);
         runBackstepAction.setEnabled(false);
         runResetAction.setEnabled(false);
         runStopAction.setEnabled(false);
         runPauseAction.setEnabled(false);
         runClearBreakpointsAction.setEnabled(false);
         helpHelpAction.setEnabled(true);
         helpAboutAction.setEnabled(true);
         editUndoAction.updateUndoState();
         editRedoAction.updateRedoState();
      }
   
     /* Use this when "File -> New" is used, to force user into Save As
      */
       void setMenuStateEditingNew() {
      /* Note: undo and redo are handled separately by the undo manager*/  
         fileNewAction.setEnabled(true);
         fileOpenAction.setEnabled(true);
         fileCloseAction.setEnabled(true);
         fileSaveAction.setEnabled(false);
         fileSaveAsAction.setEnabled(true);
         filePrintAction.setEnabled(true);
         fileExitAction.setEnabled(true);
         editCutAction.setEnabled(true);
         editCopyAction.setEnabled(true);
         editPasteAction.setEnabled(true);
         runAssembleAction.setEnabled(false);
         runGoAction.setEnabled(false);
         runStepAction.setEnabled(false);
         runBackstepAction.setEnabled(false);
         runResetAction.setEnabled(false);
         runStopAction.setEnabled(false);
         runPauseAction.setEnabled(false);
         runClearBreakpointsAction.setEnabled(false);
         helpHelpAction.setEnabled(true);
         helpAboutAction.setEnabled(true);
         editUndoAction.updateUndoState();
         editRedoAction.updateRedoState();
      }
    	 
     /* Use this upon successful assemble or reset
      */
       void setMenuStateRunnable() {
      /* Note: undo and redo are handled separately by the undo manager */  
         fileNewAction.setEnabled(true);
         fileOpenAction.setEnabled(true);
         fileCloseAction.setEnabled(true);
         fileSaveAction.setEnabled(true);
         fileSaveAsAction.setEnabled(true);
         filePrintAction.setEnabled(true);
         fileExitAction.setEnabled(true);
         editCutAction.setEnabled(true);
         editCopyAction.setEnabled(true);
         editPasteAction.setEnabled(true);
         runAssembleAction.setEnabled(true);
         runGoAction.setEnabled(true);
         runStepAction.setEnabled(true);
         runBackstepAction.setEnabled(
            (Globals.getSettings().getBackSteppingEnabled()&& !Globals.program.getBackStepper().empty())
             ? true : false);
         runResetAction.setEnabled(true);
         runStopAction.setEnabled(false);
         runPauseAction.setEnabled(false);
         helpHelpAction.setEnabled(true);
         helpAboutAction.setEnabled(true);
         editUndoAction.updateUndoState();
         editRedoAction.updateRedoState();
      }
   
     /* Use this while program is running
      */
       void setMenuStateRunning() {
      /* Note: undo and redo are handled separately by the undo manager */  
         fileNewAction.setEnabled(false);
         fileOpenAction.setEnabled(false);
         fileCloseAction.setEnabled(false);
         fileSaveAction.setEnabled(false);
         fileSaveAsAction.setEnabled(false);
         filePrintAction.setEnabled(false);
         fileExitAction.setEnabled(false);
         editCutAction.setEnabled(false);
         editCopyAction.setEnabled(false);
         editPasteAction.setEnabled(false);
         runAssembleAction.setEnabled(false);
         runGoAction.setEnabled(false);
         runStepAction.setEnabled(false);
         runBackstepAction.setEnabled(false);
         runResetAction.setEnabled(false);
         runStopAction.setEnabled(true);
         runPauseAction.setEnabled(true);
         helpHelpAction.setEnabled(true);
         helpAboutAction.setEnabled(true);
         editUndoAction.updateUndoState();
         editRedoAction.updateRedoState();
      }   
     /* Use this upon completion of execution
      */
       void setMenuStateTerminated() {
      /* Note: undo and redo are handled separately by the undo manager */  
         fileNewAction.setEnabled(true);
         fileOpenAction.setEnabled(true);
         fileCloseAction.setEnabled(true);
         fileSaveAction.setEnabled(true);
         fileSaveAsAction.setEnabled(true);
         filePrintAction.setEnabled(true);
         fileExitAction.setEnabled(true);
         editCutAction.setEnabled(true);
         editCopyAction.setEnabled(true);
         editPasteAction.setEnabled(true);
         runAssembleAction.setEnabled(true);
         runGoAction.setEnabled(false);
         runStepAction.setEnabled(false);
         runBackstepAction.setEnabled(
            (Globals.getSettings().getBackSteppingEnabled()&& !Globals.program.getBackStepper().empty())
             ? true : false);
         runResetAction.setEnabled(true);
         runStopAction.setEnabled(false);
         runPauseAction.setEnabled(false);
         helpHelpAction.setEnabled(true);
         helpAboutAction.setEnabled(true);
         editUndoAction.updateUndoState();
         editRedoAction.updateRedoState();
      }
   
   /* Method optionally used by File->Open to give it access to the
   *  File->Close action.  It uses this for a cleaner look, by closing
   *  the current file before doing the open.
   *  Un-comment this method if you want to use that technique in File->Open.
   *  There is also a line of code in FileOpenAction that you have to un-comment.
   
       public Action getFileCloseAction() {
         return fileCloseAction;
      }
   */
    
      
   	/**
   	  *  To set whether the register values are reset.
   	  *   @param b Boolean true if the register values have been reset.
   	  **/
   	
       public static void setReset(boolean b){
         reset=b;
      }
   
   	/**
   	  *  To set whether MIPS program execution has started.
   	  *   @param b true if the MIPS program execution has started.
   	  **/
   	
       public static void setStarted(boolean b){ 
         started=b;
      }
      /**
   	  *  To find out whether the register values are reset.
   	  *   @return Boolean true if the register values have been reset.
   	  **/
      
       public static boolean getReset(){
         return reset;
      }
   	
      /**
   	  *  To find out whether MIPS program is currently executing.
   	  *   @return  true if MIPS program is currently executing.
   	  **/
       public static boolean getStarted(){
         return started;
      }
   	
      /**
   	  *  Get reference to messages pane associated with this GUI.
   	  *   @return MessagesPane object associated with the GUI.
   	  **/
         	
       public MainPane getMainPane() {
         return mainPane;
      }		
      /**
   	  *  Get reference to messages pane associated with this GUI.
   	  *   @return MessagesPane object associated with the GUI.
   	  **/
         	
       public MessagesPane getMessagesPane() {
         return messagesPane;
      }
   
      /**
   	  *  Get reference to registers pane associated with this GUI.
   	  *   @return RegistersPane object associated with the GUI.
   	  **/
         	
       public RegistersPane getRegistersPane() {
         return registersPane;
      }   	
   
      /**
   	  *  Get reference to settings menu item for display base of memory/register values.
   	  *   @return the menu item
   	  **/
         	
       public JCheckBoxMenuItem getValueDisplayBaseMenuItem() {
         return settingsValueDisplayBase;
      }   	     
   
      /**
   	  *  Get reference to settings menu item for display base of memory/register values.
   	  *   @return the menu item
   	  **/
         	
       public JCheckBoxMenuItem getAddressDisplayBaseMenuItem() {
         return settingsAddressDisplayBase;
      }   	          
   	
   	/**
   	 * Return reference tothe Run->Assemble item's action.  Needed by File->Open in case
   	 * assemble-upon-open flag is set.
   	 * @return the Action object for the Run->Assemble operation.
   	 */
       public Action getRunAssembleAction() {
         return runAssembleAction;
      }
     
     // pop up menu experiment 3 Aug 2006.  Keep for possible later revival.
       private void setupPopupMenu() {
         JPopupMenu popup; 
         popup = new JPopupMenu();
      	// cannot put the same menu item object on two different menus.
      	// If you want to duplicate functionality, need a different item.
      	// Should be able to share listeners, but if both menu items are
      	// JCheckBoxMenuItem, how to keep their checked status in synch?
      	// If you popup this menu and check the box, the right action occurs
      	// but its counterpart on the regular menu is not checked.
         popup.add(new JCheckBoxMenuItem(settingsLabelAction)); 
      //Add listener to components that can bring up popup menus. 
         MouseListener popupListener = new PopupListener(popup); 
         this.addMouseListener(popupListener); 
      }
     
   
   
   }