   package mars.venus;
   import mars.*;
   import mars.assembler.*;
   import mars.mips.instructions.*;
   import java.util.*;
   import java.io.*;
   import java.awt.*;
   import java.awt.event.*;
   import javax.swing.*;
   import javax.swing.text.html.*;
	
	/*
Copyright (c) 2003-2006,  Pete Sanderson and Kenneth Vollmar

Developed by Pete Sanderson (psanderson@otterbein.edu)
and Kenneth Vollmar (kenvollmar@missouristate.edu)

Permission is hereby granted, free of charge, to any person obtaining 
a copy of this software and associated documentation files (the 
"Software"), to deal in the Software without restriction, including 
without limitation the rights to use, copy, modify, merge, publish, 
distribute, sublicense, and/or sell copies of the Software, and to 
permit persons to whom the Software is furnished to do so, subject 
to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR 
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

(MIT license, http://www.opensource.org/licenses/mit-license.html)
 */
	
    /**
    * Action  for the Help -> Help menu item
    */   			
    public class HelpHelpAction extends GuiAction {
       public  HelpHelpAction(String name, Icon icon, String descrip,
                             Integer mnemonic, KeyStroke accel, VenusUI gui) {
         super(name, icon, descrip, mnemonic, accel, gui);
      }
   	
   	// ideally read or computed from config file...
       private Dimension getSize() {
         return new Dimension(600,600);
      }
   	
   	/**
   	 * Displays tabs with categories of information
   	 */	  
       public void actionPerformed(ActionEvent e) {
         JTabbedPane tabbedPane = new JTabbedPane();
         tabbedPane.addTab("MIPS", createMipsHelpInfoPanel());
         tabbedPane.addTab("MARS", createHTMLHelpPanel("MarsHelp.html"));
         tabbedPane.addTab("Bug Reporting and Comments", createHTMLHelpPanel("BugReportingHelp.html"));   
         tabbedPane.addTab("License", createCopyrightInfoPanel()); 
         tabbedPane.addTab("Instruction Set Song", createHTMLHelpPanel("MIPSInstructionSetSong.html"));
         // Create non-modal dialog. Based on java.sun.com "How to Make Dialogs", DialogDemo.java		
         final JDialog dialog = new JDialog(mainUI, "MARS "+Globals.version+" Help");
      	// assure the dialog goes away if user clicks the X
         dialog.addWindowListener(
                new WindowAdapter() {
                   public void windowClosing(WindowEvent e) {
                     dialog.setVisible(false);
                     dialog.dispose();
                  }
               });
         //Add a "close" button to the non-modal help dialog.
         JButton closeButton = new JButton("Close");
         closeButton.addActionListener(
                new ActionListener() {
                   public void actionPerformed(ActionEvent e) {
                     dialog.setVisible(false);
                     dialog.dispose();
                  }
               });
         JPanel closePanel = new JPanel();
         closePanel.setLayout(new BoxLayout(closePanel,BoxLayout.LINE_AXIS));
         closePanel.add(Box.createHorizontalGlue());
         closePanel.add(closeButton);
         closePanel.setBorder(BorderFactory.createEmptyBorder(0,0,5,5));
         JPanel contentPane = new JPanel();
         contentPane.setLayout(new BoxLayout(contentPane,BoxLayout.PAGE_AXIS));
         contentPane.add(tabbedPane);
         contentPane.add(Box.createRigidArea(new Dimension(0,5)));
         contentPane.add(closePanel);
         contentPane.setOpaque(true);
         dialog.setContentPane(contentPane);      
         //Show it.
         dialog.setSize(this.getSize());
         dialog.setLocationRelativeTo(mainUI);
         dialog.setVisible(true);
      
      //////////////////////////////////////////////////////////////////
      }
   	
   	
   	// Create panel containing Help Info read from html document.
       private JPanel createHTMLHelpPanel(String filename) {
         JPanel helpPanel = new JPanel(new BorderLayout());
         JScrollPane helpScrollPane;
         JEditorPane helpDisplay;  
         try {
            InputStream is = this.getClass().getResourceAsStream(Globals.helpPath+filename);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));        
            String line;
            StringBuffer text = new StringBuffer();
            while ( (line=in.readLine()) != null ) {
               text.append(line+"\n");
            }
            in.close();
            helpDisplay = new JEditorPane("text/html",text.toString());
            helpDisplay.setEditable(false);
            helpDisplay.setCaretPosition(0); // assure top of document displayed
            helpScrollPane = new JScrollPane(helpDisplay, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                            JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
         } 
             catch (Exception ie) {
               helpScrollPane = new JScrollPane(
                       new JLabel("Error ("+ie+"): "+filename+" contents could not be loaded."));
            }
         helpPanel.add(helpScrollPane);
         return helpPanel;
      }		
   
     	
   	// Set up the copyright notice for display.
       private JPanel createCopyrightInfoPanel() {
         JPanel marsCopyrightInfo = new JPanel(new BorderLayout());
         JScrollPane marsCopyrightScrollPane;
         JEditorPane marsCopyrightDisplay;  
         try {
            InputStream is = this.getClass().getResourceAsStream("/MARSlicense.txt");
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String line;
            StringBuffer text = new StringBuffer("<pre>");
            while ( (line=in.readLine()) != null ) {
               text.append(line+"\n");
            }
            in.close();
            text.append("</pre>");        
            marsCopyrightDisplay = new JEditorPane("text/html",text.toString());
            marsCopyrightDisplay.setEditable(false);
            marsCopyrightDisplay.setCaretPosition(0); // assure top of document displayed
            marsCopyrightScrollPane = new JScrollPane(marsCopyrightDisplay, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                            JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
         }
             catch (Exception ioe) {
               marsCopyrightScrollPane = new JScrollPane(
                       new JLabel("Error: license contents could not be loaded."));
            }
         marsCopyrightInfo.add(marsCopyrightScrollPane);
         return marsCopyrightInfo;
      }
   	
   	
   	// Set up MIPS help tab.  Most contents are generated from instruction set info.
       private JPanel createMipsHelpInfoPanel() {
         JPanel mipsHelpInfo = new JPanel(new BorderLayout());
       // Introductory remarks go at the top as a label
         String helpRemarks = "<html>MARS "+Globals.version+ " assembles and simulates the MIPS-32 instructions and directives" +
            " listed below.<br><br>Instruction format key:  <tt>$n</tt> means integer register, " +
            "<tt>$fn</tt> means floating point register, <tt>1</tt> means condition flag (0-7), " +
            "<tt>10</tt> means 5-bit integer, <tt>100</tt> means 16-bit integer, " + 
            "<tt>100000</tt> means 32-bit integer, <tt>label</tt> and <tt>target</tt> mean " +
            "textual labels.<br><br>See a MIPS language reference for further details.<br><br></html>";
         mipsHelpInfo.add(new JLabel(helpRemarks), BorderLayout.NORTH);
         // Below the label is a tabbed pane with categories of MIPS help
         JTabbedPane tabbedPane = new JTabbedPane();
         tabbedPane.addTab("Basic Instructions", createMipsInstructionHelpPane("mars.mips.instructions.BasicInstruction"));
         tabbedPane.addTab("Extended (pseudo) Instructions", createMipsInstructionHelpPane("mars.mips.instructions.ExtendedInstruction"));
         tabbedPane.addTab("Directives", createMipsDirectivesHelpPane());
         tabbedPane.addTab("Syscalls", createHTMLHelpPanel("SyscallHelp.html"));
         mipsHelpInfo.add(tabbedPane);
         return mipsHelpInfo;
      }
   	
   	///////////////  Methods to construct MIPS help tabs from internal MARS objects  //////////////
   				 
       /////////////////////////////////////////////////////////////////////////////
       private JScrollPane createMipsDirectivesHelpPane() {
         Vector exampleList = new Vector();
         String blanks = "            ";  // 12 blanks
			Directives direct;
         Iterator it = Directives.getDirectiveList().iterator();
         while (it.hasNext()) {
			direct = (Directives)it.next();
            exampleList.add(direct.toString()
				                + blanks.substring(0,Math.max(0,blanks.length()-direct.toString().length()))
                     			  + direct.getDescription());
         }
         Collections.sort(exampleList);
         JList examples = new JList(exampleList);
         JScrollPane mipsScrollPane = new JScrollPane(examples,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                            JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 
         examples.setFont(new Font("Monospaced",Font.PLAIN,12));
         return mipsScrollPane;
      }
   	
   	 ////////////////////////////////////////////////////////////////////////////
       private JScrollPane createMipsInstructionHelpPane(String instructionClassName) {
         ArrayList instructionList = Globals.instructionSet.getInstructionList();
         Vector exampleList = new Vector(instructionList.size());
         Iterator it = instructionList.iterator();
         Instruction instr;
         String blanks = "                        ";  // 24 blanks
         Class instructionClass;
         while (it.hasNext()) {
            instr = (Instruction) it.next();
            try {
               if (Class.forName(instructionClassName).isInstance(instr)) {
                  exampleList.add(instr.getExampleFormat() 
                                + blanks.substring(0,Math.max(0,blanks.length()-instr.getExampleFormat().length()))
                     			  + instr.getDescription());
               }
            }
                catch (ClassNotFoundException cnfe) {
                  System.out.println(cnfe+" "+instructionClassName);
               }
         }
         Collections.sort(exampleList);
         JList examples = new JList(exampleList);
         JScrollPane mipsScrollPane = new JScrollPane(examples,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                            JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 
         examples.setFont(new Font("Monospaced",Font.PLAIN,12));
         return mipsScrollPane;
      }
   	     	
   }
