   package mars.venus;
   import mars.*;
   import java.io.*;

/*
Copyright (c) 2003-2006,  Pete Sanderson and Kenneth Vollmar

Developed by Pete Sanderson (psanderson@otterbein.edu)
and Kenneth Vollmar (kenvollmar@missouristate.edu)

Permission is hereby granted, free of charge, to any person obtaining 
a copy of this software and associated documentation files (the 
"Software"), to deal in the Software without restriction, including 
without limitation the rights to use, copy, modify, merge, publish, 
distribute, sublicense, and/or sell copies of the Software, and to 
permit persons to whom the Software is furnished to do so, subject 
to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR 
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

(MIT license, http://www.opensource.org/licenses/mit-license.html)
 */

   /**
	  *  Used to store and return information on the status of the current ASM file that
	  *  is being edited in the program.
	  *   @author Team JSpim
	  **/
	  
    public class FileStatus{
	   /** initial state or after close */
	   public static final int NO_FILE = 0;  
		/** New edit window with no edits */
		public static final int NEW_NOT_EDITED = 1; 
		/** New edit window with unsaved edits */
		public static final int NEW_EDITED = 2;  
		/** open/saved edit window with no edits */
		public static final int NOT_EDITED = 3; 
		/** open/saved edit window with unsaved edits */
		public static final int EDITED = 4;  
		/** successful assembly */
		public static final int RUNNABLE = 5; 
		/** execution is under way */
		public static final int RUNNING = 6; 
		/** execution terminated */
		public static final int TERMINATED = 7; 

      private static int status; // set to one of the above
      private static boolean assembled;
      private static boolean saved;
      private static boolean edited;
      private static String name;
      private static File file;
   
	   /**
		 * Set file status.  Also updates menu state accordingly.
		 * 
		 * @param newStatus  New status: EDITED, RUNNABLE, etc, see list above.
		 */
	   public static void set(int newStatus) {
		  status = newStatus;
		  Globals.getGui().setMenuState(status);
		}
		
	   /**
		 * Get file status
		 * 
		 * @return file status EDITED, RUNNABLE, etc, see list above
		 */		
		public static int get() {
		  return status;
		}
	   
      /**
   	  *  Changes the value of assenbked to the parameter given.
   	  *   @param b boolean variable that tells what to set assembled to.
   	  **/
   
       public static void setAssembled(boolean b){
         assembled= b;
      }
      
   	/**
   	  *  Changes the value of saved to the parameter given.
   	  *   @param b boolean variable that tells what to set saved to .
   	  **/
   
       public static void setSaved(boolean b){
         saved= b;
      }
   
      /**
   	  *  Changes the value of edited to the parameter given.
   	  *   @param b boolean variable that tells what to set edited to.
   	  **/
   
       public static void setEdited(boolean b){
         edited= b;
      }
   
    	/**
   	  *  Changes the value of name to the parameter given.
   	  *   @param s string variable tells what to set the name of the file to .
   	  **/
   
       public static void setName(String s){
         name = s;
      }
      
   	/**
   	  *  Sets the file to the ASM file passed.
   	  *   @param f file object variable that stores the ASM file.
   	  **/
      
       public static void setFile(File f){
         file= f;
      }
      
      /**
   	  *  Returns the ASM file.
   	  *   @return The ASM file.
   	  **/	
   	
       public static File getFile(){
         return file;
      }
      
   	/**
   	  *  Returns the name of the file.
   	  *   @return The name of the ASM file.
   	  **/
   
       public static String getName(){
         return name;
      }
      
   	/**
   	  *  Tells whether the file has been assembled.
   	  *   @return Boolean value that is true if the ASM file has been assembled.
   	  **/
   
       public static boolean isAssembled(){
         return assembled;
      }
      
   	/**
   	  *  Tells whether the file has been saved.
   	  *   @return Boolean variable that is true if the ASM file has been saved
   	  **/
   
       public static boolean isSaved(){
         return saved;
      }
      
   	/**
   	  *  Tells whether the file has been edited since it has been saved.
   	  *   @return Boolean value that returns true if the ASM file has been edited.
   	  **/
   
       public static boolean isEdited(){
         return edited;
      }
      
   	/**
   	  *  Resets all the values in FileStatus
   	  **/
   
       public static void reset(){
		   status = NO_FILE;
         name= "";
         assembled= false;
         saved= false;
         edited= false;
         file= null;
      }
   }