   package mars.venus;
   import mars.*;
   import mars.util.*;
   import java.awt.*;
   import java.awt.event.*;
   import javax.swing.*;
   import javax.swing.filechooser.FileFilter;
   import java.io.*;
	
	/*
Copyright (c) 2003-2006,  Pete Sanderson and Kenneth Vollmar

Developed by Pete Sanderson (psanderson@otterbein.edu)
and Kenneth Vollmar (kenvollmar@missouristate.edu)

Permission is hereby granted, free of charge, to any person obtaining 
a copy of this software and associated documentation files (the 
"Software"), to deal in the Software without restriction, including 
without limitation the rights to use, copy, modify, merge, publish, 
distribute, sublicense, and/or sell copies of the Software, and to 
permit persons to whom the Software is furnished to do so, subject 
to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR 
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

(MIT license, http://www.opensource.org/licenses/mit-license.html)
 */
 
    /**
    * Action  for the File -> Open menu item
    */   			
    public class FileOpenAction extends GuiAction {
    
      private File mostRecentlyOpenedFile;
   	 
       public FileOpenAction(String name, Icon icon, String descrip,
                             Integer mnemonic, KeyStroke accel, VenusUI gui) {
         super(name, icon, descrip, mnemonic, accel, gui);
         mostRecentlyOpenedFile = null;
      }
   
       /**
   	  * Launch a file chooser for name of file to open
   	  *
   	  * @param e component triggering this call
   	  */
       public void actionPerformed(ActionEvent e) {
         EditPane editPane = mainUI.getMainPane().getEditPane();
         if (!mainUI.editor.editsSavedOrAbandoned()) {
            return;
         }
      
         /* To get a slightly cleaner "look" in the environment of "only one file can be
      	 * open at a time", then do the fileCloseAction.actionPerformed() statements here.
      	 * It will reset the editing area, filename, and menu items.  It presents
      	 * a cleaner background for the file open dialog.  
      	 *
      	 * This feature is implemented by the following commented-out statement.  Activate
      	 * it by uncommenting and recompiling.  You also need to un-comment the 
      	 * getFileCloseAction() method in JSPIMUI class.
      	 */
         // mainUI.getFileCloseAction().actionPerformed(new ActionEvent(this,0,""));
      
      
         /* get name of file to be opened and load contents into text editing area.
      	 */
         JFileChooser fileChooser = new JFileChooser(editPane.getCurrentDirectoryPath());
         // Set default to previous file opened, if any.  This is useful in conjunction
      	// with option to assemble file automatically upon opening.  File likely to have
      	// been edited externally (e.g. by Mipster).
         if (Globals.getSettings().getAssembleOnOpenEnabled() && mostRecentlyOpenedFile != null) {
            fileChooser.setSelectedFile(mostRecentlyOpenedFile);
         }
			FileFilter defaultFileFilter = FilenameFinder.getFileFilter(Globals.fileExtensions, "Assembler Files", true);
         fileChooser.addChoosableFileFilter(defaultFileFilter); 
         fileChooser.addChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
         fileChooser.setFileFilter(defaultFileFilter);      
         if (fileChooser.showOpenDialog(editPane) == JFileChooser.APPROVE_OPTION) {
            File theFile = fileChooser.getSelectedFile();
            try {
               theFile = theFile.getCanonicalFile();
            } 
                catch (IOException ioe) {
               // nothing to do, theFile will keep current value
               }
            String currentFilePath = theFile.getPath();
            FileStatus.reset();
            FileStatus.setName(currentFilePath);
            FileStatus.setFile(theFile);
            if (theFile.canRead()) {
               Globals.program = new MIPSprogram();
               try {
                  Globals.program.readSource(currentFilePath);
               } 
                   catch (ProcessingException pe) {
                  }
               editPane.setSourceCode(null,true);
            	// DPS 1 Nov 2006.  Defined a StringBuffer to receive all file contents, 
            	// one line at a time, before adding to the Edit pane with one append.
            	// StringBuffer is preallocated to full filelength to eliminate dynamic
            	// expansion as lines are added to it. Previously, each line was appended 
            	// to the Edit pane as it was read, way slower due to dynamic string alloc.  
               StringBuffer fileContents = new StringBuffer((int)theFile.length());
               int lineNumber = 1;
               String line = Globals.program.getSourceLine(lineNumber++);
               while (line != null) {
                  fileContents.append(line+"\n");
                  line = Globals.program.getSourceLine(lineNumber++);
               }
               editPane.append(fileContents.toString());
               editPane.setCurrentDirectoryPath(fileChooser.getCurrentDirectory().getPath());
               editPane.setShowLineNumbersEnabled(true);
               FileStatus.setSaved(true);
               FileStatus.setEdited(false);
               mainUI.editor.setFrameTitle();
               editPane.getUndoManager().discardAllEdits();
               FileStatus.set(FileStatus.NOT_EDITED);
               mainUI.getMainPane().getExecutePane().clearPane();
               mainUI.getMainPane().setSelectedComponent(editPane);
               mostRecentlyOpenedFile = theFile;
                // possibly send this file right through to the assembler by firing Run->Assemble's
            	 // actionPerformed() method.
               if (Globals.getSettings().getAssembleOnOpenEnabled()) {
                  mainUI.getRunAssembleAction().actionPerformed(null);
               }
            }
         }
                  
      }
   }      
