   package mars.mips.instructions.syscalls;
   import mars.util.*;
   import mars.mips.hardware.*;
	import mars.simulator.*;
   import mars.*;

/*
Copyright (c) 2003-2006,  Pete Sanderson and Kenneth Vollmar

Developed by Pete Sanderson (psanderson@otterbein.edu)
and Kenneth Vollmar (kenvollmar@missouristate.edu)

Permission is hereby granted, free of charge, to any person obtaining 
a copy of this software and associated documentation files (the 
"Software"), to deal in the Software without restriction, including 
without limitation the rights to use, copy, modify, merge, publish, 
distribute, sublicense, and/or sell copies of the Software, and to 
permit persons to whom the Software is furnished to do so, subject 
to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR 
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

(MIT license, http://www.opensource.org/licenses/mit-license.html)
 */


/** 
 * Service to open file name specified by $a0. File descriptor returned in $a0.
 *
 */
 
    public class SyscallOpen extends AbstractSyscall {
   /**
    * Build an instance of the Open file syscall.  Default service number
    * is 13 and name is "Open".
    */
       public SyscallOpen() {
         super(13, "Open");
      }
      
   /**
   * Performs syscall function to open file name specified by $a0. File descriptor returned
	* in $a0.  Note that Read/Write mode ($a2) is not implemented and flags ($a1) are ignored. 
   */
       public void simulate(ProgramStatement statement) throws ProcessingException {
          // Arguments: $a0 = filename (string), $a1 = flags, $a2 = mode
          // Result: file descriptor (in $a0)
          // This code implements the modes:
          // Read          mode = 0
          // Write         mode = 1
          // Read/Write    NOT IMPLEMENTED
          // This code implements the flags:
          // NO FLAGS IMPLEMENTED  -- FLAGS ARE IGNORED
          // Returns in $a0: a "file descriptor" in the range 0 to SystemIO.SYSCALL_MAXFILES-1,
          // or -1 if error
         String filename = new String(); // = "";
         int byteAddress = RegisterFile.getValue(4);
         char ch[] = { ' '}; // Need an array to convert to String
         try
         {
            ch[0] = (char) Globals.memory.getByte(byteAddress);
            while (ch[0] != 0) // only uses single location ch[0]
            {
               filename = filename.concat(new String(ch)); // parameter to String constructor is a char[] array
               byteAddress++;
               ch[0] = (char) Globals.memory.getByte(
                                        byteAddress);
            }
         } 
             catch (AddressErrorException e)
            {
               throw new ProcessingException(statement, e);
            }
         int retValue = SystemIO.openFile(filename,
                                 RegisterFile.getValue(6));
         RegisterFile.updateRegister(4, retValue); // set returned fd value in register
         if (retValue < 0) // some error in opening file
         {
            throw new ProcessingException(statement,
                SystemIO.getFileErrorMessage()+" (syscall "+this.getNumber()+")", 
					 Exceptions.SYSCALL_EXCEPTION);
         }
      }
   }