   package mars;
   import java.awt.*;
   import javax.swing.*;

/*
Copyright (c) 2003-2006,  Pete Sanderson and Kenneth Vollmar

Developed by Pete Sanderson (psanderson@otterbein.edu)
and Kenneth Vollmar (kenvollmar@missouristate.edu)

Permission is hereby granted, free of charge, to any person obtaining 
a copy of this software and associated documentation files (the 
"Software"), to deal in the Software without restriction, including 
without limitation the rights to use, copy, modify, merge, publish, 
distribute, sublicense, and/or sell copies of the Software, and to 
permit persons to whom the Software is furnished to do so, subject 
to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR 
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

(MIT license, http://www.opensource.org/licenses/mit-license.html)
 */

/**
 * Produces MARS splash screen.<br>
 * Adapted from http://www.java-tips.org/content/view/1267/2/<br>
 */

    public class MarsSplashScreen extends JWindow {
      
      private int duration;
      
       public MarsSplashScreen(int d) {
         duration = d;
      }
      
      /**
   	 * A simple little method to show a title screen in the center
       * of the screen for the amount of time given in the constructor
   	 */
       public void showSplash() {
         Color bgColor = Color.black;
         Color fgColor = Color.white;
         JPanel content = (JPanel)getContentPane();
         content.setBackground(bgColor);
         
         // Set the window's bounds, centering the window
         int width = 400;
         int height =200;
         Toolkit tk = Toolkit.getDefaultToolkit();
         Dimension screen = tk.getScreenSize();
         int x = (screen.width-width)/2;
         int y = (screen.height-height)/2;
         setBounds(x,y,width,height);
         
         // Build the splash screen
         JLabel picture = new JLabel(new ImageIcon(tk.getImage(this.getClass().getResource(Globals.imagesPath+"MarsThumbnail.gif"))));
         JLabel title = new JLabel("MARS: Mips Assembler and Runtime Simulator", JLabel.CENTER);      
         JLabel copyrt1 = new JLabel
               ("Version "+Globals.version+" Copyright (c) "+Globals.copyrightYears, JLabel.CENTER);
         JLabel copyrt2 = new JLabel
               (Globals.copyrightHolders, JLabel.CENTER);
         copyrt1.setFont(new Font("Sans-Serif", Font.BOLD, 12));
         copyrt2.setFont(new Font("Sans-Serif", Font.BOLD, 12));
         copyrt1.setForeground(fgColor);
         copyrt2.setForeground(fgColor);
         title.setFont(new Font("Sans-Serif", Font.BOLD, 16));
         title.setForeground(fgColor);
         JPanel titles = new JPanel(new GridLayout(2,1));
         titles.add(new JLabel(" "));
         titles.add(title);
         titles.setBackground(bgColor);
         content.add(titles, BorderLayout.NORTH);
         content.add(picture, BorderLayout.CENTER);
         JPanel copyrights = new JPanel(new GridLayout(3,1));
         copyrights.setBackground(bgColor);
         copyrights.add(copyrt1);
         copyrights.add(copyrt2);
         copyrights.add(new JLabel(" "));
         content.add(copyrights, BorderLayout.SOUTH);
         Color oraRed = new Color(156, 20, 20, 255);
         content.setBorder(BorderFactory.createLineBorder(oraRed, 3));
         // Display it
         setVisible(true);
         // Wait a little while, maybe while loading resources
         try { Thread.sleep(duration); } 
             catch (Exception e) {}
         setVisible(false);
      }
      
   }
