/**
 * @file      arm9AF-isa.cpp
 * @author    Aline Elias
 *            Felipe Prado
 *
 * @version   0.00000000000000000000000000000000000000000001
 */

#include "archc.H"
#include "ac_types.H"
#include "ac_parms.H"
#include  "arm9AF-isa.H"
#include  "ac_isa_init.cpp"
#include <math.h>

/* Variaveis para manipular dados indiretamente.
   Se desse para manipular diretamente alguns dados , elas nem precisariam existir. */
ac_Uword quantidadeShift;
/* Variaveis para execucao do write back */
ac_Sword shif_op, id_datarn, id_datarm, id_datars, ex_datarn, ex_datarm, ex_datars, immediate_ext, mascara, terceiro_operando;
ac_Uword SRd, SRn, SRm, SSh_Op;


///////////////////////////////////////////////////
// Comportamento generico de todas as instrucoes //
///////////////////////////////////////////////////
void ac_behavior( instruction ){

  switch( stage ) {
  case IF:
    /* Todas els incrementam o pc : */
    ac_pc += 4;
    IF_ID.instruction = ac_pc;
  break;
    
  case ID:
	/* Todas elas verificam o campo 'cond' da instrucao : */
	switch(cond){
	
		case 0x00: //EQ - Equal - Z set
			if(CPSR.z == 1)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x01: //NE - Not Equal - Z clear
			if(CPSR.z == 0)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x02: //CS/HS - Carry Set/Unsigned higher or same - C set
			if(CPSR.c == 1)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x03: //CC/LO - Carry Clear/Unsigned lower - C clear
			if(CPSR.c == 0)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x04: //MI - Minus/Negative - N set
			if(CPSR.n == 1)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x05: //PL- Plus/Positive or zero - N clear
			if(CPSR.n == 0)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x06: //VL - Overflow - V set
			if(CPSR.v == 1)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x07: //VC - No Overflow - V clear
			if(CPSR.v == 0)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x08: //HI - Unsigned Higher - C set and Z clear
			if(CPSR.c == 1 && CPSR.z == 0)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x09: //LS - Unsigned Lower - C clear or Z set
			if(CPSR.c == 0 || CPSR.z == 1)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x0a: //GE - Signed Greather than or Equal - N set and V set or N clear and V clear (N == V)
			if(CPSR.n == CPSR.v)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x0b: //LT - Signed Less than - N set and V clear or N clear and V set (N != V)
			if(CPSR.n != CPSR.v)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x0c: //GT - Signed Greather than - Z clear, and either N set and V set, or N clear and v clear (Z == 0 && N == V) 
			if(CPSR.z == 0 && CPSR.n == CPSR.v)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x0d: //LE - Signed Less than or equal -  Z clear, or N set and V clear, or N clear and v set (Z == 1 || N != V) 
			if(CPSR.z == 1 || CPSR.n != CPSR.v)	ID_EX.flag_cond = 1;	else	ID_EX.flag_cond = 0;
		break;
		case 0x0e: //AL - Always (Unconditional) - executa e pronto
			ID_EX.flag_cond = 0x01;
		break;
		case 0x0f: //NV - Never
			// Depende da versao. Geralmente eh UNPREDICTABLE
		break;
	}	

    break;

  case EX:
  // Cada uma tem sua execucao....
    break;

  case MEM:
  // Algumas acessam a memoria ...
    break;

  case WB:
    // A maioria executa o writeBack. O write back eh executado se o sinal de write back estiver ativo e o registrador de destino nao for r0:
    if ((MEM_WB.regwrite == 1) && (MEM_WB.rd != 0))
	  RB.write(MEM_WB.rd, MEM_WB.wbdata);
    break;

  default:
    break;
  }
};



//////////////////////////////////////////////////////////////////
// Comportamento de todas as instrucoes do tipo Data Processing //
//////////////////////////////////////////////////////////////////
void ac_behavior( Type_DP ){

  switch( stage ) {
  case IF:
       // O PC jah foi incrementado no void ac_behavior( instruction )
    break;

  case ID:
    /* Configurura bits de controle da instrucao e repassa informacoes uteis: */

    // Configura o write back. Todas as instrucoes escrevem no banco de registradores, menos TST, TEQ, CMP e CMN //
    if( opcode != 0x08 &&  opcode != 0x09 &&  opcode != 0x0a &&  opcode != 0x0b)
         ID_EX.regwrite = 1;      // 0x08:TST, 0x09:TEQ, 0x0a:CMP, 0x0b:CMN
    else ID_EX.regwrite = 0;      // outras instrucoes data processing

    ID_EX.memread = 0;                 		// nenhuma le da memoria
    ID_EX.memwrite = 0;				// nenhuma escreve na memoria
    ID_EX.instruction = IF_ID.instruction;  	// repassa a instrucao para os proximos estagios
    ID_EX.rd = rd;	// le o numero de registrador de destino (se houver, senao fica com zero )
    ID_EX.rn = rn;			    				// le o numero de registrador de rn
    if(immediate_flag == 0) ID_EX.rm = rm;  				// le o numero de registrador de rm
    if( immediate_flag == 0 && shift_reg_flag == 1 ) ID_EX.rs = rs; 	// le o numero de registrador de rs

    /* Teste de forwarding dos registradores: */

    // Teste de forwarding para o registrador rn
    if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rn) )
      id_datarn = EX_MEM.alures.read();	
    else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rn) )
      id_datarn = MEM_WB.wbdata.read(); 
    else
      id_datarn = RB.read(rn);

    
    if( immediate_flag = 0 ){
	 // Teste de forwarding para o registrador rm (se o shift_op nao for um immediato)
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rm) )
	  id_datarm = EX_MEM.alures.read(); 
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rm) )
	  id_datarm = MEM_WB.wbdata.read(); 
	else
	  id_datarm = RB.read(rm);
    } 

    if( immediate_flag = 0  && shift_reg_flag == 1 ){
	// Teste de forwarding para o registrador rs (se o shift_op nao for um immediato e o operador de deslocamento for um registrador)
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rs) )
	  id_datars = EX_MEM.alures.read();
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rs) )
	  id_datars = MEM_WB.wbdata.read(); 
	else
	  id_datars = RB.read(rs);
    }

    ID_EX.data_rn = id_datarn;	// le o conteudo do registrador rn
    ID_EX.data_rm = id_datarm;	// le o conteudo do registrador rm (se houver, senao fica com lixo e nao sera usado )
    ID_EX.data_rs = id_datars;	// le o conteudo do registrador rm (se houver, senao fica com lixo e nao sera usado )
    
   
  break; 
   
  case EX:

    /* Teste de forwarding dos registradores: */

    // Teste de forwarding para o registrador rn
    if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rn) )
      ID_EX.data_rn = EX_MEM.alures; 
    else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rn) )
      ID_EX.data_rn = MEM_WB.wbdata; 
    // else : ID_EX.data_rn continua com o mesmo v alor

    // Teste de forwarding para o registrador rm (se o shift_op nao for um immediato)
    if( immediate_flag != 1 ) {
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rm) )
	ID_EX.data_rm = EX_MEM.alures; 
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rm) ) 
	ID_EX.data_rm = MEM_WB.wbdata; 
	// else : ID_EX.data_rm continua com o mesmo valor
    }

    // Teste de forwarding para o registrador rs (se o shift_op nao for um immediato e o operador de deslocamento for um registrador)
    if( immediate_flag != 1 && shift_reg_flag == 1 ) {
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rs) ) 
	ID_EX.data_rs = EX_MEM.alures; 
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rs) ) 
	ID_EX.data_rs = MEM_WB.wbdata;
	// else : ID_EX.data_rs continua com o mesmo valor
    }

         /********************* CALCULO DO SHIFT OPERAND  *****************************/
         
		// CASO 1: o shift_operand eh um immediato:
		if( immediate_flag == 1){

			if(immediate < 0)	immediate_ext = 0xffffff00 | immediate;
			else			immediate_ext = 0x00000000 | immediate;

			// ele sempre vai rotacionar o imediato p/ esquerda ; no caso, para nao rotacionar tem que deixar o campo rotate == 0:
			shif_op = ((immediate_ext<<rotate)|(immediate_ext>>(8-rotate)));	
		}
		// CASO 2: o shift_operand eh um registrador:
		else{
			// se shift_reg_flag == 1 , a quantidade de shifts eh dada por registrador; se == 0, eh dada por imediato:
			if( shift_reg_flag == 1)	quantidadeShift = ID_EX.data_rs;
			else 				quantidadeShift = shiffted_imm;
			
			// aplicar o shift
			if( shif_type == 0x00)          /* logical left	*/
                		shif_op = ID_EX.data_rm << quantidadeShift;	
			else if( shif_type == 0x01)     /* logical rigth */
                 		shif_op = ID_EX.data_rm >> quantidadeShift;	
			else if( shif_type == 0x02){    /* arithmetic right */
				if(ID_EX.data_rm < 0){   // se rm for negativo
					mascara = 0xffffffff;	// serve para transformar todos os zeros adicionados pelo shift em 1's
					shif_op = (ID_EX.data_rm >> quantidadeShift) | ( mascara << (8 - quantidadeShift));
				} else 	shif_op = ID_EX.data_rm >> quantidadeShift;  // se rm for positivo - shift normal :)
				
			}
			else if( shif_type == 0x03){    /* rotate */
			  if( shift_reg_flag == 0 && quantidadeShift == 0 ){	// aplicar RRX (rotate extendido):
			    mascara = (0x00000000 + CPSR.c) << 31;	        // obtem o bit de CPRS.c
			    shif_op = ( ID_EX.data_rm >> 1 ) + mascara;	// define o valor do registrador
			    CPSR.c =  ID_EX.data_rm & 0x00000001; 	// guarda o bit de rotate no CPRS.c
			  }
			  else	// Aplicar ROR (rotate a direita, normal)
                     	     shif_op = ((ID_EX.data_rm >> quantidadeShift)|(ID_EX.data_rm<<(32-quantidadeShift)));	// aplicar ROR (rotate normal)
			}
		}
	
	break;

  case MEM:
    /* Passa os valores obtidos por EX_MEM para MEM_WB */
    MEM_WB.regwrite = EX_MEM.regwrite;
    MEM_WB.wbdata = EX_MEM.alures;
    MEM_WB.rd = EX_MEM.rd;
    break;

  case WB:
    break;

  default:
    break;
  }
}


//////////////////////////////////////////////////////////////////
//      Comportamento de todas as instrucoes do tipo Branch     //
//////////////////////////////////////////////////////////////////
void ac_behavior( Type_BR ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    ID_EX.regwrite = 0;	// Nenhuma instrucao de branch executa write back
    ID_EX.memread = 0;  // Nenhuma instrucao de branch le dados da memoria
    ID_EX.memwrite = 0; // Nenhuma instrucao de branch escreve dados da memoria
    ID_EX.instruction = IF_ID.instruction;  // repassa a instrucao para os proximos estagios
  break;

  case EX:
    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
  break;

  case MEM:
    /* Passa os valores obtidos por EX_MEM para MEM_WB */
    MEM_WB.regwrite = EX_MEM.regwrite;
    MEM_WB.wbdata = EX_MEM.alures;
    MEM_WB.rd = EX_MEM.rd;
  break;

  case WB:
    break;

  default:
    break;
  }
}


///////////////////////////////////////////////////////////////////////
// Comportamento de todas as instrucoes do tipo Simple Data Transfer //
///////////////////////////////////////////////////////////////////////
void ac_behavior( Type_SDT ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    ID_EX.regwrite = wb_flag;  	// O write back eh definido pela instrucao
    ID_EX.memwrite = 0; 	// O memwrite verdadeiro estah definido no comportamento da instrucao
    ID_EX.instruction = IF_ID.instruction;  // repassa a instrucao para os proximos estagios
    ID_EX.rd = rd;			// le o numero de registrador de rd
    ID_EX.rn = rn;				// le o numero de registrador de rn
    if(immediate_flag == 1) ID_EX.rm = rm;  // le o numero de registrador de rm

    /* Teste de forwarding dos registradores: */

    // Teste de forwarding para o registrador rn
    if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rn) )
      id_datarn = EX_MEM.alures.read();	
    else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rn) )
      id_datarn = MEM_WB.wbdata.read(); 
    else
      id_datarn = RB.read(rn);

    
    if( immediate_flag == 1 ){
	 // Teste de forwarding para o registrador rm (se o shift_op nao for um immediato)
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rm) )
	  id_datarm = EX_MEM.alures.read(); 
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rm) )
	  id_datarm = MEM_WB.wbdata.read(); 
	else
	  id_datarm = RB.read(rm);
    } 

    ID_EX.data_rn = id_datarn;	// le o conteudo do registrador rn
    ID_EX.data_rm = id_datarm;	// le o conteudo do registrador rm (se houver, senao fica com lixo e nao sera usado )
  break;

  case EX:
    /* Teste de forwarding dos registradores: */

   // Teste de forwarding para o registrador rn
    if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rn) )
      ID_EX.data_rn = EX_MEM.alures; 
    else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rn) )
      ID_EX.data_rn = MEM_WB.wbdata; 
    // else : ID_EX.data_rn continua com o mesmo v alor

    // Teste de forwarding para o registrador rm (se o shift_op nao for um immediato)
    if( immediate_flag == 1 ) {
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rm) )
	ID_EX.data_rm = EX_MEM.alures; 
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rm) ) 
	ID_EX.data_rm = MEM_WB.wbdata; 
	// else : ID_EX.data_rm continua com o mesmo valor
    }

	/********************* CALCULO DO SHIFT OPERAND  (ADRESS) *****************************/
         
	// CASO 1: o adress eh um immediato:
	if( immediate_flag == 0){

		// extende o imm
		if(offs < 0)	immediate_ext = 0xffff0000 | offs;
		else		immediate_ext = 0x00000000 | offs;

		shif_op = immediate_ext;	
	}
	// CASO 2: o adress eh um registrador:
	else{
		quantidadeShift = shiffted_imm;	// a quantidade se shift eh de um imediato
		
		// aplicar o shift
		if( shif_type == 0x00)          /* logical left	*/
			shif_op = ID_EX.data_rm << quantidadeShift;	
		else if( shif_type == 0x01)     /* logical rigth */
			shif_op = ID_EX.data_rm >> quantidadeShift;	
		else if( shif_type == 0x02){    /* arithmetic right */
			if(ID_EX.data_rm < 0){   // se rm for negativo
				mascara = 0xffffffff;	// serve para transformar todos os zeros adicionados pelo shift em 1's
				shif_op = (ID_EX.data_rm >> quantidadeShift) | ( mascara << (8 - quantidadeShift));
			} else 	shif_op = ID_EX.data_rm >> quantidadeShift;  // se rm for positivo - shift normal :)
			
		}
		else if( shif_type == 0x03){    /* rotate */
			if( quantidadeShift == 0 ){	// aplicar RRX (rotate extendido):
			mascara = (0x00000000 + CPSR.c) << 31;	        // obtem o bit de CPRS.c
			shif_op = ( ID_EX.data_rm >> 1 ) + mascara;	// define o valor do registrador
			CPSR.c =  ID_EX.data_rm & 0x00000001; 	// guarda o bit de rotate no CPRS.c
			}
			else	// Aplicar ROR (rotate a direita, normal)
			shif_op = ((ID_EX.data_rm >> quantidadeShift)|(ID_EX.data_rm<<(32-quantidadeShift)));	// aplicar ROR (rotate normal)
		}
	}

    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
  break;

  case MEM:
    /* Passa os valores obtidos por EX_MEM para MEM_WB */
    MEM_WB.regwrite = EX_MEM.regwrite;
    MEM_WB.wbdata = EX_MEM.alures;
    MEM_WB.rd = EX_MEM.rd;

  break;

  case WB:
    break;

  default:
    break;
  }
}

//////////////////////////////////////////////////////////////////
// Comportamento de todas as instrucoes do tipo Single Multiply //
//////////////////////////////////////////////////////////////////
void ac_behavior( Type_SM ){

  switch( stage ) {
  case IF:
       // O PC jah foi incrementado no void ac_behavior( instruction )
    break;

  case ID:
    /* Configurura bits de controle da instrucao e repassa informacoes uteis: */

    ID_EX.memread = 0;                 		// nenhuma le da memoria
    ID_EX.memwrite = 0;				// nenhuma escreve na memoria
    ID_EX.regwrite = 1;				// as duas executam write back
    ID_EX.instruction = IF_ID.instruction;  	// repassa a instrucao para os proximos estagios
    ID_EX.rd = rd;	// le o numero de registrador de destino
    ID_EX.rn = rn;			    				// le o numero de registrador de rn
    ID_EX.rm = rm;  				// le o numero de registrador de rn
    if( accum_flag == 1 ) ID_EX.rs = rs; 	// le o numero de registrador de rs

    /* Teste de forwarding dos registradores: */

    // Teste de forwarding para o registrador rn
    if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rn) )
      id_datarn = EX_MEM.alures.read();	
    else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rn) )
      id_datarn = MEM_WB.wbdata.read(); 
    else
      id_datarn = RB.read(rn);

    
   // Teste de forwarding para o registrador rm 
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rm) )
	  id_datarm = EX_MEM.alures.read(); 
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rm) )
	  id_datarm = MEM_WB.wbdata.read(); 
	else
	  id_datarm = RB.read(rm);

   // Teste de forwarding para o registrador rs ( se for um multiply accumulate)
     if ( accum_flag == 1) {
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rs) )
	  id_datars = EX_MEM.alures.read();
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rs) )
	  id_datars = MEM_WB.wbdata.read(); 
	else
	  id_datars = RB.read(rs);
    }

    ID_EX.data_rn = id_datarn;	// le o conteudo do registrador rn
    ID_EX.data_rm = id_datarm;	// le o conteudo do registrador rm
    ID_EX.data_rs = id_datars;	// le o conteudo do registrador rs (se houver, senao fica com lixo e nao sera usado )
    
   
  break; 
   
  case EX:

    /* Teste de forwarding dos registradores: */

    // Teste de forwarding para o registrador rn
    if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rn) )
      ID_EX.data_rn = EX_MEM.alures; 
    else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rn) )
      ID_EX.data_rn = MEM_WB.wbdata; 
    // else : ID_EX.data_rn continua com o mesmo v alor

    // Teste de forwarding para o registrador rm 
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rm) )
	ID_EX.data_rm = EX_MEM.alures; 
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rm) ) 
	ID_EX.data_rm = MEM_WB.wbdata; 
	// else : ID_EX.data_rm continua com o mesmo valor

    // Teste de forwarding para o registrador rs (se for um multiply accumulate)
    if( accum_flag == 1 ) {
	if ( (EX_MEM.regwrite == 1) && (EX_MEM.rd != 0) && (EX_MEM.rd == ID_EX.rs) ) 
	ID_EX.data_rs = EX_MEM.alures; 
	else if ( (MEM_WB.regwrite == 1) && (MEM_WB.rd != 0) && (MEM_WB.rd == ID_EX.rs) ) 
	ID_EX.data_rs = MEM_WB.wbdata;
	// else : ID_EX.data_rs continua com o mesmo valor
    }

  case MEM:
    /* Passa os valores obtidos por EX_MEM para MEM_WB */
    MEM_WB.regwrite = EX_MEM.regwrite;
    MEM_WB.wbdata = EX_MEM.alures;
    MEM_WB.rd = EX_MEM.rd;
    break;

  case WB:
    break;

  default:
    break;
  }
}


/************************************************************************/
/*                     Comportamento das instrucoes                     */
/************************************************************************/

void ac_behavior( MOV ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = shif_op;
		printf("MOV: R%d = %d\n", rd, shif_op );

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};



//!Instruction add behavior method.
void ac_behavior( ADD ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
    		EX_MEM.alures = ID_EX.data_rn + shif_op;
		printf("ADD: R%d = %d\n", rd, ID_EX.data_rn + shif_op );

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}
	
	
 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction add behavior method.
void ac_behavior( SUB ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
    		EX_MEM.alures = ID_EX.data_rn - shif_op;
		printf("SUB: R%d = %d\n", rd, ID_EX.data_rn - shif_op );

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}
	
	
 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};


void ac_behavior( BIC ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
    		EX_MEM.alures = ( ID_EX.data_rn & ~shif_op);
		printf("BIC: R%d = %d\n", rd , (ID_EX.data_rn & ~shif_op));

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}
    	
 	EX_MEM.rd = ID_EX.rd;	// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }

};


void ac_behavior( AND ){
  
  switch( stage ) {
  case IF:
    // It was implemented for all instructions on ac_behaviour( instruction ) 
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
    		EX_MEM.alures = (ID_EX.data_rn & shif_op);
		printf("AND: R%d = %d\n", rd, (ID_EX.data_rn & shif_op));

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}
  
 	EX_MEM.rd = ID_EX.rd;	// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }

};

void ac_behavior( ADC ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
    		EX_MEM.alures = (ID_EX.data_rn + shif_op + CPSR.c);
		printf("ADC: R%d = %d\n", rd, (ID_EX.data_rn + shif_op + CPSR.c));

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rd = ID_EX.rd;	// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }

};

void ac_behavior( CMP ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

  if (ID_EX.flag_cond == 0x01){

    	EX_MEM.alures = (ID_EX.data_rn - shif_op);
    	printf("CMP: %d (R%d) e %d\n", ID_EX.data_rn-0, rd, (shif_op-0));
    	
	/* Set flags in CPSR ****************************************************/
	// seta flag n
	CPSR.n = EX_MEM.alures >> 31;

	// seta flag z
        if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

	// seta flag c
        if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
	CPSR.c = 0x00;	else	CPSR.c = 0x01;

        // seta flag v
        SRd = EX_MEM.alures >> 31;	
	SRn = ID_EX.data_rn >> 31;	
	SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
        if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
       
	}

 	EX_MEM.rd = ID_EX.rd;	// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal controle leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
	
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction RSC behavior method.
void ac_behavior( RSC ){
  
  switch( stage ) {
  case IF:
    // It was implemented for all instructions on ac_behaviour( instruction )
    break;

  case ID:
    break;

  case EX:
       
  // A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = ( shif_op - ID_EX.data_rn - ~CPSR.c);
		printf("RSC: R%d = %d\n", rd, ( shif_op - ID_EX.data_rn - ~CPSR.c));

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

void ac_behavior( MVN ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	if (ID_EX.flag_cond == 1){
		EX_MEM.alures =  ~shif_op;
		printf("MVN: R%d = %d\n", rn, (~shif_op-0) );

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

void ac_behavior( EOR ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = ID_EX.data_rn ^ shif_op;
		printf("EOR: R%d = %d\n", rd, ID_EX.data_rn ^ shif_op );

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

void ac_behavior( RSB ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = (shif_op - ID_EX.data_rn);
		printf("RSB: R%d = %d\n", rd, (shif_op - ID_EX.data_rn) );

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

void ac_behavior( SBC ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = ( ID_EX.data_rn - shif_op - ~CPSR.c);
		printf("SBC : R%d = %d\n", rd, ( ID_EX.data_rn - shif_op - ~CPSR.c));

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};


//!Instruction B behavior method.
void ac_behavior( B ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
	if(ID_EX.flag_cond == 1){
		if(offset < 0)	immediate_ext = 0xff000000 | offset;
		else immediate_ext = 0x00000000 | offset;
		immediate_ext = immediate_ext << 2 ;
		printf("B to %d\n", (IF_ID.instruction + immediate_ext ));
		ac_pc = delay( IF_ID.instruction + immediate_ext , 0);
	}
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction LDR behavior method.
void ac_behavior( LDR ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    ID_EX.memread = 1;   // le da memoria
    ID_EX.memwrite = 0;  // nao escreve na memoria
  break;

  case EX:

	if(ID_EX.flag_cond == 1){
		if(upper_flag == 1)	EX_MEM.alures = ID_EX.data_rn + shif_op;
		else			EX_MEM.alures = ID_EX.data_rn - shif_op;
		printf("Load Word from M[%d] to R%d\n", EX_MEM.alures+0, rd);

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

    EX_MEM.regwrite = ID_EX.regwrite;    // sinal de escrita de memoria
    EX_MEM.memread = ID_EX.memread;	// sinal de letura de memoria
    EX_MEM.memwrite = ID_EX.memwrite;	// sinal de write back
    EX_MEM.rd = ID_EX.rd;		// registrador de destino
    EX_MEM.data_rn = ID_EX.data_rn;	// conteudo do registrador base
    break;

  case MEM:
    if(pre_inc_flag == 1) MEM_WB.wbdata = DM.read(EX_MEM.alures); // Rd = M[ Rn+shi_op ] - le o conteudo da memoria
    else {
	   MEM_WB.wbdata = DM.read(EX_MEM.data_rn); // Rd = M[Rn]
           MEM_WB.regwrite = 1;			    // Habilita p/ Rn = Rn +- shift_op
    }
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction STR behavior method.
void ac_behavior( STR ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    ID_EX.memread = 0; // nao le da memoria
  break;

  case EX:
	if(ID_EX.flag_cond == 1){

		if(upper_flag == 1)	EX_MEM.alures = ID_EX.data_rn + shif_op;
		else			EX_MEM.alures = ID_EX.data_rn - shif_op;
		printf("Store Word from R%d to M[%d]\n", rd, EX_MEM.alures+0);

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}
    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rd = ID_EX.rd;
    EX_MEM.data_rn = ID_EX.data_rn;	// conteudo do registrador base
    break;

  case MEM:
	if(pre_inc_flag == 1)	DM.write(EX_MEM.alures, EX_MEM.rd.read());// M[ Rn+shi_op ] = Rd - escreve na memoria
	else {
		DM.write(EX_MEM.data_rn, EX_MEM.rd.read()); // M[Rn] = Rd 
		MEM_WB.regwrite = 1;			    // Habilita p/ Rn = Rn +- shift_op
	}
    break;

  case WB:
    break;

  default:
    break;
  }
};

void ac_behavior( MUL ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = ID_EX.data_rn * ID_EX.data_rm;
		printf("MUL: R%d = %d\n", rd, ID_EX.data_rn * ID_EX.data_rm);

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

void ac_behavior( MLA ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = ID_EX.data_rn * ID_EX.data_rm + ID_EX.data_rs;
		printf("MLA: R%d = %d\n", rd, ID_EX.data_rn * ID_EX.data_rm + ID_EX.data_rs);

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rd = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction cmn  behavior method.
void ac_behavior( CMN ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){

		EX_MEM.alures = ID_EX.data_rn + shif_op;
		printf("CMN: %d\n",EX_MEM.alures+0 );

/* Set flags in CPSR ****************************************************/
	// seta flag n
	CPSR.n = EX_MEM.alures >> 31;

	// seta flag z
        if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

	// seta flag c
        if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
	CPSR.c = 0x00;	else	CPSR.c = 0x01;

        // seta flag v
        SRd = EX_MEM.alures >> 31;	
	SRn = ID_EX.data_rn >> 31;	
	SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
        if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;

	}

 	EX_MEM.rdest = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;
 default:
    break;
  }
};

//!Instruction mvn behavior method.
void ac_behavior( MVN ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = ~shif_op;
		printf("MVN: %d\n",EX_MEM.alures+0 );

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

	}

 	EX_MEM.rdest = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction orr behavior method.
void ac_behavior( ORR ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = ID_EX.data_rn | shif_op;
		printf("ORR: %d\n",EX_MEM.alures+0 );

	if(set_flags == 1){
		/* Set flags in CPSR ****************************************************/
		// seta flag n
		CPSR.n = EX_MEM.alures >> 31;

		// seta flag z
       	 if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

		// seta flag c
       	 if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
		CPSR.c = 0x00;	else	CPSR.c = 0x01;

      	  // seta flag v
      	  SRd = EX_MEM.alures >> 31;	
		SRn = ID_EX.data_rn >> 31;	
		SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
      	  if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
	}

		
	}

 	EX_MEM.rdest = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction teq behavior method.
void ac_behavior( TEQ ){
  
  switch( stage ) {
  case IF:
    /* It was implemented for all instructions on ac_behaviour( instruction ) */
    break;

  case ID:
    break;

  case EX:

	// A instrucao soh pode ser executada se passar pelo teste de cond
	if (ID_EX.flag_cond == 1){
		EX_MEM.alures = ID_EX.data1 ^ data2;
		printf("TEQ: %d\n",EX_MEM.alures+0 );

		/* Set flags in CPSR ****************************************************/
	// seta flag n
	CPSR.n = EX_MEM.alures >> 31;

	// seta flag z
        if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

	// seta flag c
        if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
	CPSR.c = 0x00;	else	CPSR.c = 0x01;

        // seta flag v
        SRd = EX_MEM.alures >> 31;	
	SRn = ID_EX.data_rn >> 31;	
	SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
        if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;

		
	}

 	EX_MEM.rdest = ID_EX.rd;		// valor do registrador de destino
    	EX_MEM.regwrite = ID_EX.regwrite;	// sinal controle escrita reg
    	EX_MEM.memread = ID_EX.memread;		// sinal comrtole leitura memoria
	EX_MEM.memwrite = ID_EX.memwrite;	// sinal controle escrita memoria
   
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

if(set_flags == 1){
/* Set flags in CPSR ****************************************************/
	// seta flag n
	CPSR.n = EX_MEM.alures >> 31;

	// seta flag z
        if(EX_MEM.alures == 0)	CPSR.z = 1; else CPSR.z = 0;

	// seta flag c
        if((ID_EX.data_rn >= 0x00 && shif_op >= 0x00 && (ID_EX.data_rn-shif_op) < 0))
	CPSR.c = 0x00;	else	CPSR.c = 0x01;

        // seta flag v
        SRd = EX_MEM.alures >> 31;	
	SRn = ID_EX.data_rn >> 31;	
	SSh_Op = shif_op >> 31;    //guarda os bits mais significantes
        if(SRd != SRn && SRn != SSh_Op) 	CPSR.v = 0x01;	else 	CPSR.v = 0x00;
}