/**
 * @file      arm9-isa.cpp
 * @authors   Wilson Ricardo Martins Lopes Junior, Renan Mira
 *
 */

#include "archc.H"
#include "ac_types.H"
#include "ac_parms.H"
#include  "arm9-isa.H"
#include  "ac_isa_init.cpp"

// Forwarded values
ac_Uword ex_value1, ex_value2;
ac_Uword id_value1, id_value2, id_value3;
ac_Uword tmp_pc;


/************************************************************************/
//!Common pos execution function for all I Type instructions
// Copy the pipeline registers contents from the EX_MEM to the MEM_WB
#define TYPE_DP_MEM_WB_REG_COPY \
    MEM_WB.regwrite = EX_MEM.regwrite;\
    MEM_WB.rdest = EX_MEM.rdest;\
    MEM_WB.wbdata = EX_MEM.alures
/************************************************************************/

/************************************************************************/
//Rotates right...
int rotr(unsigned int imm8, unsigned int shift_ammount){
	unsigned int tmp1=imm8;
	unsigned int tmp2=imm8;
	unsigned int n=2*shift_ammount;
	unsigned int rotated = (tmp1 >> n) | (tmp2 << 32-n);

	return rotated;
}
/************************************************************************/


/************************************************************************/
//!Generic instruction behavior method.
void ac_behavior( instruction ){

  switch( stage ) {
  case IF:
    ac_pc = ac_pc+4;
    IF_ID.npc = ac_pc;
    break;
    
  case ID:
    break;

  case EX:
    break;

  case MEM:
    break;

  case WB:
    //its a nop...
    if(MEM_WB.nop==1) break;
    /* Execute write back when allowed */
    if (MEM_WB.regwrite == 1) {
      // Register 0 is never written
      if (MEM_WB.rdest != 0){
	RB.write(MEM_WB.rdest, MEM_WB.wbdata);
      }
    }
    break;

  default:
    break;
  }
};
/************************************************************************/


/************************************************************************/
//! Common behaviour for all DP Type instructions
void ac_behavior( Type_DP ){

  //int tmp_ex_regwrite, tmp_ex_rdest, tmp_ex_rn, tmp_mem_regwrite, tmp_mem_rdest, tmp_mem_rn, tmp_alu, tmp_wbdata;

  switch( stage ) {
  case IF:
    break;

  case ID:
    //COND//
    if(cond==14) ID_EX.nop=0;
    else if(cond==0 && CPSR.Z==0) ID_EX.nop=1;
    else if(cond==1 && CPSR.Z==1) ID_EX.nop=1;
    else if(cond==4 && CPSR.N==0) ID_EX.nop=1;
    else if(cond==5 && CPSR.N==1) ID_EX.nop=1;

    /* Assuming that all R type instructions execute write back. When it is not necessary,
       the instruction BY ITSELF must clear the regwrite bit on its ID stage */
    ID_EX.nop = 0;
    ID_EX.regwrite = 1;
    ID_EX.memread = 0;
    ID_EX.memwrite = 0;
    ID_EX.npc = IF_ID.npc;
    ID_EX.rn = rn;
    ID_EX.rd = rd;
    ID_EX.rs = rs;
    ID_EX.rm = rm;
    ID_EX.stwrite = s;
    ID_EX.i = i;
    ID_EX.shift_ri = dp_f2;
    ID_EX.shift = shift;
    ID_EX.shift_amount = shift_amount;
      
      //* Checking forwarding for the rn register */
	if ( (EX_MEM.regwrite == 1) &&
	     (EX_MEM.rdest != 0) &&
	     (EX_MEM.rdest == ID_EX.rn) )
	   id_value1 = EX_MEM.alures.read();
	else if ( (MEM_WB.regwrite == 1) &&
	          (MEM_WB.rdest != 0) &&
	          (MEM_WB.rdest == ID_EX.rn) )
	   id_value1 = MEM_WB.wbdata.read();
	else
	   id_value1 = RB.read(rn);

      //* Checking forwarding for the rm register */
	if ( (EX_MEM.regwrite == 1) &&
	     (EX_MEM.rdest != 0) &&
	     (EX_MEM.rdest == ID_EX.rm) )
	   id_value2 = EX_MEM.alures.read();
	else if ( (MEM_WB.regwrite == 1) &&
		  (MEM_WB.rdest != 0) &&
		  (MEM_WB.rdest == ID_EX.rm) )
	   id_value2 = MEM_WB.wbdata.read();
	else
	   id_value2 = RB.read(rm);

      //* Checking forwarding for the rs register */
	if ( (EX_MEM.regwrite == 1) &&
	     (EX_MEM.rdest != 0) &&
	     (EX_MEM.rdest == ID_EX.rs) )
	   id_value3 = EX_MEM.alures.read();
	else if ( (MEM_WB.regwrite == 1) &&
		  (MEM_WB.rdest != 0) &&
		  (MEM_WB.rdest == ID_EX.rs) )
	   id_value3 = MEM_WB.wbdata.read();
	else
	   id_value3 = RB.read(rs);



      //Verifica se o shift_operand é do tipo imediato, se for faz o rotate.
      if(i==1) id_value2 = rotr(imm8,rotate);


      ID_EX.data1 = id_value1;

      ID_EX.data2 = id_value2;

      ID_EX.data3 = id_value3;
    break;

  case EX:
 
    

      if(ID_EX.i.read()==0){
	if(ID_EX.shift_ri.read()==0){
		printf("\nRegister - immediate shift");

		//Logical Shift Left...
		if(ID_EX.shift.read()==0) ex_value2 = (ID_EX.data2.read() << ID_EX.shift_amount.read());

		//Logical Shift Right...
		else if(ID_EX.shift.read()==1) ex_value2 = (ID_EX.data2.read() >> ID_EX.shift_amount.read());

		//Arithmethic Shift Right... TODO: descobrir como fazer isso em C...
		//else if(ID_EX.shift.read()==2) ex_value2 = (ID_EX.data2.read() >> ID_EX.shift_amount.read());

		//Rotate Right...
		else if(ID_EX.shift.read()==3 && ID_EX.shift_amount.read()!=0) ex_value2 = rotr(ID_EX.data2.read(), ID_EX.shift_amount.read());

		//Rotate Right with extend... TODO: implementar o CPSR pra pegar o carry...
		//else if(ID_EX.shift.read()==3) ex_value2 = (ID_EX.data2.read() << ID_EX.shift_amount.read());
	}
	else{
		printf("\nRegister - register shift");

		//Logical Shift Left...
		if(ID_EX.shift.read()==0) ex_value2 = (ID_EX.data2.read() << id_value3);

		//Logical Shift Right...
		else if(ID_EX.shift.read()==1) ex_value2 = (ID_EX.data2.read() >> id_value3);

		//Arithmethic Shift Right... TODO: descobrir como fazer isso em C...
		//else if(ID_EX.shift.read()==2) ex_value2 = (ID_EX.data2.read() >> shift_s);

		//Rotate Right...
		else if(ID_EX.shift.read()==3 && id_value3!=0) ex_value2 = rotr(ID_EX.data2.read(), id_value3);

		//Rotate Right with extend... TODO: implementar o CPSR pra pegar o carry...
		//else if(ID_EX.shift.read()==3) id_value2 = (ID_EX.data2.read() << shift_s);

	}
    }
    else {
	printf("\nImmediate");
	ex_value2 = ID_EX.data2;
    }


	
      ex_value1 = ID_EX.data1;


      

    EX_MEM.nop = ID_EX.nop;
    EX_MEM.stwrite = ID_EX.stwrite;

    break;

  case MEM:
    /* Just copies the values from EX_MEM to MEM_WB */
    MEM_WB.nop = EX_MEM.nop;
    if(EX_MEM.nop==1) break;

    MEM_WB.regwrite = EX_MEM.regwrite;
    MEM_WB.wbdata = EX_MEM.alures;
    MEM_WB.rdest = EX_MEM.rdest;

    //TODO: write other CPSR values...
    /* writes values to CPSR if S==1*/
    if(EX_MEM.stwrite==1){
	//get the last bit from alu result... (if = 1, then number is negative)...
	CPSR.N = (EX_MEM.alures.read() >> 31);

	//check if the result is zero...
	if(EX_MEM.alures.read()==0) CPSR.Z=1;
	else CPSR.Z=0;
    }

    break;

  case WB:
    break;

  default:
    break;
  }
}



//! Common behaviour for all B Type instructions
void ac_behavior( Type_B ){


  switch( stage ) {
  case IF:
    break;

  case ID:
    
    if(cond==14) ID_EX.nop=0;
    else if(cond==0 && CPSR.Z==0) ID_EX.nop=1;
    else if(cond==1 && CPSR.Z==1) ID_EX.nop=1;
    else if(cond==4 && CPSR.N==0) ID_EX.nop=1;
    else if(cond==5 && CPSR.N==1 && CPSR.Z==0) ID_EX.nop=1;

    ID_EX.regwrite = 0;
    ID_EX.memread = 0;
    ID_EX.memwrite = 0;
    ID_EX.npc = IF_ID.npc;


    //verifica se o offset e negativo ou positivo.. e usa a mascara certa para ele...
    if((offset >> 23)==1) offset = (offset |  0xFF000000);
    else offset = (offset | 0x00000000);
    
    //faz um left-shift de 2...
    ID_EX.data2 = (offset - 2) << 2;


    break;

  case EX:

    EX_MEM.nop = ID_EX.nop;

    ex_value1 = ID_EX.data1;
    ex_value2 = ID_EX.data2;

    break;

  case MEM:
    MEM_WB.nop = EX_MEM.nop;
    MEM_WB.regwrite = EX_MEM.regwrite;
    MEM_WB.wbdata = EX_MEM.alures;
    MEM_WB.rdest = EX_MEM.rdest;
    break;

  case WB:
    break;

  default:
    break;
  }
}

void ac_behavior( Type_SI ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
}
/************************************************************************/

//!Instruction add behavior method.
//TODO: arrumar a parte que grava no CPSR(negative,overflow,etc)...
void ac_behavior( ADD ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

     if(EX_MEM.nop==1) break;

	printf("\nADD $%d, %d, %d\n",rd, ex_value1, ex_value2);
    EX_MEM.alures = ex_value1 + ex_value2;
    
	


    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction and behavior method.
//TODO: arrumar a parte que grava no CPSR(negative,overflow,etc)...
void ac_behavior( AND ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

     if(EX_MEM.nop==1) break;

	printf("\nAND $%d, %d, %d\n",rd, ex_value1, ex_value2);
    EX_MEM.alures = (ex_value1 & ex_value2);
	


    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction bic behavior method.
//TODO: arrumar a parte que grava no CPSR(negative,overflow,etc)...
void ac_behavior( BIC ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

     if(EX_MEM.nop==1) break;

	printf("\nBIC $%d, %d, %d\n",rd, ex_value1, ex_value2);
    EX_MEM.alures = (ex_value1 & (~ex_value2));
	


    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction eor behavior method.
//TODO: arrumar a parte que grava no CPSR(negative,overflow,etc)...
void ac_behavior( EOR ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

     if(EX_MEM.nop==1) break;

	printf("\nEOR $%d, %d, %d\n",rd, ex_value1, ex_value2);
    EX_MEM.alures = (ex_value1 xor ex_value2);
	


    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction orr behavior method.
//TODO: arrumar a parte que grava no CPSR(negative,overflow,etc)...
void ac_behavior( ORR ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

     if(EX_MEM.nop==1) break;

	printf("\nORR $%d, %d, %d\n",rd, ex_value1, ex_value2);
    EX_MEM.alures = (ex_value1 | ex_value2);
	


    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction rsb behavior method.
//TODO: arrumar a parte que grava no CPSR(negative,overflow,etc)...
void ac_behavior( RSB ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

     if(EX_MEM.nop==1) break;

	printf("\nRSB $%d, %d, %d\n",rd, ex_value1, ex_value2);
    EX_MEM.alures = ex_value2 - ex_value1;
	


    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction sub behavior method.
//TODO: arrumar a parte que grava no CPSR(negative,overflow,etc)...
void ac_behavior( SUB ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

     if(EX_MEM.nop==1) break;

	printf("\nSUB $%d, %d, %d\n",rd, ex_value1, ex_value2);
    EX_MEM.alures = ex_value1 - ex_value2;
	


    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};



//!Instruction B behavior method.
void ac_behavior( B ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

    if(EX_MEM.nop==1) break;

    printf("\nBranch from %02x to %02x\n", ac_pc.read(), (ac_pc.read()+ex_value2));
    if(ex_value2!=0) ac_pc = delay(ac_pc + ex_value2,1);
    
    

    EX_MEM.regwrite = 0;
    EX_MEM.memread = 0;
    EX_MEM.memwrite = 0;

    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction CMP behavior method.
void ac_behavior( CMP ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

    if(EX_MEM.nop==1) break;

	printf("\nCMP %d, %d\n", ex_value1, ex_value2);
    EX_MEM.alures = ex_value1 - ex_value2;

    EX_MEM.regwrite = 0;
    EX_MEM.memread = 0;
    EX_MEM.memwrite = 0;

    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction CMN behavior method.
void ac_behavior( CMN ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

    if(EX_MEM.nop==1) break;

	printf("\nCMP %d, %d\n", ex_value1, ex_value2);
    EX_MEM.alures = ex_value1 + ex_value2;

    EX_MEM.regwrite = 0;
    EX_MEM.memread = 0;
    EX_MEM.memwrite = 0;

    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction TEQ behavior method.
void ac_behavior( TEQ ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

    if(EX_MEM.nop==1) break;

	printf("\nCMP %d, %d\n", ex_value1, ex_value2);
    EX_MEM.alures = (ex_value1 xor ex_value2);

    EX_MEM.regwrite = 0;
    EX_MEM.memread = 0;
    EX_MEM.memwrite = 0;

    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction TST behavior method.
void ac_behavior( TST ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

    if(EX_MEM.nop==1) break;

	printf("\nTST %d, %d\n", ex_value1, ex_value2);
    EX_MEM.alures = ex_value1 & ex_value2;

    EX_MEM.regwrite = 0;
    EX_MEM.memread = 0;
    EX_MEM.memwrite = 0;

    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction MOV behavior method.
void ac_behavior( MOV ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

    if(EX_MEM.nop==1) break;

	printf("\nMOV $%d, %d\n",rd, ex_value2);
    EX_MEM.alures = ex_value2;

    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;

    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction MVN behavior method.
void ac_behavior( MVN ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:

    if(EX_MEM.nop==1) break;

	printf("\nMOV $%d, %d\n",rd, ex_value2);
    EX_MEM.alures = (~ex_value2);

    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;

    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

void ac_behavior( NOP ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction sys_call behavior method.
//TODO: achar o codigo tbm... :(
void ac_behavior( SYS_CALL )
{

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
	printf("\nSyscall:\n");
	printf("Valor dos registradores:\n\n");
	for(int i_r=1;i_r<=15;i_r++){
		int r_tmp = RB.read(i_r);
		printf("Valor de %d: %d\n",i_r,r_tmp);
	}
  	ac_stop();
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }  
	
    
}


