/**
 * @file      arm9-isa.cpp
 * @author    Renato Oliveira
 *            Veiller Machado
 *
 * @version   0.1
 * @date      Wan, 07 Nov 2007 13:27:05 -0400
 * 
 * @brief     The ArchC Arm9 cycle-accurate model.
 * 
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details. 
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "archc.H"
#include "ac_types.H"
#include "ac_parms.H"
#include  "arm9-isa.H"
#include  "ac_isa_init.cpp"


//!User defined macros to reference registers.
#define Ra 31
#define Hi 32
#define Lo 33


// Forwarded values
ac_Uword ex_value1, ex_value2;
ac_Uword id_value1, id_value2, id_value3;


/************************************************************************/
//!Common pos execution function for all I Type instructions
// Copy the pipeline registers contents from the EX_MEM to the MEM_WB
#define TYPE_I_MEM_WB_REG_COPY \
    MEM_WB.regwrite = EX_MEM.regwrite;\
    MEM_WB.rdest = EX_MEM.rdest;\
    MEM_WB.wbdata = EX_MEM.alures
/************************************************************************/



/************************************************************************/
//!Generic instruction behavior method.
void ac_behavior( instruction ){

  switch( stage ) {
  case IF:
    ac_pc += 4;
    IF_ID.npc = ac_pc;
    break;
    
  case ID:
    break;

  case EX:
    break;

  case MEM:
    break;

  case WB:
    /* Execute write back when allowed */
    if (MEM_WB.regwrite == 1) {
      // Register 0 is never written
      if (MEM_WB.rdest != 0)
	RB.write(MEM_WB.rdest, MEM_WB.wbdata);
    }
    break;

  default:
    break;
  }
};
/************************************************************************/


/************************************************************************/
//! behavior das instruções do tipo DataProcessing
void ac_behavior( Type_DP ){

  switch( stage ) {
  case IF:
    break;

  case ID:

    ID_EX.regwrite = 1;
    ID_EX.memread = 0;
    ID_EX.memwrite = 0;
    ID_EX.npc = IF_ID.npc;
    ID_EX.rn = rn;
    ID_EX.rd = rd;
    ID_EX.rs = rs;
    ID_EX.rm = rm;
    ID_EX.imm = imm8;

    id_value1 = RB.read(rn);
    
    /* Checking forwarding for the rn register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rn) )
      id_value1 = EX_MEM.alures.read();
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rn) )
      id_value1 = MEM_WB.wbdata.read();
    else
      id_value1 = RB.read(rn);
	printf("id_value1:%d\n",id_value1);

    /* Checking forwarding for the rm register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rm) )
      id_value2 = EX_MEM.alures.read();
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rm) )
      id_value2 = MEM_WB.wbdata.read();
    else
      id_value2 = RB.read(rm);
	printf("id_value2:%d\n",id_value2);

   /* Checking forwarding for the rs register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rs) )
      id_value2 = EX_MEM.alures.read();
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rs) )
      id_value3 = MEM_WB.wbdata.read();
    else
      id_value3 = RB.read(rs);
	printf("id_value3:%d\n",id_value3);

    //Testa a operação para saber se vai usar o shift ou imediato
    if(i==0){
	if(shift_flag!=0){
		//fazendo shift para direita
      	
		if(shift==1){
                    printf("i==0 shift para direita");
		    id_value2 = (id_value2 >> id_value3);
		//fazendo shift para esquerda
                }
		else if(shift==0){
			 printf("i==0 shift para esquerda");
			id_value2 = (id_value2 << id_value3);
		}
		
	}
	else{	
		//fazendo shift para direita
	      
		if(shift==1){
			printf("i==1 shift para direita");
			id_value2 = (id_value2 >> shift_amount);}	
                //fazendo shift para esquerda
      	
		else if(shift==0){
			printf("i==1 shift para esquerda\n");
			id_value2 = (id_value2 << shift_amount);}
	}

    } else id_value2=imm8;

    ID_EX.data1 = id_value1;
    ID_EX.data2 = id_value2;
    break;


  case EX:
    ex_value1 = ID_EX.data1;
    ex_value2 = ID_EX.data2;    
  break;

  case MEM:
    /* Just copies the values from EX_MEM to MEM_WB */
    MEM_WB.regwrite = EX_MEM.regwrite;
    MEM_WB.wbdata = EX_MEM.alures;
    MEM_WB.rdest = EX_MEM.rdest;
    break;

  case WB:
    break;

  default:
    break;
  }
}
/************************************************************************/

void ac_behavior( Type_SI ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
}
/**********************************/
//Instrução do metodo add.
void ac_behavior( ADD ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures = ex_value1 + ex_value2;
    printf("%d", EX_MEM.alures.read());
    printf("%d",ex_value1);
    printf("%d",ex_value2);

    // Overflow test
    if ( ((ex_value1 & 0x80000000) == (EX_MEM.alures & 0x80000000)) &&
	 ((EX_MEM.alures & 0x80000000) != (ex_value2 & 0x80000000)) ) {
      fprintf(stderr, "EXCEPTION(add): integer overflow.\n"); exit(EXIT_FAILURE);
    }

    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};


//Instrução do metodo and.
void ac_behavior( AND ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value1 & ex_value2;
    printf("%d", EX_MEM.alures.read());
    printf("%d",ex_value1);
    printf("%d", ex_value2);


    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};


//Instrução do metodo Bic.
void ac_behavior( BIC ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value1 &~ ex_value2;
    printf("%d", EX_MEM.alures.read());
    printf("%d",ex_value1);
    printf("%d",ex_value2);

    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction sub behavior method.
void ac_behavior( SUB ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value1 - ex_value2;
   printf("%d",EX_MEM.alures.read());
   printf("%d",ex_value1);
   printf("%d",ex_value2);



    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instrucão do metodo orr.
void ac_behavior( ORR ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value1 | ex_value2;
    printf("%d",EX_MEM.alures.read());
    printf("%d",ex_value1);
    printf("%d",ex_value2);

      EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};



//Instrução do metodo syscall.
void ac_behavior( SYS_CALL ) {

  switch( stage ) {
  case IF:
    break;
    
  case ID:
      break;
    
  case EX:
   printf("sys_call");
    ac_stop();    
    break;
    
   default:
    break;
  }
};

//!Instrução do metodo nop.
void ac_behavior( NOP ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    printf("nop");
    break;

  default:
    break;
  }
};


