#include "archc.H"
#include "ac_types.H"
#include "ac_parms.H"
#include  "arm9-isa.H"
#include  "ac_isa_init.cpp"


//!User defined macros to reference registers.
#define Ra 31
#define Hi 32
#define Lo 33


// Forwarded values
ac_Uword ex_value1, ex_value2;
ac_Uword id_value1, id_value2, id_value3;


/************************************************************************/
//!Generic instruction behavior method.
void ac_behavior( instruction ){

  switch( stage ) {
  case IF:
    ac_pc += 4;
    IF_ID.npc = ac_pc;
    break;
    
  case ID:
    break;

  case EX:
    break;

  case MEM:
    break;

  case WB:
    /* Execute write back when allowed */
    if (MEM_WB.regwrite == 1) {
      // Register 0 is never written
      if (MEM_WB.rdest != 0)
	RB.write(MEM_WB.rdest, MEM_WB.wbdata);
    }
    break;

  default:
    break;
  }
};
/************************************************************************/


/************************************************************************/
//! Common behaviour for all DataProcessing Type instructions
void ac_behavior( Type_DataProcessing ){

  switch( stage ) {
  case IF:
    break;

  case ID:

    ID_EX.regwrite = 1;
    ID_EX.memread = 0;
    ID_EX.memwrite = 0;
    ID_EX.npc = IF_ID.npc;
    ID_EX.rn = rn;
    ID_EX.rd = rd;
    ID_EX.rs = rs;
    ID_EX.rm = rm;
    ID_EX.imm = imm;
    ID_EX.statewrite = s;

    id_value1 = RB.read(rn);
    
    /* Checking forwarding for the rn register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rn) )
      id_value1 = EX_MEM.alures.read();
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rn) )
      id_value1 = MEM_WB.wbdata.read();
    else
      id_value1 = RB.read(rn);
	

    /* Checking forwarding for the rm register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rm) )
      id_value2 = EX_MEM.alures.read();
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rm) )
      id_value2 = MEM_WB.wbdata.read();
    else
      id_value2 = RB.read(rm);
	

/* Checking forwarding for the rs register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rs) )
      id_value2 = EX_MEM.alures.read();
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rs) )
      id_value3 = MEM_WB.wbdata.read();
    else
      id_value3 = RB.read(rs);
	

       //descobrir se  operao com shift ou imm
if(i==0){
	if(bit4!=0){
		//direita
      	
		if(shift==1){
                    //printf("i==0 com shift a direita\n");
		    id_value2 = (id_value2 >> id_value3);
		//esquerda
                }
		else if(shift==0){
			// printf("i==0 com shift a esquerda\n");
			id_value2 = (id_value2 << id_value3);
		}
		
	}
	else{	
		//direita
	      
		if(shift==1){
			//printf("i==1 com shift a direita\n");
			id_value2 = (id_value2 >> shiftimm);}	
                //esquerda
      	
		else if(shift==0){
			//printf("i==1 com shift a esquerda\n");
			id_value2 = (id_value2 << shiftimm);}
	}

    } else id_value2 = imm;

    ID_EX.data1 = id_value1;
    ID_EX.data2 = id_value2;
    break;


  case EX:
    /* Checking forwarding for the rn register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rn) )
      ex_value1 = EX_MEM.alures;
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rn) )
      ex_value1 = MEM_WB.wbdata;
    else
      ex_value1 = ID_EX.data1;

    /* Checking forwarding for the rm register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rm) )
      ex_value2 = EX_MEM.alures;
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rm) )
      ex_value2 = MEM_WB.wbdata;
    else
      ex_value2 = ID_EX.data2;
    break;

  case MEM:
    /* Just copies the values from EX_MEM to MEM_WB */
    MEM_WB.regwrite = EX_MEM.regwrite;
    MEM_WB.wbdata = EX_MEM.alures;
    MEM_WB.rdest = EX_MEM.rdest;
    break;

  case WB:
    break;

  default:
    break;
  }
}
/************************************************************************/
/************************************************************************/
void ac_behavior( Type_SystemInterruption ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
}
/************************************************************************/
//!Instruction add behavior method.
void ac_behavior( ADD ){
  
  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures = ex_value1 + ex_value2;
    printf("Resultado do ADD:%d_%d_%d\n", EX_MEM.alures.read(),ex_value1, ex_value2);

    // Overflow test
    if ( ((ex_value1 & 0x80000000) == (EX_MEM.alures & 0x80000000)) &&
	 ((EX_MEM.alures & 0x80000000) != (ex_value2 & 0x80000000)) ) {
      fprintf(stderr, "EXCEPTION(add): integer overflow.\n"); exit(EXIT_FAILURE);
    }

    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

 
//!Instruction sub behavior method.
void ac_behavior( SUB ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value1 - ex_value2;
   printf("Resultado do SUB:%d_%d_%d\n", EX_MEM.alures.read(),ex_value1, ex_value2);



    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction and behavior method.
void ac_behavior( AND ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value1 & ex_value2;
  printf("Resultado do AND:%d_%d_%d\n", EX_MEM.alures.read(),ex_value1, ex_value2);


    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction orr behavior method.
void ac_behavior( ORR ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value1 | ex_value2;
printf("Resultado do ORR:%d_%d_%d\n", EX_MEM.alures.read(),ex_value1, ex_value2);

      EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction bic behavior method.
void ac_behavior( BIC ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value1 &~ ex_value2;
printf("Resultado do BIC:%d_%d_%d\n", EX_MEM.alures.read(),ex_value1, ex_value2);

    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction eor behavior method.
void ac_behavior( EOR ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value1 xor ex_value2;
printf("Resultado do EOR:%d_%d_%d\n", EX_MEM.alures.read(),ex_value1, ex_value2);

    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};

//!Instruction rsb behavior method.
void ac_behavior( RSB ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    EX_MEM.alures  = ex_value2 - ex_value1;
printf("Resultado do RSB:%d_%d_%d\n", EX_MEM.alures.read(),ex_value2, ex_value1);

    EX_MEM.regwrite = ID_EX.regwrite;
    EX_MEM.memread = ID_EX.memread;
    EX_MEM.memwrite = ID_EX.memwrite;
    EX_MEM.rdest = ID_EX.rd;
    break;

  case MEM:
    break;

  case WB:
    break;

  default:
    break;
  }
};



//!Instruction nop behavior method.
void ac_behavior( NOP ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    break;

  case EX:
    printf("nop");
    break;

  default:
    break;
  }
};


//!Instruction sys_call behavior method.
void ac_behavior( SYS_CALL ) {

  switch( stage ) {
  case IF:
    break;
    
  case ID:
      break;
    
  case EX:
   printf("sys_call");
    ac_stop();    
    break;
    
   default:
    break;
  }
};
