
#include "archc.H"
#include "ac_types.H"
#include "ac_parms.H"
#include  "r3000-isa.H"
#include  "ac_isa_init.cpp"


//!User defined macros to reference registers.
#define Ra 31
#define Hi 32
#define Lo 33


// Forwarded values
ac_Uword ex_value1, ex_value2;
ac_Uword id_value1, id_value2;


/************************************************************************/
//!Common pos execution function for all I Type instructions
// Copy the pipeline registers contents from the EX_MEM to the MEM_WB
#define TYPE_I_MEM_WB_REG_COPY \
    MEM_WB.regwrite = EX_MEM.regwrite;\
    MEM_WB.rdest = EX_MEM.rdest;\
    MEM_WB.wbdata = EX_MEM.alures
/************************************************************************/



/************************************************************************/
//!Generic instruction behavior method.
void ac_behavior( instruction ){

  switch( stage ) {
  case IF:
    ac_pc += 4;
    IF_ID.npc = ac_pc;
    break;
    
  case ID:
    break;

  case EX:
    break;

  case MEM:
    break;

  case WB:
    /* Execute write back when allowed */
    if (MEM_WB.regwrite == 1) {
      // Register 0 is never written
      if (MEM_WB.rdest != 0)
	RB.write(MEM_WB.rdest, MEM_WB.wbdata);
    }
    break;

  default:
    break;
  }
};
/************************************************************************/


/************************************************************************/
//! Common behaviour for all DP Type instructions
void ac_behavior( Type_DP ){

  switch( stage ) {
  case IF:
    break;

  case ID:
    /* Assuming that all DP type instructions execute write back. When it is not necessary,
       the instruction BY ITSELF must clear the regwrite bit on its ID stage */
    ID_EX.regwrite = 1;
    ID_EX.memread = 0;
    ID_EX.memwrite = 0;
    ID_EX.npc = IF_ID.npc;
    ID_EX.rs = rs;
    ID_EX.rt = rt;
    ID_EX.rd = rd;

    /* Checking forwarding for the rs register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rs) )
      id_value1 = EX_MEM.alures.read();
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rs) )
      id_value1 = MEM_WB.wbdata.read();
    else
      id_value1 = RB.read(rs);

    /* Checking forwarding for the rt register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rt) )
      id_value2 = EX_MEM.alures.read();
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rt) )
      id_value2 = MEM_WB.wbdata.read();
    else
      id_value2 = RB.read(rt);

    ID_EX.data1 = id_value1;
    ID_EX.data2 = id_value2;
    break;

  case EX:
    /* Checking forwarding for the rs register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rs) )
      ex_value1 = EX_MEM.alures;
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rs) )
      ex_value1 = MEM_WB.wbdata;
    else
      ex_value1 = ID_EX.data1;

    /* Checking forwarding for the rt register */
    if ( (EX_MEM.regwrite == 1) &&
	 (EX_MEM.rdest != 0) &&
	 (EX_MEM.rdest == ID_EX.rt) )
      ex_value2 = EX_MEM.alures;
    else if ( (MEM_WB.regwrite == 1) &&
	      (MEM_WB.rdest != 0) &&
	      (MEM_WB.rdest == ID_EX.rt) )
      ex_value2 = MEM_WB.wbdata;
    else
      ex_value2 = ID_EX.data2;
    break;

  case MEM:
    /* Just copies the values from EX_MEM to MEM_WB */
    MEM_WB.regwrite = EX_MEM.regwrite;
    MEM_WB.wbdata = EX_MEM.alures;
    MEM_WB.rdest = EX_MEM.rdest;
    break;

  case WB:
    break;

  default:
    break;
  }
}
