#include "archc.H"
#include "ac_types.H"
#include "ac_parms.H"
#include "arm7-isa.H"
#include "ac_isa_init.cpp"

#define LR 14 // link register
#define PC 15 // link register

bool NOPCurInstr, printRegister = true;
long address = -1;

ac_Uword RotateRight(int rotateamount, ac_Uword reg) {
	ac_Uword temp = reg;
	
	if(rotateamount <= 0)
		return temp;
	
	unsigned long mask1 = ((unsigned long)0xFFFFFFFF) >> (32 - rotateamount);
	unsigned long mask2 = ((unsigned long)0xFFFFFFFF) >> rotateamount;
	unsigned long buff = temp & mask1;
	
	temp = (temp >> rotateamount) & mask2;
	buff <<= (32 - rotateamount);
	temp |= buff;
	
	return temp;
};

long SignExtend(long bitSeq, int bitSeq_length){
	if(bitSeq_length <= 0)
		return bitSeq;
	
	if((bitSeq & (1 << bitSeq_length - 1)) != 0)
		bitSeq |= (((unsigned long)0xFFFFFFFF) << bitSeq_length);
	else 
		bitSeq &= (((unsigned long)0xFFFFFFFF) >> (32 - bitSeq_length));
	
	return bitSeq;
}



int overFlow(ac_Uword sum) {
	if ( ((ID_EX.data1 & 0x80000000) == (sum & 0x80000000)) && ((sum & 0x80000000) != (ID_EX.shifter_operand & 0x80000000)) ) {
		return 1;
	} else {
		return 0;
	}
};

int BorrowFrom() {
	if(ID_EX.data1 < ID_EX.shifter_operand) return 1;
	else return 0;
}

void printfRegister() {
	printf("REGISTRADORES DE 0 a 5 \n\nR0: %d\n", RB[0]);
	printf("R1: %d\n", RB[1]);
	printf("R2: %d\n", RB[2]);
	printf("R3: %d\n", RB[3]);
	printf("R4: %d\n", RB[4]);
	printf("R5: %d\n\n", RB[5]);
}

/************************************************************************/
//!Generic instruction behavior method.
void ac_behavior( instruction ){
	switch( stage ) {
		case IF:
			IF_ID.cond = cond;
			if (address == -1)
				ac_pc += 4;
			else {
				ac_pc = address;
				address = -1;
			}
			//printf("PC: %d\n", (ac_pc | 0x00));
			//printf("COND: %d\n", (IF_ID.cond | 0x00));

			IF_ID.npc = ac_pc;
			RB[PC] = ac_pc;
		break;

		case ID:
			ID_EX.npc = IF_ID.npc;
			ID_EX.cond = IF_ID.cond;
		break;

		case EX:
			NOPCurInstr = false;

			switch(ID_EX.cond){
				case 0x0: // EQ
					if (CPSR.Z == 1)
						NOPCurInstr = true;
				break;

				case 0x1: // NE
					if (CPSR.Z == 0) 
						NOPCurInstr = true;
				break; 

				case 0x2: // CS/HS
					if (CPSR.C == 1) 
						NOPCurInstr = true;
				break;
				case 0x3: // CC/LO
					if (CPSR.C == 0) 
						NOPCurInstr = true;
				break;
				case 0x4: // MI
					if (CPSR.N == 1) 
						NOPCurInstr = true;
				break;
				case 0x5: // PL
					if (CPSR.N == 0) 
						NOPCurInstr = true;
				break; 
				case 0x6: // VS
					if (CPSR.V == 1) 
						NOPCurInstr = true;
				break;
				case 0x7: // VC
					if (CPSR.V == 0) 
						NOPCurInstr = true;
				break; 
				case 0x8: // HI
					if (CPSR.C == 1 && CPSR.Z == 0) 
						NOPCurInstr = true;
				break;
				case 0x9: // LS
					if (CPSR.C == 0 && CPSR.Z == 1) 
						NOPCurInstr = true;
				break;
				case 0xA: // GE
					if (CPSR.N == CPSR.V) 
						NOPCurInstr = true;
				break;
				case 0xB: // LT
					if (CPSR.N != CPSR.V) 
						NOPCurInstr = true;
				break; 
				case 0xC: // GT
					if (CPSR.Z == 0 && CPSR.N == CPSR.V)
						NOPCurInstr = true;
				break;
				case 0xD: // LE
					if (CPSR.Z == 1 || CPSR.N != CPSR.V)
						NOPCurInstr = true;
				break;
				case 0xE: // AL
					NOPCurInstr = true;
				break;
			}
		break;
	}
};
/************************************************************************/


/************************************************************************/
void ac_behavior( Data_Processing ){
	switch( stage ) {
		case IF:
		break;

		case ID:
			ID_EX.data1 = RB[rnDP];
			ID_EX.rd = rdDP;
			if(i == 0) {
				ID_EX.shifter_operand = RB[rmDp];
			} else {
				ID_EX.shifter_operand = RotateRight(rotImmDp*2, immDp);
				ac_Uword tmpShifter_operand = ID_EX.shifter_operand | 0x00;
				int tmpShifter_operand1 = tmpShifter_operand >> 31;

				if(rotImmDp == 0) {
					ID_EX.shifter_carry_out = CPSR.C;
				} else {
					ID_EX.shifter_carry_out = tmpShifter_operand1;
				}
			}
		break;

		case EX:
		break;
	}
};
/************************************************************************/

/************************************************************************/
void ac_behavior( Multiply ){
	switch( stage ) {
		case IF:
		break;
	    
		case ID:
		break;

		case EX:
			ID_EX.data1 = RB[rmMUL];
			ID_EX.shifter_operand = RB[rsMUL];
			ID_EX.data3 = RB[rnMUL];
		break;
	}
};
/************************************************************************/

/************************************************************************/
void ac_behavior( Multiply_Long ){};

/************************************************************************/

/************************************************************************/
void ac_behavior( Branch ){};

void ac_behavior( Branch_and_Exchange ){};

void ac_behavior( Single_Data_Transfer ){
	switch( stage ) {
		case IF:
		break;
	    
		case ID:
			ID_EX.rd = rd;
		break;

		case EX:
		break;
	}
};

void ac_behavior( HalfWord_Immediate_Offset ){};

void ac_behavior( adc ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
 			RB[ID_EX.rd] = ID_EX.data1 + ID_EX.shifter_operand + CPSR.C;
			//printf("RESULTADO ADC: %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

			if(s == 1 && ID_EX.rd == PC) {
				//CPSR = SPSR;
			} else if(s == 1) {
				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = overFlow(RB[ID_EX.rd]); // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
			}

			if(printRegister) {
				printfRegister();
			}
		break;
	}
};

void ac_behavior( add ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[ID_EX.rd] = ID_EX.data1 + ID_EX.shifter_operand;

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;
			
			//printf("RESULTADO ADD: %d \n", RB[ID_EX.rd]);

			if(s == 1 && ID_EX.rd == PC) {
				//CPSR = SPSR;
			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = overFlow(RB[ID_EX.rd]); // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
			}

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( and1 ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[ID_EX.rd] = ID_EX.data1 & ID_EX.shifter_operand;
			//printf("RESULTADO AND: %d & %d = %d \n", (ID_EX.data1|0x00), (ID_EX.shifter_operand|0x00), RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

			if(s == 1 && ID_EX.rd == PC) {
				//CPSR = SPSR;
			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = ID_EX.shifter_carry_out; // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
			}

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( b ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			address = ac_pc + (SignExtend(offset, 24) << 2);
			//printf("RESULTADO B\n");
			RB[PC] = address;

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( bl ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			long address = RB[PC] + (SignExtend(offset, 24) << 2);
			//printf("RESULTADO BL: %d \n", address);

			RB[LR] = RB[PC] - 4;

			ac_pc = (long) address;
			RB[PC] = ac_pc - 4;

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( blx ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[LR] = RB[PC] - 4;

			CPSR.T = rn & 0x01;
			ac_pc = rn & 0xFFFFFFFE;
			RB[PC] = ac_pc - 4;

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( bx ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			CPSR.T = rn & 0x01;
			ac_pc = rn & 0xFFFFFFFE;
			RB[PC] = ac_pc - 4;

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};


void ac_behavior( bic ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[ID_EX.rd] = ID_EX.data1 & ~ID_EX.shifter_operand;
			//printf("RESULTADO BIC: %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

			if(s == 1 && ID_EX.rd == PC) {
				//CPSR = SPSR;
			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
				CPSR.C = ID_EX.shifter_carry_out; // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
			}

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( eor ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[ID_EX.rd] = ID_EX.data1 ^ ID_EX.shifter_operand;
			//printf("RESULTADO EOR: %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

			if(s == 1 && ID_EX.rd == PC) {
				//CPSR = SPSR;
			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = ID_EX.shifter_carry_out; // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
			}

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( rsb ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[ID_EX.rd] = ID_EX.shifter_operand - ID_EX.data1;
			//printf("RESULTADO RSB: %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

			if(s == 1 && ID_EX.rd == PC) {
				//CPSR = SPSR;
			} else if(s == 1) {
				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = ~BorrowFrom(); // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
			}	

			if(printRegister) {
				printfRegister();
			}
		
		break;
	}
};
void ac_behavior( sub ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[ID_EX.rd] = ID_EX.data1 - ID_EX.shifter_operand;
			//printf("RESULTADO SUB: %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

 			if(s == 1 && ID_EX.rd == PC) {
// 				RB[16] = RB[17];
 			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = ~BorrowFrom(); // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
 			}

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};
void ac_behavior( sbc ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
 			RB[ID_EX.rd] = ID_EX.data1 - ID_EX.shifter_operand - ~CPSR.C;
			//printf("RESULTADO SBC: %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

			if(s == 1 && ID_EX.rd == PC) {
				////CPSR = SPSR;
			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = ~BorrowFrom(); // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
			}

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};
void ac_behavior( rsc ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
 			RB[ID_EX.rd] = ID_EX.shifter_operand - ID_EX.data1 - ~CPSR.C;
			//printf("RESULTADO RSC: %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

			if(s == 1 && ID_EX.rd == PC) {
				////CPSR = SPSR;
			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = ~BorrowFrom(); // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
			}

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};
void ac_behavior( tst ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
 			ac_Uword alu_out = ID_EX.data1 & ID_EX.shifter_operand;
			//printf("RESULTADO TST: %d \n", alu_out);

			ac_Uword tmp = alu_out | 0x00;
			int tmp1 = tmp >> 31;

			CPSR.N = tmp1; // N
			if(alu_out == 0) 
				CPSR.Z = 1;
			else
				CPSR.Z = 0; // Z
			CPSR.C = ID_EX.shifter_carry_out;

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};
void ac_behavior( teq ){
	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			if(!NOPCurInstr){
				return;
			}

 			ac_Uword alu_out = ID_EX.data1 ^ ID_EX.shifter_operand;
			//printf("RESULTADO TEQ: %d \n", alu_out);

			ac_Uword tmp = alu_out | 0x00;
			int tmp1 = tmp >> 31;

			CPSR.N = tmp1; // N
			if(alu_out == 0) {
				CPSR.Z = 1;
			} else {
				CPSR.Z = 0; // Z
			}
			CPSR.C = ID_EX.shifter_carry_out;

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};
void ac_behavior( cmp ){

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			if(!NOPCurInstr){
				return;
			}
 			ac_Uword alu_out = ID_EX.data1 - ID_EX.shifter_operand;
			//printf("RESULTADO CMP: %d \n", alu_out);

			ac_Uword tmp = alu_out | 0x00;
			int tmp1 = tmp >> 31;

			CPSR.N = tmp1; // N
			if(alu_out == 0) 
				CPSR.Z = 1;
			else
				CPSR.Z = 0; // Z
			CPSR.C = ~BorrowFrom(); // C
			CPSR.V = overFlow(alu_out); // V

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};
void ac_behavior( cmn ){

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:

			if(!NOPCurInstr){
				return;
			}
 			ac_Uword alu_out = ID_EX.data1 + ID_EX.shifter_operand;
			//printf("RESULTADO CMN: %d \n", alu_out);

			ac_Uword tmp = alu_out | 0x00;
			int tmp1 = tmp >> 31;

			CPSR.N = tmp1; // N
			if(alu_out == 0) 
				CPSR.Z = 1;
			else
				CPSR.Z = 0; // Z
			CPSR.C = overFlow(alu_out); // C
			CPSR.V = overFlow(alu_out); // V

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( orr ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[ID_EX.rd] = ID_EX.data1 | ID_EX.shifter_operand;
			//printf("RESULTADO ORR: %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

 			if(s == 1 && ID_EX.rd == PC) {
// 				RB[16] = RB[17];
 			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = ID_EX.shifter_carry_out; // C
				CPSR.V = overFlow(RB[ID_EX.rd]); // V
 			}

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( mla ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[rdMUL] = ID_EX.data1 * ID_EX.shifter_operand + ID_EX.data3;
			//printf("RESULTADO MLA: %d \n", RB[rdMUL]);

			ac_Uword tmp = RB[rdMUL] | 0x00;
			int tmp1 = tmp >> 31;

 			if(s == 1 && rdMUL == PC) {
// 				RB[16] = RB[17];
 			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(rdMUL == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 			}
			
			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( mov ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[ID_EX.rd] = ID_EX.shifter_operand;
			//printf("RESULTADO MOV: %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

 			if(s == 1 && ID_EX.rd == PC) {
// 				RB[16] = RB[17];
 			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = ID_EX.shifter_carry_out; // C
 			}
			
			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( mvn ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[ID_EX.rd] = ~ID_EX.shifter_operand;
			//printf("RESULTADO MVN %d \n", RB[ID_EX.rd]);

			ac_Uword tmp = RB[ID_EX.rd] | 0x00;
			int tmp1 = tmp >> 31;

 			if(s == 1 && ID_EX.rd == PC) {
// 				RB[16] = RB[17];
 			} else if(s == 1) {
 				CPSR.N = tmp1; // N
				if(ID_EX.rd == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 				CPSR.C = ID_EX.shifter_carry_out; // C
 			}
			
			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( mul ){

	if(!NOPCurInstr){
		return;
	}

	switch( stage ) {
		case IF:
		break;

		case ID:
		break;

		case EX:
			RB[rdMUL] = ID_EX.data1 * ID_EX.shifter_operand;
			//printf("RESULTADO MUL: %d \n", RB[rdMUL]);

			ac_Uword tmp = RB[rdMUL] | 0x00;
			int tmp1 = tmp >> 31;

 			if(s == 1 && rdMUL == PC) {
// 				RB[16] = RB[17];
 			} else if(s == 1) {
				CPSR.N = tmp1; // N
				if(rdMUL == 0) 
					CPSR.Z = 1;
				else
					CPSR.Z = 0; // Z
 			}

			if(printRegister) {
				printfRegister();
			}

		break;
	}
};

void ac_behavior( ldr ){};
void ac_behavior( ldrb ){};
void ac_behavior( ldrbt ){};
void ac_behavior( ldrt ){};
void ac_behavior( ldrh ){};
void ac_behavior( ldrsb ){};
void ac_behavior( ldrsh ){};
void ac_behavior( umull ){};
void ac_behavior( umlal ){};
void ac_behavior( smull ){};
void ac_behavior( smlal ){};
void ac_behavior( str ){};
void ac_behavior( strb ){};
void ac_behavior( strbt ){};
void ac_behavior( strh ){};
void ac_behavior( strt ){};
