/******************************************************
 * Instruction Set Architecture header file.          *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/
 

#ifndef _ISA_H
#define _ISA_H

#include "ac_decoder.h"
#include "ac_parms.H"
#include "ac_types.H"

#include "ac_resources.H"


#define ac_behavior( c )   ac_##c::behavior( ac_stage_list stage, unsigned cycle )

class arm7_isa: public ac_resources{

public:
  static ac_instruction begin;
  static ac_instruction end;
  static ac_instruction instruction;
  static ac_Multiply Multiply;
  static ac_Multiply_Long Multiply_Long;
  static ac_Data_Processing Data_Processing;
  static ac_Branch Branch;
  static ac_Branch_and_Exchange Branch_and_Exchange;
  static ac_Single_Data_Transfer Single_Data_Transfer;
  static ac_HalfWord_Immediate_Offset HalfWord_Immediate_Offset;
  static ac_mla mla;
  static ac_mul mul;
  static ac_umull umull;
  static ac_umlal umlal;
  static ac_smull smull;
  static ac_smlal smlal;
  static ac_and1 and1;
  static ac_eor eor;
  static ac_sub sub;
  static ac_rsb rsb;
  static ac_add add;
  static ac_adc adc;
  static ac_sbc sbc;
  static ac_rsc rsc;
  static ac_tst tst;
  static ac_teq teq;
  static ac_cmp cmp;
  static ac_cmn cmn;
  static ac_orr orr;
  static ac_mov mov;
  static ac_bic bic;
  static ac_mvn mvn;
  static ac_b b;
  static ac_bl bl;
  static ac_bx bx;
  static ac_blx blx;
  static ac_ldr ldr;
  static ac_ldrb ldrb;
  static ac_ldrbt ldrbt;
  static ac_ldrt ldrt;
  static ac_str str;
  static ac_strb strb;
  static ac_strbt strbt;
  static ac_strt strt;
  static ac_ldrh ldrh;
  static ac_ldrsb ldrsb;
  static ac_ldrsh ldrsh;
  static ac_strh strh;
 
  ac_decoder_full *decoder;
  int instr_table[AC_DEC_INSTR_NUMBER+1][3];


  //!Constructor.

  arm7_isa(){

    //!Decoding structures.
    extern ac_dec_field *fields;
    extern ac_dec_format *formats;
    extern ac_dec_list *dec_list;
    extern ac_dec_instr *instructions;

    fields = (ac_dec_field*) malloc(sizeof(ac_dec_field)*AC_DEC_FIELD_NUMBER);
    fields[0].name      = "cond";
    fields[0].size      = 4;
    fields[0].first_bit = 3;
    fields[0].id        = 1;
    fields[0].val       = 0;
    fields[0].sign      = 0;
    fields[0].next      = &(fields[1]);

    fields[1].name      = "opMUL";
    fields[1].size      = 7;
    fields[1].first_bit = 10;
    fields[1].id        = 2;
    fields[1].val       = 0;
    fields[1].sign      = 0;
    fields[1].next      = &(fields[2]);

    fields[2].name      = "s";
    fields[2].size      = 1;
    fields[2].first_bit = 11;
    fields[2].id        = 3;
    fields[2].val       = 0;
    fields[2].sign      = 0;
    fields[2].next      = &(fields[3]);

    fields[3].name      = "rdMUL";
    fields[3].size      = 4;
    fields[3].first_bit = 15;
    fields[3].id        = 4;
    fields[3].val       = 0;
    fields[3].sign      = 0;
    fields[3].next      = &(fields[4]);

    fields[4].name      = "rnMUL";
    fields[4].size      = 4;
    fields[4].first_bit = 19;
    fields[4].id        = 5;
    fields[4].val       = 0;
    fields[4].sign      = 0;
    fields[4].next      = &(fields[5]);

    fields[5].name      = "rsMUL";
    fields[5].size      = 4;
    fields[5].first_bit = 23;
    fields[5].id        = 6;
    fields[5].val       = 0;
    fields[5].sign      = 0;
    fields[5].next      = &(fields[6]);

    fields[6].name      = "op2MUL";
    fields[6].size      = 4;
    fields[6].first_bit = 27;
    fields[6].id        = 7;
    fields[6].val       = 0;
    fields[6].sign      = 0;
    fields[6].next      = &(fields[7]);

    fields[7].name      = "rmMUL";
    fields[7].size      = 4;
    fields[7].first_bit = 31;
    fields[7].id        = 8;
    fields[7].val       = 0;
    fields[7].sign      = 0;
    fields[7].next      = NULL;

    fields[8].name      = "cond";
    fields[8].size      = 4;
    fields[8].first_bit = 3;
    fields[8].id        = 1;
    fields[8].val       = 0;
    fields[8].sign      = 0;
    fields[8].next      = &(fields[9]);

    fields[9].name      = "opMULL";
    fields[9].size      = 7;
    fields[9].first_bit = 10;
    fields[9].id        = 9;
    fields[9].val       = 0;
    fields[9].sign      = 0;
    fields[9].next      = &(fields[10]);

    fields[10].name      = "s";
    fields[10].size      = 1;
    fields[10].first_bit = 11;
    fields[10].id        = 3;
    fields[10].val       = 0;
    fields[10].sign      = 0;
    fields[10].next      = &(fields[11]);

    fields[11].name      = "rdHi";
    fields[11].size      = 4;
    fields[11].first_bit = 15;
    fields[11].id        = 10;
    fields[11].val       = 0;
    fields[11].sign      = 0;
    fields[11].next      = &(fields[12]);

    fields[12].name      = "rdLo";
    fields[12].size      = 4;
    fields[12].first_bit = 19;
    fields[12].id        = 11;
    fields[12].val       = 0;
    fields[12].sign      = 0;
    fields[12].next      = &(fields[13]);

    fields[13].name      = "rnMULL";
    fields[13].size      = 4;
    fields[13].first_bit = 23;
    fields[13].id        = 12;
    fields[13].val       = 0;
    fields[13].sign      = 0;
    fields[13].next      = &(fields[14]);

    fields[14].name      = "op2MULL";
    fields[14].size      = 4;
    fields[14].first_bit = 27;
    fields[14].id        = 13;
    fields[14].val       = 0;
    fields[14].sign      = 0;
    fields[14].next      = &(fields[15]);

    fields[15].name      = "rmMULL";
    fields[15].size      = 4;
    fields[15].first_bit = 31;
    fields[15].id        = 14;
    fields[15].val       = 0;
    fields[15].sign      = 0;
    fields[15].next      = NULL;

    fields[16].name      = "cond";
    fields[16].size      = 4;
    fields[16].first_bit = 3;
    fields[16].id        = 1;
    fields[16].val       = 0;
    fields[16].sign      = 0;
    fields[16].next      = &(fields[17]);

    fields[17].name      = "opDP";
    fields[17].size      = 2;
    fields[17].first_bit = 5;
    fields[17].id        = 15;
    fields[17].val       = 0;
    fields[17].sign      = 0;
    fields[17].next      = &(fields[18]);

    fields[18].name      = "i";
    fields[18].size      = 1;
    fields[18].first_bit = 6;
    fields[18].id        = 16;
    fields[18].val       = 0;
    fields[18].sign      = 0;
    fields[18].next      = &(fields[19]);

    fields[19].name      = "opcode";
    fields[19].size      = 4;
    fields[19].first_bit = 10;
    fields[19].id        = 17;
    fields[19].val       = 0;
    fields[19].sign      = 0;
    fields[19].next      = &(fields[20]);

    fields[20].name      = "s";
    fields[20].size      = 1;
    fields[20].first_bit = 11;
    fields[20].id        = 3;
    fields[20].val       = 0;
    fields[20].sign      = 0;
    fields[20].next      = &(fields[21]);

    fields[21].name      = "rnDP";
    fields[21].size      = 4;
    fields[21].first_bit = 15;
    fields[21].id        = 18;
    fields[21].val       = 0;
    fields[21].sign      = 0;
    fields[21].next      = &(fields[22]);

    fields[22].name      = "rdDP";
    fields[22].size      = 4;
    fields[22].first_bit = 19;
    fields[22].id        = 19;
    fields[22].val       = 0;
    fields[22].sign      = 0;
    fields[22].next      = &(fields[23]);

    fields[23].name      = "rotImmDp";
    fields[23].size      = 4;
    fields[23].first_bit = 23;
    fields[23].id        = 20;
    fields[23].val       = 0;
    fields[23].sign      = 0;
    fields[23].next      = &(fields[24]);

    fields[24].name      = "immDp";
    fields[24].size      = 8;
    fields[24].first_bit = 31;
    fields[24].id        = 21;
    fields[24].val       = 0;
    fields[24].sign      = 0;
    fields[24].next      = &(fields[25]);

    fields[25].name      = "shifImmDp";
    fields[25].size      = 5;
    fields[25].first_bit = 24;
    fields[25].id        = 22;
    fields[25].val       = 0;
    fields[25].sign      = 0;
    fields[25].next      = &(fields[26]);

    fields[26].name      = "shiftDp";
    fields[26].size      = 2;
    fields[26].first_bit = 26;
    fields[26].id        = 23;
    fields[26].val       = 0;
    fields[26].sign      = 0;
    fields[26].next      = &(fields[27]);

    fields[27].name      = "zeroDp";
    fields[27].size      = 1;
    fields[27].first_bit = 27;
    fields[27].id        = 24;
    fields[27].val       = 0;
    fields[27].sign      = 0;
    fields[27].next      = &(fields[28]);

    fields[28].name      = "rmDp";
    fields[28].size      = 4;
    fields[28].first_bit = 31;
    fields[28].id        = 25;
    fields[28].val       = 0;
    fields[28].sign      = 0;
    fields[28].next      = &(fields[29]);

    fields[29].name      = "rsDp";
    fields[29].size      = 4;
    fields[29].first_bit = 23;
    fields[29].id        = 26;
    fields[29].val       = 0;
    fields[29].sign      = 0;
    fields[29].next      = &(fields[30]);

    fields[30].name      = "zero1Dp";
    fields[30].size      = 1;
    fields[30].first_bit = 24;
    fields[30].id        = 27;
    fields[30].val       = 0;
    fields[30].sign      = 0;
    fields[30].next      = &(fields[31]);

    fields[31].name      = "shift1Dp";
    fields[31].size      = 2;
    fields[31].first_bit = 26;
    fields[31].id        = 28;
    fields[31].val       = 0;
    fields[31].sign      = 0;
    fields[31].next      = &(fields[32]);

    fields[32].name      = "oneDp";
    fields[32].size      = 1;
    fields[32].first_bit = 27;
    fields[32].id        = 29;
    fields[32].val       = 0;
    fields[32].sign      = 0;
    fields[32].next      = &(fields[33]);

    fields[33].name      = "rm1Dp";
    fields[33].size      = 4;
    fields[33].first_bit = 31;
    fields[33].id        = 30;
    fields[33].val       = 0;
    fields[33].sign      = 0;
    fields[33].next      = NULL;

    fields[34].name      = "cond";
    fields[34].size      = 4;
    fields[34].first_bit = 3;
    fields[34].id        = 1;
    fields[34].val       = 0;
    fields[34].sign      = 0;
    fields[34].next      = &(fields[35]);

    fields[35].name      = "op";
    fields[35].size      = 3;
    fields[35].first_bit = 6;
    fields[35].id        = 31;
    fields[35].val       = 0;
    fields[35].sign      = 0;
    fields[35].next      = &(fields[36]);

    fields[36].name      = "l";
    fields[36].size      = 1;
    fields[36].first_bit = 7;
    fields[36].id        = 32;
    fields[36].val       = 0;
    fields[36].sign      = 0;
    fields[36].next      = &(fields[37]);

    fields[37].name      = "offset";
    fields[37].size      = 24;
    fields[37].first_bit = 31;
    fields[37].id        = 33;
    fields[37].val       = 0;
    fields[37].sign      = 0;
    fields[37].next      = NULL;

    fields[38].name      = "cond";
    fields[38].size      = 4;
    fields[38].first_bit = 3;
    fields[38].id        = 1;
    fields[38].val       = 0;
    fields[38].sign      = 0;
    fields[38].next      = &(fields[39]);

    fields[39].name      = "opBE";
    fields[39].size      = 8;
    fields[39].first_bit = 11;
    fields[39].id        = 34;
    fields[39].val       = 0;
    fields[39].sign      = 0;
    fields[39].next      = &(fields[40]);

    fields[40].name      = "uns";
    fields[40].size      = 12;
    fields[40].first_bit = 23;
    fields[40].id        = 35;
    fields[40].val       = 0;
    fields[40].sign      = 0;
    fields[40].next      = &(fields[41]);

    fields[41].name      = "opBE2";
    fields[41].size      = 4;
    fields[41].first_bit = 27;
    fields[41].id        = 36;
    fields[41].val       = 0;
    fields[41].sign      = 0;
    fields[41].next      = &(fields[42]);

    fields[42].name      = "rn";
    fields[42].size      = 4;
    fields[42].first_bit = 31;
    fields[42].id        = 37;
    fields[42].val       = 0;
    fields[42].sign      = 0;
    fields[42].next      = NULL;

    fields[43].name      = "cond";
    fields[43].size      = 4;
    fields[43].first_bit = 3;
    fields[43].id        = 1;
    fields[43].val       = 0;
    fields[43].sign      = 0;
    fields[43].next      = &(fields[44]);

    fields[44].name      = "opSDT";
    fields[44].size      = 2;
    fields[44].first_bit = 5;
    fields[44].id        = 38;
    fields[44].val       = 0;
    fields[44].sign      = 0;
    fields[44].next      = &(fields[45]);

    fields[45].name      = "i";
    fields[45].size      = 1;
    fields[45].first_bit = 6;
    fields[45].id        = 16;
    fields[45].val       = 0;
    fields[45].sign      = 0;
    fields[45].next      = &(fields[46]);

    fields[46].name      = "p";
    fields[46].size      = 1;
    fields[46].first_bit = 7;
    fields[46].id        = 39;
    fields[46].val       = 0;
    fields[46].sign      = 0;
    fields[46].next      = &(fields[47]);

    fields[47].name      = "u";
    fields[47].size      = 1;
    fields[47].first_bit = 8;
    fields[47].id        = 40;
    fields[47].val       = 0;
    fields[47].sign      = 0;
    fields[47].next      = &(fields[48]);

    fields[48].name      = "b";
    fields[48].size      = 1;
    fields[48].first_bit = 9;
    fields[48].id        = 41;
    fields[48].val       = 0;
    fields[48].sign      = 0;
    fields[48].next      = &(fields[49]);

    fields[49].name      = "w";
    fields[49].size      = 1;
    fields[49].first_bit = 10;
    fields[49].id        = 42;
    fields[49].val       = 0;
    fields[49].sign      = 0;
    fields[49].next      = &(fields[50]);

    fields[50].name      = "x";
    fields[50].size      = 1;
    fields[50].first_bit = 11;
    fields[50].id        = 43;
    fields[50].val       = 0;
    fields[50].sign      = 0;
    fields[50].next      = &(fields[51]);

    fields[51].name      = "rnSDT";
    fields[51].size      = 4;
    fields[51].first_bit = 15;
    fields[51].id        = 44;
    fields[51].val       = 0;
    fields[51].sign      = 0;
    fields[51].next      = &(fields[52]);

    fields[52].name      = "rd";
    fields[52].size      = 4;
    fields[52].first_bit = 19;
    fields[52].id        = 45;
    fields[52].val       = 0;
    fields[52].sign      = 0;
    fields[52].next      = &(fields[53]);

    fields[53].name      = "addr_modeSDT";
    fields[53].size      = 12;
    fields[53].first_bit = 31;
    fields[53].id        = 46;
    fields[53].val       = 0;
    fields[53].sign      = 0;
    fields[53].next      = NULL;

    fields[54].name      = "cond";
    fields[54].size      = 4;
    fields[54].first_bit = 3;
    fields[54].id        = 1;
    fields[54].val       = 0;
    fields[54].sign      = 0;
    fields[54].next      = &(fields[55]);

    fields[55].name      = "opHIO";
    fields[55].size      = 3;
    fields[55].first_bit = 6;
    fields[55].id        = 47;
    fields[55].val       = 0;
    fields[55].sign      = 0;
    fields[55].next      = &(fields[56]);

    fields[56].name      = "p";
    fields[56].size      = 1;
    fields[56].first_bit = 7;
    fields[56].id        = 39;
    fields[56].val       = 0;
    fields[56].sign      = 0;
    fields[56].next      = &(fields[57]);

    fields[57].name      = "u";
    fields[57].size      = 1;
    fields[57].first_bit = 8;
    fields[57].id        = 40;
    fields[57].val       = 0;
    fields[57].sign      = 0;
    fields[57].next      = &(fields[58]);

    fields[58].name      = "b";
    fields[58].size      = 1;
    fields[58].first_bit = 9;
    fields[58].id        = 41;
    fields[58].val       = 0;
    fields[58].sign      = 0;
    fields[58].next      = &(fields[59]);

    fields[59].name      = "w";
    fields[59].size      = 1;
    fields[59].first_bit = 10;
    fields[59].id        = 42;
    fields[59].val       = 0;
    fields[59].sign      = 0;
    fields[59].next      = &(fields[60]);

    fields[60].name      = "x";
    fields[60].size      = 1;
    fields[60].first_bit = 11;
    fields[60].id        = 43;
    fields[60].val       = 0;
    fields[60].sign      = 0;
    fields[60].next      = &(fields[61]);

    fields[61].name      = "rnHIO";
    fields[61].size      = 4;
    fields[61].first_bit = 15;
    fields[61].id        = 48;
    fields[61].val       = 0;
    fields[61].sign      = 0;
    fields[61].next      = &(fields[62]);

    fields[62].name      = "rd";
    fields[62].size      = 4;
    fields[62].first_bit = 19;
    fields[62].id        = 45;
    fields[62].val       = 0;
    fields[62].sign      = 0;
    fields[62].next      = &(fields[63]);

    fields[63].name      = "addr_modeHIO";
    fields[63].size      = 4;
    fields[63].first_bit = 23;
    fields[63].id        = 49;
    fields[63].val       = 0;
    fields[63].sign      = 0;
    fields[63].next      = &(fields[64]);

    fields[64].name      = "opHIO2";
    fields[64].size      = 4;
    fields[64].first_bit = 27;
    fields[64].id        = 50;
    fields[64].val       = 0;
    fields[64].sign      = 0;
    fields[64].next      = &(fields[65]);

    fields[65].name      = "addr_modeHIO2";
    fields[65].size      = 4;
    fields[65].first_bit = 31;
    fields[65].id        = 51;
    fields[65].val       = 0;
    fields[65].sign      = 0;
    fields[65].next      = NULL;

 
    formats = (ac_dec_format*) malloc(sizeof(ac_dec_format)*AC_DEC_FORMAT_NUMBER);
    formats[0].name      = "Multiply";
    formats[0].size      = 32;
    formats[0].fields    = &(fields[0]);
    formats[0].next      = &(formats[1]);

    formats[1].name      = "Multiply_Long";
    formats[1].size      = 32;
    formats[1].fields    = &(fields[8]);
    formats[1].next      = &(formats[2]);

    formats[2].name      = "Data_Processing";
    formats[2].size      = 32;
    formats[2].fields    = &(fields[16]);
    formats[2].next      = &(formats[3]);

    formats[3].name      = "Branch";
    formats[3].size      = 32;
    formats[3].fields    = &(fields[34]);
    formats[3].next      = &(formats[4]);

    formats[4].name      = "Branch_and_Exchange";
    formats[4].size      = 32;
    formats[4].fields    = &(fields[38]);
    formats[4].next      = &(formats[5]);

    formats[5].name      = "Single_Data_Transfer";
    formats[5].size      = 32;
    formats[5].fields    = &(fields[43]);
    formats[5].next      = &(formats[6]);

    formats[6].name      = "HalfWord_Immediate_Offset";
    formats[6].size      = 32;
    formats[6].fields    = &(fields[54]);
    formats[6].next      = NULL;

 
    dec_list = (ac_dec_list*) malloc(sizeof(ac_dec_list)*AC_DEC_LIST_NUMBER);
    dec_list[0].name      = "opMUL";
    dec_list[0].value     = 1;
    dec_list[0].next      = &(dec_list[1]);

    dec_list[1].name      = "op2MUL";
    dec_list[1].value     = 9;
    dec_list[1].next      = NULL;

    dec_list[2].name      = "opMUL";
    dec_list[2].value     = 0;
    dec_list[2].next      = &(dec_list[3]);

    dec_list[3].name      = "op2MUL";
    dec_list[3].value     = 9;
    dec_list[3].next      = NULL;

    dec_list[4].name      = "opMULL";
    dec_list[4].value     = 4;
    dec_list[4].next      = &(dec_list[5]);

    dec_list[5].name      = "op2MULL";
    dec_list[5].value     = 9;
    dec_list[5].next      = NULL;

    dec_list[6].name      = "opMULL";
    dec_list[6].value     = 5;
    dec_list[6].next      = &(dec_list[7]);

    dec_list[7].name      = "op2MULL";
    dec_list[7].value     = 9;
    dec_list[7].next      = NULL;

    dec_list[8].name      = "opMULL";
    dec_list[8].value     = 6;
    dec_list[8].next      = &(dec_list[9]);

    dec_list[9].name      = "op2MULL";
    dec_list[9].value     = 9;
    dec_list[9].next      = NULL;

    dec_list[10].name      = "opMULL";
    dec_list[10].value     = 7;
    dec_list[10].next      = &(dec_list[11]);

    dec_list[11].name      = "op2MULL";
    dec_list[11].value     = 9;
    dec_list[11].next      = NULL;

    dec_list[12].name      = "opDP";
    dec_list[12].value     = 0;
    dec_list[12].next      = &(dec_list[13]);

    dec_list[13].name      = "opcode";
    dec_list[13].value     = 0;
    dec_list[13].next      = NULL;

    dec_list[14].name      = "opDP";
    dec_list[14].value     = 0;
    dec_list[14].next      = &(dec_list[15]);

    dec_list[15].name      = "opcode";
    dec_list[15].value     = 1;
    dec_list[15].next      = NULL;

    dec_list[16].name      = "opDP";
    dec_list[16].value     = 0;
    dec_list[16].next      = &(dec_list[17]);

    dec_list[17].name      = "opcode";
    dec_list[17].value     = 2;
    dec_list[17].next      = NULL;

    dec_list[18].name      = "opDP";
    dec_list[18].value     = 0;
    dec_list[18].next      = &(dec_list[19]);

    dec_list[19].name      = "opcode";
    dec_list[19].value     = 3;
    dec_list[19].next      = NULL;

    dec_list[20].name      = "opDP";
    dec_list[20].value     = 0;
    dec_list[20].next      = &(dec_list[21]);

    dec_list[21].name      = "opcode";
    dec_list[21].value     = 4;
    dec_list[21].next      = NULL;

    dec_list[22].name      = "opDP";
    dec_list[22].value     = 0;
    dec_list[22].next      = &(dec_list[23]);

    dec_list[23].name      = "opcode";
    dec_list[23].value     = 5;
    dec_list[23].next      = NULL;

    dec_list[24].name      = "opDP";
    dec_list[24].value     = 0;
    dec_list[24].next      = &(dec_list[25]);

    dec_list[25].name      = "opcode";
    dec_list[25].value     = 6;
    dec_list[25].next      = NULL;

    dec_list[26].name      = "opDP";
    dec_list[26].value     = 0;
    dec_list[26].next      = &(dec_list[27]);

    dec_list[27].name      = "opcode";
    dec_list[27].value     = 7;
    dec_list[27].next      = NULL;

    dec_list[28].name      = "opDP";
    dec_list[28].value     = 0;
    dec_list[28].next      = &(dec_list[29]);

    dec_list[29].name      = "opcode";
    dec_list[29].value     = 8;
    dec_list[29].next      = NULL;

    dec_list[30].name      = "opDP";
    dec_list[30].value     = 0;
    dec_list[30].next      = &(dec_list[31]);

    dec_list[31].name      = "opcode";
    dec_list[31].value     = 9;
    dec_list[31].next      = NULL;

    dec_list[32].name      = "opDP";
    dec_list[32].value     = 0;
    dec_list[32].next      = &(dec_list[33]);

    dec_list[33].name      = "opcode";
    dec_list[33].value     = 10;
    dec_list[33].next      = NULL;

    dec_list[34].name      = "opDP";
    dec_list[34].value     = 0;
    dec_list[34].next      = &(dec_list[35]);

    dec_list[35].name      = "opcode";
    dec_list[35].value     = 11;
    dec_list[35].next      = NULL;

    dec_list[36].name      = "opDP";
    dec_list[36].value     = 0;
    dec_list[36].next      = &(dec_list[37]);

    dec_list[37].name      = "opcode";
    dec_list[37].value     = 12;
    dec_list[37].next      = NULL;

    dec_list[38].name      = "opDP";
    dec_list[38].value     = 0;
    dec_list[38].next      = &(dec_list[39]);

    dec_list[39].name      = "opcode";
    dec_list[39].value     = 13;
    dec_list[39].next      = NULL;

    dec_list[40].name      = "opDP";
    dec_list[40].value     = 0;
    dec_list[40].next      = &(dec_list[41]);

    dec_list[41].name      = "opcode";
    dec_list[41].value     = 14;
    dec_list[41].next      = NULL;

    dec_list[42].name      = "opDP";
    dec_list[42].value     = 0;
    dec_list[42].next      = &(dec_list[43]);

    dec_list[43].name      = "opcode";
    dec_list[43].value     = 15;
    dec_list[43].next      = NULL;

    dec_list[44].name      = "op";
    dec_list[44].value     = 5;
    dec_list[44].next      = &(dec_list[45]);

    dec_list[45].name      = "l";
    dec_list[45].value     = 0;
    dec_list[45].next      = NULL;

    dec_list[46].name      = "op";
    dec_list[46].value     = 5;
    dec_list[46].next      = &(dec_list[47]);

    dec_list[47].name      = "l";
    dec_list[47].value     = 1;
    dec_list[47].next      = NULL;

    dec_list[48].name      = "opBE";
    dec_list[48].value     = 18;
    dec_list[48].next      = &(dec_list[49]);

    dec_list[49].name      = "opBE2";
    dec_list[49].value     = 1;
    dec_list[49].next      = NULL;

    dec_list[50].name      = "opBE";
    dec_list[50].value     = 18;
    dec_list[50].next      = &(dec_list[51]);

    dec_list[51].name      = "opBE2";
    dec_list[51].value     = 3;
    dec_list[51].next      = NULL;

    dec_list[52].name      = "opSDT";
    dec_list[52].value     = 1;
    dec_list[52].next      = &(dec_list[53]);

    dec_list[53].name      = "b";
    dec_list[53].value     = 0;
    dec_list[53].next      = &(dec_list[54]);

    dec_list[54].name      = "x";
    dec_list[54].value     = 1;
    dec_list[54].next      = NULL;

    dec_list[55].name      = "opSDT";
    dec_list[55].value     = 1;
    dec_list[55].next      = &(dec_list[56]);

    dec_list[56].name      = "b";
    dec_list[56].value     = 1;
    dec_list[56].next      = &(dec_list[57]);

    dec_list[57].name      = "x";
    dec_list[57].value     = 1;
    dec_list[57].next      = NULL;

    dec_list[58].name      = "opSDT";
    dec_list[58].value     = 1;
    dec_list[58].next      = &(dec_list[59]);

    dec_list[59].name      = "p";
    dec_list[59].value     = 0;
    dec_list[59].next      = &(dec_list[60]);

    dec_list[60].name      = "b";
    dec_list[60].value     = 1;
    dec_list[60].next      = &(dec_list[61]);

    dec_list[61].name      = "w";
    dec_list[61].value     = 1;
    dec_list[61].next      = &(dec_list[62]);

    dec_list[62].name      = "x";
    dec_list[62].value     = 1;
    dec_list[62].next      = NULL;

    dec_list[63].name      = "opSDT";
    dec_list[63].value     = 1;
    dec_list[63].next      = &(dec_list[64]);

    dec_list[64].name      = "p";
    dec_list[64].value     = 0;
    dec_list[64].next      = &(dec_list[65]);

    dec_list[65].name      = "b";
    dec_list[65].value     = 0;
    dec_list[65].next      = &(dec_list[66]);

    dec_list[66].name      = "w";
    dec_list[66].value     = 1;
    dec_list[66].next      = &(dec_list[67]);

    dec_list[67].name      = "x";
    dec_list[67].value     = 1;
    dec_list[67].next      = NULL;

    dec_list[68].name      = "opSDT";
    dec_list[68].value     = 1;
    dec_list[68].next      = &(dec_list[69]);

    dec_list[69].name      = "b";
    dec_list[69].value     = 0;
    dec_list[69].next      = &(dec_list[70]);

    dec_list[70].name      = "x";
    dec_list[70].value     = 0;
    dec_list[70].next      = NULL;

    dec_list[71].name      = "opSDT";
    dec_list[71].value     = 1;
    dec_list[71].next      = &(dec_list[72]);

    dec_list[72].name      = "b";
    dec_list[72].value     = 1;
    dec_list[72].next      = &(dec_list[73]);

    dec_list[73].name      = "x";
    dec_list[73].value     = 0;
    dec_list[73].next      = NULL;

    dec_list[74].name      = "opSDT";
    dec_list[74].value     = 1;
    dec_list[74].next      = &(dec_list[75]);

    dec_list[75].name      = "p";
    dec_list[75].value     = 0;
    dec_list[75].next      = &(dec_list[76]);

    dec_list[76].name      = "b";
    dec_list[76].value     = 1;
    dec_list[76].next      = &(dec_list[77]);

    dec_list[77].name      = "w";
    dec_list[77].value     = 1;
    dec_list[77].next      = &(dec_list[78]);

    dec_list[78].name      = "x";
    dec_list[78].value     = 0;
    dec_list[78].next      = NULL;

    dec_list[79].name      = "opSDT";
    dec_list[79].value     = 1;
    dec_list[79].next      = &(dec_list[80]);

    dec_list[80].name      = "p";
    dec_list[80].value     = 0;
    dec_list[80].next      = &(dec_list[81]);

    dec_list[81].name      = "b";
    dec_list[81].value     = 0;
    dec_list[81].next      = &(dec_list[82]);

    dec_list[82].name      = "w";
    dec_list[82].value     = 1;
    dec_list[82].next      = &(dec_list[83]);

    dec_list[83].name      = "x";
    dec_list[83].value     = 0;
    dec_list[83].next      = NULL;

    dec_list[84].name      = "opHIO";
    dec_list[84].value     = 0;
    dec_list[84].next      = &(dec_list[85]);

    dec_list[85].name      = "x";
    dec_list[85].value     = 1;
    dec_list[85].next      = &(dec_list[86]);

    dec_list[86].name      = "opHIO2";
    dec_list[86].value     = 11;
    dec_list[86].next      = NULL;

    dec_list[87].name      = "opHIO";
    dec_list[87].value     = 0;
    dec_list[87].next      = &(dec_list[88]);

    dec_list[88].name      = "x";
    dec_list[88].value     = 1;
    dec_list[88].next      = &(dec_list[89]);

    dec_list[89].name      = "opHIO2";
    dec_list[89].value     = 12;
    dec_list[89].next      = NULL;

    dec_list[90].name      = "opHIO";
    dec_list[90].value     = 0;
    dec_list[90].next      = &(dec_list[91]);

    dec_list[91].name      = "x";
    dec_list[91].value     = 1;
    dec_list[91].next      = &(dec_list[92]);

    dec_list[92].name      = "opHIO2";
    dec_list[92].value     = 15;
    dec_list[92].next      = NULL;

    dec_list[93].name      = "opHIO";
    dec_list[93].value     = 0;
    dec_list[93].next      = &(dec_list[94]);

    dec_list[94].name      = "x";
    dec_list[94].value     = 0;
    dec_list[94].next      = &(dec_list[95]);

    dec_list[95].name      = "opHIO2";
    dec_list[95].value     = 11;
    dec_list[95].next      = NULL;

 
    instructions = (ac_dec_instr*) malloc(sizeof(ac_dec_instr)*AC_DEC_INSTR_NUMBER);
    instructions[0].name      = "mla";
    instructions[0].mnemonic  = "(null)";
    instructions[0].asm_str   = "(null)";
    instructions[0].format    = "Multiply";
    instructions[0].id        = 1;
    instructions[0].dec_list  = &(dec_list[0]);
    instructions[0].next      = &(instructions[1]);

    instructions[1].name      = "mul";
    instructions[1].mnemonic  = "(null)";
    instructions[1].asm_str   = "(null)";
    instructions[1].format    = "Multiply";
    instructions[1].id        = 2;
    instructions[1].dec_list  = &(dec_list[2]);
    instructions[1].next      = &(instructions[2]);

    instructions[2].name      = "umull";
    instructions[2].mnemonic  = "(null)";
    instructions[2].asm_str   = "(null)";
    instructions[2].format    = "Multiply_Long";
    instructions[2].id        = 3;
    instructions[2].dec_list  = &(dec_list[4]);
    instructions[2].next      = &(instructions[3]);

    instructions[3].name      = "umlal";
    instructions[3].mnemonic  = "(null)";
    instructions[3].asm_str   = "(null)";
    instructions[3].format    = "Multiply_Long";
    instructions[3].id        = 4;
    instructions[3].dec_list  = &(dec_list[6]);
    instructions[3].next      = &(instructions[4]);

    instructions[4].name      = "smull";
    instructions[4].mnemonic  = "(null)";
    instructions[4].asm_str   = "(null)";
    instructions[4].format    = "Multiply_Long";
    instructions[4].id        = 5;
    instructions[4].dec_list  = &(dec_list[8]);
    instructions[4].next      = &(instructions[5]);

    instructions[5].name      = "smlal";
    instructions[5].mnemonic  = "(null)";
    instructions[5].asm_str   = "(null)";
    instructions[5].format    = "Multiply_Long";
    instructions[5].id        = 6;
    instructions[5].dec_list  = &(dec_list[10]);
    instructions[5].next      = &(instructions[6]);

    instructions[6].name      = "and1";
    instructions[6].mnemonic  = "(null)";
    instructions[6].asm_str   = "(null)";
    instructions[6].format    = "Data_Processing";
    instructions[6].id        = 7;
    instructions[6].dec_list  = &(dec_list[12]);
    instructions[6].next      = &(instructions[7]);

    instructions[7].name      = "eor";
    instructions[7].mnemonic  = "(null)";
    instructions[7].asm_str   = "(null)";
    instructions[7].format    = "Data_Processing";
    instructions[7].id        = 8;
    instructions[7].dec_list  = &(dec_list[14]);
    instructions[7].next      = &(instructions[8]);

    instructions[8].name      = "sub";
    instructions[8].mnemonic  = "(null)";
    instructions[8].asm_str   = "(null)";
    instructions[8].format    = "Data_Processing";
    instructions[8].id        = 9;
    instructions[8].dec_list  = &(dec_list[16]);
    instructions[8].next      = &(instructions[9]);

    instructions[9].name      = "rsb";
    instructions[9].mnemonic  = "(null)";
    instructions[9].asm_str   = "(null)";
    instructions[9].format    = "Data_Processing";
    instructions[9].id        = 10;
    instructions[9].dec_list  = &(dec_list[18]);
    instructions[9].next      = &(instructions[10]);

    instructions[10].name      = "add";
    instructions[10].mnemonic  = "(null)";
    instructions[10].asm_str   = "(null)";
    instructions[10].format    = "Data_Processing";
    instructions[10].id        = 11;
    instructions[10].dec_list  = &(dec_list[20]);
    instructions[10].next      = &(instructions[11]);

    instructions[11].name      = "adc";
    instructions[11].mnemonic  = "(null)";
    instructions[11].asm_str   = "(null)";
    instructions[11].format    = "Data_Processing";
    instructions[11].id        = 12;
    instructions[11].dec_list  = &(dec_list[22]);
    instructions[11].next      = &(instructions[12]);

    instructions[12].name      = "sbc";
    instructions[12].mnemonic  = "(null)";
    instructions[12].asm_str   = "(null)";
    instructions[12].format    = "Data_Processing";
    instructions[12].id        = 13;
    instructions[12].dec_list  = &(dec_list[24]);
    instructions[12].next      = &(instructions[13]);

    instructions[13].name      = "rsc";
    instructions[13].mnemonic  = "(null)";
    instructions[13].asm_str   = "(null)";
    instructions[13].format    = "Data_Processing";
    instructions[13].id        = 14;
    instructions[13].dec_list  = &(dec_list[26]);
    instructions[13].next      = &(instructions[14]);

    instructions[14].name      = "tst";
    instructions[14].mnemonic  = "(null)";
    instructions[14].asm_str   = "(null)";
    instructions[14].format    = "Data_Processing";
    instructions[14].id        = 15;
    instructions[14].dec_list  = &(dec_list[28]);
    instructions[14].next      = &(instructions[15]);

    instructions[15].name      = "teq";
    instructions[15].mnemonic  = "(null)";
    instructions[15].asm_str   = "(null)";
    instructions[15].format    = "Data_Processing";
    instructions[15].id        = 16;
    instructions[15].dec_list  = &(dec_list[30]);
    instructions[15].next      = &(instructions[16]);

    instructions[16].name      = "cmp";
    instructions[16].mnemonic  = "(null)";
    instructions[16].asm_str   = "(null)";
    instructions[16].format    = "Data_Processing";
    instructions[16].id        = 17;
    instructions[16].dec_list  = &(dec_list[32]);
    instructions[16].next      = &(instructions[17]);

    instructions[17].name      = "cmn";
    instructions[17].mnemonic  = "(null)";
    instructions[17].asm_str   = "(null)";
    instructions[17].format    = "Data_Processing";
    instructions[17].id        = 18;
    instructions[17].dec_list  = &(dec_list[34]);
    instructions[17].next      = &(instructions[18]);

    instructions[18].name      = "orr";
    instructions[18].mnemonic  = "(null)";
    instructions[18].asm_str   = "(null)";
    instructions[18].format    = "Data_Processing";
    instructions[18].id        = 19;
    instructions[18].dec_list  = &(dec_list[36]);
    instructions[18].next      = &(instructions[19]);

    instructions[19].name      = "mov";
    instructions[19].mnemonic  = "(null)";
    instructions[19].asm_str   = "(null)";
    instructions[19].format    = "Data_Processing";
    instructions[19].id        = 20;
    instructions[19].dec_list  = &(dec_list[38]);
    instructions[19].next      = &(instructions[20]);

    instructions[20].name      = "bic";
    instructions[20].mnemonic  = "(null)";
    instructions[20].asm_str   = "(null)";
    instructions[20].format    = "Data_Processing";
    instructions[20].id        = 21;
    instructions[20].dec_list  = &(dec_list[40]);
    instructions[20].next      = &(instructions[21]);

    instructions[21].name      = "mvn";
    instructions[21].mnemonic  = "(null)";
    instructions[21].asm_str   = "(null)";
    instructions[21].format    = "Data_Processing";
    instructions[21].id        = 22;
    instructions[21].dec_list  = &(dec_list[42]);
    instructions[21].next      = &(instructions[22]);

    instructions[22].name      = "b";
    instructions[22].mnemonic  = "(null)";
    instructions[22].asm_str   = "(null)";
    instructions[22].format    = "Branch";
    instructions[22].id        = 23;
    instructions[22].dec_list  = &(dec_list[44]);
    instructions[22].next      = &(instructions[23]);

    instructions[23].name      = "bl";
    instructions[23].mnemonic  = "(null)";
    instructions[23].asm_str   = "(null)";
    instructions[23].format    = "Branch";
    instructions[23].id        = 24;
    instructions[23].dec_list  = &(dec_list[46]);
    instructions[23].next      = &(instructions[24]);

    instructions[24].name      = "bx";
    instructions[24].mnemonic  = "(null)";
    instructions[24].asm_str   = "(null)";
    instructions[24].format    = "Branch_and_Exchange";
    instructions[24].id        = 25;
    instructions[24].dec_list  = &(dec_list[48]);
    instructions[24].next      = &(instructions[25]);

    instructions[25].name      = "blx";
    instructions[25].mnemonic  = "(null)";
    instructions[25].asm_str   = "(null)";
    instructions[25].format    = "Branch_and_Exchange";
    instructions[25].id        = 26;
    instructions[25].dec_list  = &(dec_list[50]);
    instructions[25].next      = &(instructions[26]);

    instructions[26].name      = "ldr";
    instructions[26].mnemonic  = "(null)";
    instructions[26].asm_str   = "(null)";
    instructions[26].format    = "Single_Data_Transfer";
    instructions[26].id        = 27;
    instructions[26].dec_list  = &(dec_list[52]);
    instructions[26].next      = &(instructions[27]);

    instructions[27].name      = "ldrb";
    instructions[27].mnemonic  = "(null)";
    instructions[27].asm_str   = "(null)";
    instructions[27].format    = "Single_Data_Transfer";
    instructions[27].id        = 28;
    instructions[27].dec_list  = &(dec_list[55]);
    instructions[27].next      = &(instructions[28]);

    instructions[28].name      = "ldrbt";
    instructions[28].mnemonic  = "(null)";
    instructions[28].asm_str   = "(null)";
    instructions[28].format    = "Single_Data_Transfer";
    instructions[28].id        = 29;
    instructions[28].dec_list  = &(dec_list[58]);
    instructions[28].next      = &(instructions[29]);

    instructions[29].name      = "ldrt";
    instructions[29].mnemonic  = "(null)";
    instructions[29].asm_str   = "(null)";
    instructions[29].format    = "Single_Data_Transfer";
    instructions[29].id        = 30;
    instructions[29].dec_list  = &(dec_list[63]);
    instructions[29].next      = &(instructions[30]);

    instructions[30].name      = "str";
    instructions[30].mnemonic  = "(null)";
    instructions[30].asm_str   = "(null)";
    instructions[30].format    = "Single_Data_Transfer";
    instructions[30].id        = 31;
    instructions[30].dec_list  = &(dec_list[68]);
    instructions[30].next      = &(instructions[31]);

    instructions[31].name      = "strb";
    instructions[31].mnemonic  = "(null)";
    instructions[31].asm_str   = "(null)";
    instructions[31].format    = "Single_Data_Transfer";
    instructions[31].id        = 32;
    instructions[31].dec_list  = &(dec_list[71]);
    instructions[31].next      = &(instructions[32]);

    instructions[32].name      = "strbt";
    instructions[32].mnemonic  = "(null)";
    instructions[32].asm_str   = "(null)";
    instructions[32].format    = "Single_Data_Transfer";
    instructions[32].id        = 33;
    instructions[32].dec_list  = &(dec_list[74]);
    instructions[32].next      = &(instructions[33]);

    instructions[33].name      = "strt";
    instructions[33].mnemonic  = "(null)";
    instructions[33].asm_str   = "(null)";
    instructions[33].format    = "Single_Data_Transfer";
    instructions[33].id        = 34;
    instructions[33].dec_list  = &(dec_list[79]);
    instructions[33].next      = &(instructions[34]);

    instructions[34].name      = "ldrh";
    instructions[34].mnemonic  = "(null)";
    instructions[34].asm_str   = "(null)";
    instructions[34].format    = "HalfWord_Immediate_Offset";
    instructions[34].id        = 35;
    instructions[34].dec_list  = &(dec_list[84]);
    instructions[34].next      = &(instructions[35]);

    instructions[35].name      = "ldrsb";
    instructions[35].mnemonic  = "(null)";
    instructions[35].asm_str   = "(null)";
    instructions[35].format    = "HalfWord_Immediate_Offset";
    instructions[35].id        = 36;
    instructions[35].dec_list  = &(dec_list[87]);
    instructions[35].next      = &(instructions[36]);

    instructions[36].name      = "ldrsh";
    instructions[36].mnemonic  = "(null)";
    instructions[36].asm_str   = "(null)";
    instructions[36].format    = "HalfWord_Immediate_Offset";
    instructions[36].id        = 37;
    instructions[36].dec_list  = &(dec_list[90]);
    instructions[36].next      = &(instructions[37]);

    instructions[37].name      = "strh";
    instructions[37].mnemonic  = "(null)";
    instructions[37].asm_str   = "(null)";
    instructions[37].format    = "HalfWord_Immediate_Offset";
    instructions[37].id        = 38;
    instructions[37].dec_list  = &(dec_list[93]);
    instructions[37].next      = NULL;

    //!Building Decoder.
    decoder = CreateDecoder(formats, instructions);
    //!Initializing Instruction table.

    instr_table[0][0] = 0;
    instr_table[0][1] = 0;
    instr_table[0][2] = 0;
    instr_table[1][0] = 1;
    instr_table[1][1] = (int)&mla;
    instr_table[1][2] = (int)&Multiply;
    instr_table[2][0] = 2;
    instr_table[2][1] = (int)&mul;
    instr_table[2][2] = (int)&Multiply;
    instr_table[3][0] = 3;
    instr_table[3][1] = (int)&umull;
    instr_table[3][2] = (int)&Multiply_Long;
    instr_table[4][0] = 4;
    instr_table[4][1] = (int)&umlal;
    instr_table[4][2] = (int)&Multiply_Long;
    instr_table[5][0] = 5;
    instr_table[5][1] = (int)&smull;
    instr_table[5][2] = (int)&Multiply_Long;
    instr_table[6][0] = 6;
    instr_table[6][1] = (int)&smlal;
    instr_table[6][2] = (int)&Multiply_Long;
    instr_table[7][0] = 7;
    instr_table[7][1] = (int)&and1;
    instr_table[7][2] = (int)&Data_Processing;
    instr_table[8][0] = 8;
    instr_table[8][1] = (int)&eor;
    instr_table[8][2] = (int)&Data_Processing;
    instr_table[9][0] = 9;
    instr_table[9][1] = (int)&sub;
    instr_table[9][2] = (int)&Data_Processing;
    instr_table[10][0] = 10;
    instr_table[10][1] = (int)&rsb;
    instr_table[10][2] = (int)&Data_Processing;
    instr_table[11][0] = 11;
    instr_table[11][1] = (int)&add;
    instr_table[11][2] = (int)&Data_Processing;
    instr_table[12][0] = 12;
    instr_table[12][1] = (int)&adc;
    instr_table[12][2] = (int)&Data_Processing;
    instr_table[13][0] = 13;
    instr_table[13][1] = (int)&sbc;
    instr_table[13][2] = (int)&Data_Processing;
    instr_table[14][0] = 14;
    instr_table[14][1] = (int)&rsc;
    instr_table[14][2] = (int)&Data_Processing;
    instr_table[15][0] = 15;
    instr_table[15][1] = (int)&tst;
    instr_table[15][2] = (int)&Data_Processing;
    instr_table[16][0] = 16;
    instr_table[16][1] = (int)&teq;
    instr_table[16][2] = (int)&Data_Processing;
    instr_table[17][0] = 17;
    instr_table[17][1] = (int)&cmp;
    instr_table[17][2] = (int)&Data_Processing;
    instr_table[18][0] = 18;
    instr_table[18][1] = (int)&cmn;
    instr_table[18][2] = (int)&Data_Processing;
    instr_table[19][0] = 19;
    instr_table[19][1] = (int)&orr;
    instr_table[19][2] = (int)&Data_Processing;
    instr_table[20][0] = 20;
    instr_table[20][1] = (int)&mov;
    instr_table[20][2] = (int)&Data_Processing;
    instr_table[21][0] = 21;
    instr_table[21][1] = (int)&bic;
    instr_table[21][2] = (int)&Data_Processing;
    instr_table[22][0] = 22;
    instr_table[22][1] = (int)&mvn;
    instr_table[22][2] = (int)&Data_Processing;
    instr_table[23][0] = 23;
    instr_table[23][1] = (int)&b;
    instr_table[23][2] = (int)&Branch;
    instr_table[24][0] = 24;
    instr_table[24][1] = (int)&bl;
    instr_table[24][2] = (int)&Branch;
    instr_table[25][0] = 25;
    instr_table[25][1] = (int)&bx;
    instr_table[25][2] = (int)&Branch_and_Exchange;
    instr_table[26][0] = 26;
    instr_table[26][1] = (int)&blx;
    instr_table[26][2] = (int)&Branch_and_Exchange;
    instr_table[27][0] = 27;
    instr_table[27][1] = (int)&ldr;
    instr_table[27][2] = (int)&Single_Data_Transfer;
    instr_table[28][0] = 28;
    instr_table[28][1] = (int)&ldrb;
    instr_table[28][2] = (int)&Single_Data_Transfer;
    instr_table[29][0] = 29;
    instr_table[29][1] = (int)&ldrbt;
    instr_table[29][2] = (int)&Single_Data_Transfer;
    instr_table[30][0] = 30;
    instr_table[30][1] = (int)&ldrt;
    instr_table[30][2] = (int)&Single_Data_Transfer;
    instr_table[31][0] = 31;
    instr_table[31][1] = (int)&str;
    instr_table[31][2] = (int)&Single_Data_Transfer;
    instr_table[32][0] = 32;
    instr_table[32][1] = (int)&strb;
    instr_table[32][2] = (int)&Single_Data_Transfer;
    instr_table[33][0] = 33;
    instr_table[33][1] = (int)&strbt;
    instr_table[33][2] = (int)&Single_Data_Transfer;
    instr_table[34][0] = 34;
    instr_table[34][1] = (int)&strt;
    instr_table[34][2] = (int)&Single_Data_Transfer;
    instr_table[35][0] = 35;
    instr_table[35][1] = (int)&ldrh;
    instr_table[35][2] = (int)&HalfWord_Immediate_Offset;
    instr_table[36][0] = 36;
    instr_table[36][1] = (int)&ldrsb;
    instr_table[36][2] = (int)&HalfWord_Immediate_Offset;
    instr_table[37][0] = 37;
    instr_table[37][1] = (int)&ldrsh;
    instr_table[37][2] = (int)&HalfWord_Immediate_Offset;
    instr_table[38][0] = 38;
    instr_table[38][1] = (int)&strh;
    instr_table[38][2] = (int)&HalfWord_Immediate_Offset;
  }
};
#endif //_ISA_H

