/******************************************************
 * Architecture Module implementation file.           *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/
 

#include "ac_parms.H"
#include  "arm7-arch.H"
 
//!Verification method.

void arm7_arch::ac_verify(){
 
  if( st1_done.read() && 
    st2_done.read() && 
    st3_done.read() )
      {
#ifdef AC_VERBOSE
      DM.change_dump(cerr);
      RB.change_dump(cerr);
      IF_ID.change_dump(cerr);
      ID_EX.change_dump(cerr);
      CPSR.change_dump(cerr);
      SPSR.change_dump(cerr);
#endif
#ifdef AC_UPDATE_LOG
      DM.reset_log();
      RB.reset_log();
      IF_ID.reset_log();
      ID_EX.reset_log();
      CPSR.reset_log();
      SPSR.reset_log();
#endif
      st1_done.write(0);
      st2_done.write(0);
      st3_done.write(0);
      }
}

//!Updating Pipe Regs for behavioral simulation.
void arm7_arch::ac_update_regs(){
  static ac_instr nop;

  if( !IF_stall )
    if( IF_flush ){
      ID_regin.write( nop );
      IF_flush = 0;
    }
    else
      ID_regin.write( IF_regout.read() );
  else
    IF_stall = 0;

  if( !ID_stall )
    if( ID_flush ){
      EX_regin.write( nop );
      ID_flush = 0;
    }
    else
      EX_regin.write( ID_regout.read() );
  else
    ID_stall = 0;

  DM.commit_delays( sc_simulation_time() );
  RB.commit_delays( sc_simulation_time() );
  ac_pc.commit_delays( sc_simulation_time() );
  bhv_pc.write( ac_pc );
}
