/******************************************************
 * Architecture Module header file.                   *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/
 

#ifndef  _ARCH_H
#define  _ARCH_H

#include "systemc.h"
#include "archc.H"
#include "ac_storage.H"
#include "ac_resources.H"
#include "IF.H"
#include "ID.H"
#include "EX.H"
 

class arm7_arch: public sc_module, public ac_resources{
public:

  sc_in<bool> clock;
  sc_signal<unsigned> bhv_pc;
 
  sc_signal<bool> do_it;
  sc_signal<bool> st1_done;
  sc_signal<bool> st2_done;
  sc_signal<bool> st3_done;
 
  //!Verification method.

  void ac_verify();
 
  //!Updating Pipe Regs for behavioral simulation.

  void ac_update_regs();
 
  //!Stage declarations.

  AC_IF::IF *IF_stage;
  sc_signal<ac_instr> IF_regout;
 
  AC_ID::ID *ID_stage;
  sc_signal<ac_instr> ID_regin;
  sc_signal<ac_instr> ID_regout;
 
  AC_EX::EX *EX_stage;
  sc_signal<ac_instr> EX_regin;
 
  //!Constructor.

  SC_CTOR(arm7_arch){

    SC_METHOD( ac_verify );
    sensitive << st1_done<< st2_done<< st3_done;
 
    SC_METHOD( ac_update_regs );
    sensitive_pos<< clock ; 
    dont_initialize(); 

    bhv_pc = 0; 
    IF_stage = new AC_IF::IF("IF");
    IF_stage->bhv_pc( bhv_pc );
    IF_stage->regout( IF_regout );
    IF_stage->bhv_start( st2_done );
    IF_stage->bhv_done(st1_done);
 
    ID_stage = new AC_ID::ID("ID");
    ID_stage->bhv_pc( bhv_pc );
    ID_stage->regin( ID_regin );
    ID_stage->regout( ID_regout );
    ID_stage->bhv_start( st3_done );
    ID_stage->bhv_done(st2_done);
 
    EX_stage = new AC_EX::EX("EX");
    EX_stage->bhv_pc( bhv_pc );
    EX_stage->regin( EX_regin );
    EX_stage->bhv_done(st3_done);
 
  }
};
#endif  //_ARCH_H

