/******************************************************
 * ArchC Types header file.                           *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/
 

#ifndef  _AC_TYPES_H
#define  _AC_TYPES_H

#include  <systemc.h>
#include  "ac_storage.H"
#include  "ac_resources.H"
#include  "archc.H"

//!ArchC abstract class for pipeline stages.

class ac_stage: public sc_module, public ac_resources {
public:
  virtual void behavior(){};
  SC_CTOR( ac_stage ){};
};

//!Pseudo instruction begin.

class ac_begin: public ac_resources {
public:
  static void behavior(ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0);
};

//!Pseudo instruction end.

class ac_end: public ac_resources {
public:
  static void behavior(ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0);
};

//!Generic Instruction Class declaration.

class ac_instruction: public ac_resources {
protected:
  char* ac_instr_name;
  char* ac_instr_mnemonic;
  unsigned ac_instr_size;
  unsigned ac_instr_cycles;
  unsigned ac_instr_min_latency;
  unsigned ac_instr_max_latency;
  unsigned cond;
public:
  ac_instruction( char* name, char* mnemonic, unsigned min, unsigned max ){ ac_instr_name = name ; ac_instr_mnemonic = mnemonic; ac_instr_min_latency = min, ac_instr_max_latency =max;}
  ac_instruction( char* name, char* mnemonic ){ ac_instr_name = name ; ac_instr_mnemonic = mnemonic;}
  ac_instruction( char* name ){ ac_instr_name = name ;}
  ac_instruction( ){ ac_instr_name = "NULL";}
  virtual void behavior(ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0);
  void set_cycles( unsigned c){ ac_instr_cycles = c;}
  unsigned get_cycles(){ return ac_instr_cycles;}
  void set_min_latency( unsigned c){ ac_instr_min_latency = c;}
  unsigned get_min_latency(){ return ac_instr_min_latency;}
  void set_max_latency( unsigned c){ ac_instr_max_latency = c;}
  unsigned get_max_latency(){ return ac_instr_max_latency;}
  unsigned get_size() {return ac_instr_size;}
  void set_size( unsigned s) {ac_instr_size = s;}
  char* get_name() {return ac_instr_name;}
  void set_name( char* name) {ac_instr_name = name;}
  virtual void set_fields( ac_instr instr ){
    cond = instr.get(1); 
  }
  virtual  void print (ostream & os) const{};
  friend ostream& operator<< (ostream &os,const ac_instruction &ins){
  ins.print(os);
  return os;
  };
};

//!Instruction Format class declarations.

class ac_Multiply: public ac_instruction {
protected:
  unsigned cond;
  unsigned opMUL;
  unsigned s;
  unsigned rdMUL;
  unsigned rnMUL;
  unsigned rsMUL;
  unsigned op2MUL;
  unsigned rmMUL;
public:
  ac_Multiply( char* name, char* mnemonic, unsigned min, unsigned max ):ac_instruction(name, mnemonic, min, max){};
  ac_Multiply( char* name, char *mnemonic ):ac_instruction(name, mnemonic) {};
  ac_Multiply( char* name ):ac_instruction(name) {};
  ac_Multiply( ):ac_instruction() {};
  void set_fields( ac_instr instr ){
    cond = instr.get(1); 
    opMUL = instr.get(2); 
    s = instr.get(3); 
    rdMUL = instr.get(4); 
    rnMUL = instr.get(5); 
    rsMUL = instr.get(6); 
    op2MUL = instr.get(7); 
    rmMUL = instr.get(8); 
    ac_instr_size = 32; 
  }
  virtual void behavior( ac_stage_list stage=(ac_stage_list)0, unsigned cycle=0 );
  virtual void print (ostream & os) const{
    os  << "cond: " << cond << ", "  << "opMUL: " << opMUL << ", "  << "s: " << s << ", "  << "rdMUL: " << rdMUL << ", "  << "rnMUL: " << rnMUL << ", "  << "rsMUL: " << rsMUL << ", "  << "op2MUL: " << op2MUL << ", "  << "rmMUL: " << rmMUL;
}
};

class ac_Multiply_Long: public ac_instruction {
protected:
  unsigned cond;
  unsigned opMULL;
  unsigned s;
  unsigned rdHi;
  unsigned rdLo;
  unsigned rnMULL;
  unsigned op2MULL;
  unsigned rmMULL;
public:
  ac_Multiply_Long( char* name, char* mnemonic, unsigned min, unsigned max ):ac_instruction(name, mnemonic, min, max){};
  ac_Multiply_Long( char* name, char *mnemonic ):ac_instruction(name, mnemonic) {};
  ac_Multiply_Long( char* name ):ac_instruction(name) {};
  ac_Multiply_Long( ):ac_instruction() {};
  void set_fields( ac_instr instr ){
    cond = instr.get(1); 
    opMULL = instr.get(9); 
    s = instr.get(3); 
    rdHi = instr.get(10); 
    rdLo = instr.get(11); 
    rnMULL = instr.get(12); 
    op2MULL = instr.get(13); 
    rmMULL = instr.get(14); 
    ac_instr_size = 32; 
  }
  virtual void behavior( ac_stage_list stage=(ac_stage_list)0, unsigned cycle=0 );
  virtual void print (ostream & os) const{
    os  << "cond: " << cond << ", "  << "opMULL: " << opMULL << ", "  << "s: " << s << ", "  << "rdHi: " << rdHi << ", "  << "rdLo: " << rdLo << ", "  << "rnMULL: " << rnMULL << ", "  << "op2MULL: " << op2MULL << ", "  << "rmMULL: " << rmMULL;
}
};

class ac_Data_Processing: public ac_instruction {
protected:
  unsigned cond;
  unsigned opDP;
  unsigned i;
  unsigned opcode;
  unsigned s;
  unsigned rnDP;
  unsigned rdDP;
  unsigned rotImmDp;
  unsigned immDp;
  unsigned shifImmDp;
  unsigned shiftDp;
  unsigned zeroDp;
  unsigned rmDp;
  unsigned rsDp;
  unsigned zero1Dp;
  unsigned shift1Dp;
  unsigned oneDp;
  unsigned rm1Dp;
public:
  ac_Data_Processing( char* name, char* mnemonic, unsigned min, unsigned max ):ac_instruction(name, mnemonic, min, max){};
  ac_Data_Processing( char* name, char *mnemonic ):ac_instruction(name, mnemonic) {};
  ac_Data_Processing( char* name ):ac_instruction(name) {};
  ac_Data_Processing( ):ac_instruction() {};
  void set_fields( ac_instr instr ){
    cond = instr.get(1); 
    opDP = instr.get(15); 
    i = instr.get(16); 
    opcode = instr.get(17); 
    s = instr.get(3); 
    rnDP = instr.get(18); 
    rdDP = instr.get(19); 
    rotImmDp = instr.get(20); 
    immDp = instr.get(21); 
    shifImmDp = instr.get(22); 
    shiftDp = instr.get(23); 
    zeroDp = instr.get(24); 
    rmDp = instr.get(25); 
    rsDp = instr.get(26); 
    zero1Dp = instr.get(27); 
    shift1Dp = instr.get(28); 
    oneDp = instr.get(29); 
    rm1Dp = instr.get(30); 
    ac_instr_size = 32; 
  }
  virtual void behavior( ac_stage_list stage=(ac_stage_list)0, unsigned cycle=0 );
  virtual void print (ostream & os) const{
    os  << "cond: " << cond << ", "  << "opDP: " << opDP << ", "  << "i: " << i << ", "  << "opcode: " << opcode << ", "  << "s: " << s << ", "  << "rnDP: " << rnDP << ", "  << "rdDP: " << rdDP << ", "  << "rotImmDp: " << rotImmDp << ", "  << "immDp: " << immDp << ", "  << "shifImmDp: " << shifImmDp << ", "  << "shiftDp: " << shiftDp << ", "  << "zeroDp: " << zeroDp << ", "  << "rmDp: " << rmDp << ", "  << "rsDp: " << rsDp << ", "  << "zero1Dp: " << zero1Dp << ", "  << "shift1Dp: " << shift1Dp << ", "  << "oneDp: " << oneDp << ", "  << "rm1Dp: " << rm1Dp;
}
};

class ac_Branch: public ac_instruction {
protected:
  unsigned cond;
  unsigned op;
  unsigned l;
  unsigned offset;
public:
  ac_Branch( char* name, char* mnemonic, unsigned min, unsigned max ):ac_instruction(name, mnemonic, min, max){};
  ac_Branch( char* name, char *mnemonic ):ac_instruction(name, mnemonic) {};
  ac_Branch( char* name ):ac_instruction(name) {};
  ac_Branch( ):ac_instruction() {};
  void set_fields( ac_instr instr ){
    cond = instr.get(1); 
    op = instr.get(31); 
    l = instr.get(32); 
    offset = instr.get(33); 
    ac_instr_size = 32; 
  }
  virtual void behavior( ac_stage_list stage=(ac_stage_list)0, unsigned cycle=0 );
  virtual void print (ostream & os) const{
    os  << "cond: " << cond << ", "  << "op: " << op << ", "  << "l: " << l << ", "  << "offset: " << offset;
}
};

class ac_Branch_and_Exchange: public ac_instruction {
protected:
  unsigned cond;
  unsigned opBE;
  unsigned uns;
  unsigned opBE2;
  unsigned rn;
public:
  ac_Branch_and_Exchange( char* name, char* mnemonic, unsigned min, unsigned max ):ac_instruction(name, mnemonic, min, max){};
  ac_Branch_and_Exchange( char* name, char *mnemonic ):ac_instruction(name, mnemonic) {};
  ac_Branch_and_Exchange( char* name ):ac_instruction(name) {};
  ac_Branch_and_Exchange( ):ac_instruction() {};
  void set_fields( ac_instr instr ){
    cond = instr.get(1); 
    opBE = instr.get(34); 
    uns = instr.get(35); 
    opBE2 = instr.get(36); 
    rn = instr.get(37); 
    ac_instr_size = 32; 
  }
  virtual void behavior( ac_stage_list stage=(ac_stage_list)0, unsigned cycle=0 );
  virtual void print (ostream & os) const{
    os  << "cond: " << cond << ", "  << "opBE: " << opBE << ", "  << "uns: " << uns << ", "  << "opBE2: " << opBE2 << ", "  << "rn: " << rn;
}
};

class ac_Single_Data_Transfer: public ac_instruction {
protected:
  unsigned cond;
  unsigned opSDT;
  unsigned i;
  unsigned p;
  unsigned u;
  unsigned b;
  unsigned w;
  unsigned x;
  unsigned rnSDT;
  unsigned rd;
  unsigned addr_modeSDT;
public:
  ac_Single_Data_Transfer( char* name, char* mnemonic, unsigned min, unsigned max ):ac_instruction(name, mnemonic, min, max){};
  ac_Single_Data_Transfer( char* name, char *mnemonic ):ac_instruction(name, mnemonic) {};
  ac_Single_Data_Transfer( char* name ):ac_instruction(name) {};
  ac_Single_Data_Transfer( ):ac_instruction() {};
  void set_fields( ac_instr instr ){
    cond = instr.get(1); 
    opSDT = instr.get(38); 
    i = instr.get(16); 
    p = instr.get(39); 
    u = instr.get(40); 
    b = instr.get(41); 
    w = instr.get(42); 
    x = instr.get(43); 
    rnSDT = instr.get(44); 
    rd = instr.get(45); 
    addr_modeSDT = instr.get(46); 
    ac_instr_size = 32; 
  }
  virtual void behavior( ac_stage_list stage=(ac_stage_list)0, unsigned cycle=0 );
  virtual void print (ostream & os) const{
    os  << "cond: " << cond << ", "  << "opSDT: " << opSDT << ", "  << "i: " << i << ", "  << "p: " << p << ", "  << "u: " << u << ", "  << "b: " << b << ", "  << "w: " << w << ", "  << "x: " << x << ", "  << "rnSDT: " << rnSDT << ", "  << "rd: " << rd << ", "  << "addr_modeSDT: " << addr_modeSDT;
}
};

class ac_HalfWord_Immediate_Offset: public ac_instruction {
protected:
  unsigned cond;
  unsigned opHIO;
  unsigned p;
  unsigned u;
  unsigned b;
  unsigned w;
  unsigned x;
  unsigned rnHIO;
  unsigned rd;
  unsigned addr_modeHIO;
  unsigned opHIO2;
  unsigned addr_modeHIO2;
public:
  ac_HalfWord_Immediate_Offset( char* name, char* mnemonic, unsigned min, unsigned max ):ac_instruction(name, mnemonic, min, max){};
  ac_HalfWord_Immediate_Offset( char* name, char *mnemonic ):ac_instruction(name, mnemonic) {};
  ac_HalfWord_Immediate_Offset( char* name ):ac_instruction(name) {};
  ac_HalfWord_Immediate_Offset( ):ac_instruction() {};
  void set_fields( ac_instr instr ){
    cond = instr.get(1); 
    opHIO = instr.get(47); 
    p = instr.get(39); 
    u = instr.get(40); 
    b = instr.get(41); 
    w = instr.get(42); 
    x = instr.get(43); 
    rnHIO = instr.get(48); 
    rd = instr.get(45); 
    addr_modeHIO = instr.get(49); 
    opHIO2 = instr.get(50); 
    addr_modeHIO2 = instr.get(51); 
    ac_instr_size = 32; 
  }
  virtual void behavior( ac_stage_list stage=(ac_stage_list)0, unsigned cycle=0 );
  virtual void print (ostream & os) const{
    os  << "cond: " << cond << ", "  << "opHIO: " << opHIO << ", "  << "p: " << p << ", "  << "u: " << u << ", "  << "b: " << b << ", "  << "w: " << w << ", "  << "x: " << x << ", "  << "rnHIO: " << rnHIO << ", "  << "rd: " << rd << ", "  << "addr_modeHIO: " << addr_modeHIO << ", "  << "opHIO2: " << opHIO2 << ", "  << "addr_modeHIO2: " << addr_modeHIO2;
}
};

//!Instruction class declarations.

class ac_mla: public ac_Multiply {
public:
  ac_mla( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Multiply(name, mnemonic, min, max){};
  ac_mla( char* name, char *mnemonic ):ac_Multiply(name, mnemonic) {};
  ac_mla( char* name ):ac_Multiply(name) {};
  ac_mla( ):ac_Multiply() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_mul: public ac_Multiply {
public:
  ac_mul( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Multiply(name, mnemonic, min, max){};
  ac_mul( char* name, char *mnemonic ):ac_Multiply(name, mnemonic) {};
  ac_mul( char* name ):ac_Multiply(name) {};
  ac_mul( ):ac_Multiply() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_umull: public ac_Multiply_Long {
public:
  ac_umull( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Multiply_Long(name, mnemonic, min, max){};
  ac_umull( char* name, char *mnemonic ):ac_Multiply_Long(name, mnemonic) {};
  ac_umull( char* name ):ac_Multiply_Long(name) {};
  ac_umull( ):ac_Multiply_Long() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_umlal: public ac_Multiply_Long {
public:
  ac_umlal( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Multiply_Long(name, mnemonic, min, max){};
  ac_umlal( char* name, char *mnemonic ):ac_Multiply_Long(name, mnemonic) {};
  ac_umlal( char* name ):ac_Multiply_Long(name) {};
  ac_umlal( ):ac_Multiply_Long() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_smull: public ac_Multiply_Long {
public:
  ac_smull( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Multiply_Long(name, mnemonic, min, max){};
  ac_smull( char* name, char *mnemonic ):ac_Multiply_Long(name, mnemonic) {};
  ac_smull( char* name ):ac_Multiply_Long(name) {};
  ac_smull( ):ac_Multiply_Long() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_smlal: public ac_Multiply_Long {
public:
  ac_smlal( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Multiply_Long(name, mnemonic, min, max){};
  ac_smlal( char* name, char *mnemonic ):ac_Multiply_Long(name, mnemonic) {};
  ac_smlal( char* name ):ac_Multiply_Long(name) {};
  ac_smlal( ):ac_Multiply_Long() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_and1: public ac_Data_Processing {
public:
  ac_and1( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_and1( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_and1( char* name ):ac_Data_Processing(name) {};
  ac_and1( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_eor: public ac_Data_Processing {
public:
  ac_eor( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_eor( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_eor( char* name ):ac_Data_Processing(name) {};
  ac_eor( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_sub: public ac_Data_Processing {
public:
  ac_sub( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_sub( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_sub( char* name ):ac_Data_Processing(name) {};
  ac_sub( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_rsb: public ac_Data_Processing {
public:
  ac_rsb( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_rsb( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_rsb( char* name ):ac_Data_Processing(name) {};
  ac_rsb( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_add: public ac_Data_Processing {
public:
  ac_add( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_add( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_add( char* name ):ac_Data_Processing(name) {};
  ac_add( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_adc: public ac_Data_Processing {
public:
  ac_adc( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_adc( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_adc( char* name ):ac_Data_Processing(name) {};
  ac_adc( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_sbc: public ac_Data_Processing {
public:
  ac_sbc( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_sbc( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_sbc( char* name ):ac_Data_Processing(name) {};
  ac_sbc( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_rsc: public ac_Data_Processing {
public:
  ac_rsc( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_rsc( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_rsc( char* name ):ac_Data_Processing(name) {};
  ac_rsc( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_tst: public ac_Data_Processing {
public:
  ac_tst( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_tst( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_tst( char* name ):ac_Data_Processing(name) {};
  ac_tst( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_teq: public ac_Data_Processing {
public:
  ac_teq( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_teq( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_teq( char* name ):ac_Data_Processing(name) {};
  ac_teq( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_cmp: public ac_Data_Processing {
public:
  ac_cmp( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_cmp( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_cmp( char* name ):ac_Data_Processing(name) {};
  ac_cmp( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_cmn: public ac_Data_Processing {
public:
  ac_cmn( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_cmn( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_cmn( char* name ):ac_Data_Processing(name) {};
  ac_cmn( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_orr: public ac_Data_Processing {
public:
  ac_orr( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_orr( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_orr( char* name ):ac_Data_Processing(name) {};
  ac_orr( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_mov: public ac_Data_Processing {
public:
  ac_mov( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_mov( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_mov( char* name ):ac_Data_Processing(name) {};
  ac_mov( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_bic: public ac_Data_Processing {
public:
  ac_bic( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_bic( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_bic( char* name ):ac_Data_Processing(name) {};
  ac_bic( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_mvn: public ac_Data_Processing {
public:
  ac_mvn( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Data_Processing(name, mnemonic, min, max){};
  ac_mvn( char* name, char *mnemonic ):ac_Data_Processing(name, mnemonic) {};
  ac_mvn( char* name ):ac_Data_Processing(name) {};
  ac_mvn( ):ac_Data_Processing() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_b: public ac_Branch {
public:
  ac_b( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Branch(name, mnemonic, min, max){};
  ac_b( char* name, char *mnemonic ):ac_Branch(name, mnemonic) {};
  ac_b( char* name ):ac_Branch(name) {};
  ac_b( ):ac_Branch() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_bl: public ac_Branch {
public:
  ac_bl( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Branch(name, mnemonic, min, max){};
  ac_bl( char* name, char *mnemonic ):ac_Branch(name, mnemonic) {};
  ac_bl( char* name ):ac_Branch(name) {};
  ac_bl( ):ac_Branch() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_bx: public ac_Branch_and_Exchange {
public:
  ac_bx( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Branch_and_Exchange(name, mnemonic, min, max){};
  ac_bx( char* name, char *mnemonic ):ac_Branch_and_Exchange(name, mnemonic) {};
  ac_bx( char* name ):ac_Branch_and_Exchange(name) {};
  ac_bx( ):ac_Branch_and_Exchange() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_blx: public ac_Branch_and_Exchange {
public:
  ac_blx( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Branch_and_Exchange(name, mnemonic, min, max){};
  ac_blx( char* name, char *mnemonic ):ac_Branch_and_Exchange(name, mnemonic) {};
  ac_blx( char* name ):ac_Branch_and_Exchange(name) {};
  ac_blx( ):ac_Branch_and_Exchange() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_ldr: public ac_Single_Data_Transfer {
public:
  ac_ldr( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Single_Data_Transfer(name, mnemonic, min, max){};
  ac_ldr( char* name, char *mnemonic ):ac_Single_Data_Transfer(name, mnemonic) {};
  ac_ldr( char* name ):ac_Single_Data_Transfer(name) {};
  ac_ldr( ):ac_Single_Data_Transfer() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_ldrb: public ac_Single_Data_Transfer {
public:
  ac_ldrb( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Single_Data_Transfer(name, mnemonic, min, max){};
  ac_ldrb( char* name, char *mnemonic ):ac_Single_Data_Transfer(name, mnemonic) {};
  ac_ldrb( char* name ):ac_Single_Data_Transfer(name) {};
  ac_ldrb( ):ac_Single_Data_Transfer() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_ldrbt: public ac_Single_Data_Transfer {
public:
  ac_ldrbt( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Single_Data_Transfer(name, mnemonic, min, max){};
  ac_ldrbt( char* name, char *mnemonic ):ac_Single_Data_Transfer(name, mnemonic) {};
  ac_ldrbt( char* name ):ac_Single_Data_Transfer(name) {};
  ac_ldrbt( ):ac_Single_Data_Transfer() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_ldrt: public ac_Single_Data_Transfer {
public:
  ac_ldrt( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Single_Data_Transfer(name, mnemonic, min, max){};
  ac_ldrt( char* name, char *mnemonic ):ac_Single_Data_Transfer(name, mnemonic) {};
  ac_ldrt( char* name ):ac_Single_Data_Transfer(name) {};
  ac_ldrt( ):ac_Single_Data_Transfer() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_str: public ac_Single_Data_Transfer {
public:
  ac_str( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Single_Data_Transfer(name, mnemonic, min, max){};
  ac_str( char* name, char *mnemonic ):ac_Single_Data_Transfer(name, mnemonic) {};
  ac_str( char* name ):ac_Single_Data_Transfer(name) {};
  ac_str( ):ac_Single_Data_Transfer() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_strb: public ac_Single_Data_Transfer {
public:
  ac_strb( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Single_Data_Transfer(name, mnemonic, min, max){};
  ac_strb( char* name, char *mnemonic ):ac_Single_Data_Transfer(name, mnemonic) {};
  ac_strb( char* name ):ac_Single_Data_Transfer(name) {};
  ac_strb( ):ac_Single_Data_Transfer() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_strbt: public ac_Single_Data_Transfer {
public:
  ac_strbt( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Single_Data_Transfer(name, mnemonic, min, max){};
  ac_strbt( char* name, char *mnemonic ):ac_Single_Data_Transfer(name, mnemonic) {};
  ac_strbt( char* name ):ac_Single_Data_Transfer(name) {};
  ac_strbt( ):ac_Single_Data_Transfer() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_strt: public ac_Single_Data_Transfer {
public:
  ac_strt( char* name, char* mnemonic, unsigned min, unsigned max ):ac_Single_Data_Transfer(name, mnemonic, min, max){};
  ac_strt( char* name, char *mnemonic ):ac_Single_Data_Transfer(name, mnemonic) {};
  ac_strt( char* name ):ac_Single_Data_Transfer(name) {};
  ac_strt( ):ac_Single_Data_Transfer() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_ldrh: public ac_HalfWord_Immediate_Offset {
public:
  ac_ldrh( char* name, char* mnemonic, unsigned min, unsigned max ):ac_HalfWord_Immediate_Offset(name, mnemonic, min, max){};
  ac_ldrh( char* name, char *mnemonic ):ac_HalfWord_Immediate_Offset(name, mnemonic) {};
  ac_ldrh( char* name ):ac_HalfWord_Immediate_Offset(name) {};
  ac_ldrh( ):ac_HalfWord_Immediate_Offset() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_ldrsb: public ac_HalfWord_Immediate_Offset {
public:
  ac_ldrsb( char* name, char* mnemonic, unsigned min, unsigned max ):ac_HalfWord_Immediate_Offset(name, mnemonic, min, max){};
  ac_ldrsb( char* name, char *mnemonic ):ac_HalfWord_Immediate_Offset(name, mnemonic) {};
  ac_ldrsb( char* name ):ac_HalfWord_Immediate_Offset(name) {};
  ac_ldrsb( ):ac_HalfWord_Immediate_Offset() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_ldrsh: public ac_HalfWord_Immediate_Offset {
public:
  ac_ldrsh( char* name, char* mnemonic, unsigned min, unsigned max ):ac_HalfWord_Immediate_Offset(name, mnemonic, min, max){};
  ac_ldrsh( char* name, char *mnemonic ):ac_HalfWord_Immediate_Offset(name, mnemonic) {};
  ac_ldrsh( char* name ):ac_HalfWord_Immediate_Offset(name) {};
  ac_ldrsh( ):ac_HalfWord_Immediate_Offset() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};

class ac_strh: public ac_HalfWord_Immediate_Offset {
public:
  ac_strh( char* name, char* mnemonic, unsigned min, unsigned max ):ac_HalfWord_Immediate_Offset(name, mnemonic, min, max){};
  ac_strh( char* name, char *mnemonic ):ac_HalfWord_Immediate_Offset(name, mnemonic) {};
  ac_strh( char* name ):ac_HalfWord_Immediate_Offset(name) {};
  ac_strh( ):ac_HalfWord_Immediate_Offset() {};
  void behavior( ac_stage_list  stage = (ac_stage_list)0, unsigned cycle=0 );
  void print (ostream & os) const{
    os << ac_instr_mnemonic << "	";}
};



#endif  //_AC_TYPES_H
