/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */

/*  ArchC Syscall Library for the ArchC architecture simulators
    Copyright (C) 2002-2004  The ArchC Team

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.
*/

/********************************************************/
/* ArchC Syscalls header file.                          */
/* Author:  Marcus Bartholomeu                          */
/*                                                      */
/*                                                      */
/* The ArchC Team                                       */
/* Computer Systems Laboratory (LSC)                    */
/* IC-UNICAMP                                           */
/* http://www.lsc.ic.unicamp.br                         */
/********************************************************/

#ifndef AC_SYSCALL_H
#define AC_SYSCALL_H

#ifdef USE_GDB
#include "ac_gdb.H"

extern AC_GDB *gdbstub;
#endif /* USE_GDB */

class ac_syscall
{
public:

#define AC_SYSC(NAME,LOCATION) \
  void NAME();

#include <ac_syscall.def>

#undef AC_SYSC


  //!Target dependent functions
  virtual void get_buffer(int argn, unsigned char* buf, unsigned int size) =0;
  virtual void set_buffer(int argn, unsigned char* buf, unsigned int size) =0;
  virtual int  get_int(int argn) =0;
  virtual void set_int(int argn, int val) =0;
  virtual void return_from_syscall() =0;
  virtual void set_prog_args(int argc, char *argv[]) =0;
  virtual int  flush_cache() {return 0;};
};

#endif
