/******************************************************
 * ArchC Resources header file.                       *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/
 

#ifndef  _AC_RESOURCES_H
#define  _AC_RESOURCES_H

#include  "ac_storage.H"
#include  "ac_regbank.H"
#include  "ac_reg.H"
#include  "ac_fmt_regs.H"
 
//!ArchC class for Architecture Resources.

class ac_resources {
public:
 
  //!Storage Devices.
  static ac_storage DM;
  static ac_regbank<ac_word> RB;
  static ac_IF_ID IF_ID;
  static ac_ID_EX ID_EX;
  static ac_CPSR CPSR;
  static ac_SPSR SPSR;
  //!Indicates the storage device from where instructions are fetched.
  static ac_storage *IM;

  //!Indicates the storage device where applications are loaded.
  static ac_storage *APP_MEM;

  //!Control Variables.
  static bool IF_stall;
  static bool ID_stall;
  static bool IF_flush;
  static bool ID_flush;
  static bool ac_wait_sig;
  static bool ac_parallel_sig;
  static bool ac_tgt_endian;
  static ac_reg<unsigned> ac_pc;
  static unsigned ac_start_addr;
  static unsigned long long ac_instr_counter;
  static unsigned long long ac_cycle_counter;
  static double time_step;
  static int argc;
  static char **argv;
 

  //!Constructor.
  ac_resources();
 
  //!Initializing program arguments.
  static void set_args( int ac, char **av){
    argc = ac;
    argv = av;
  
  };
 
  //!Delayed Assignment.
  static change_log delay( ac_word value, unsigned clocks){
    return change_log( 0, value, clocks + ac_cycle_counter );
  };

  //!Stall method.
  static void ac_stall( char *stage ){
    if( !strcmp( "IF", stage ) )
      IF_stall = 1;
    else if( !strcmp( "ID", stage ) )
      ID_stall = 1;
  };
  //!Put the simulator on the wait state.
  static void ac_wait(){
    ac_wait_sig = 1;
  };

  //!Release the simulator from the wait state.
  static void ac_release(){
    ac_wait_sig = 0;
  };


  //!Force Paralelism.
  static void ac_parallel( ){
    ac_parallel_sig = 1;
  };

  //!Flush method.
  static void ac_flush( char *stage ){
    if( !strcmp( "IF", stage ) )
      IF_flush = 1;
    else if( !strcmp( "ID", stage ) )
      ID_flush = 1;
  };
};

//!Global aliases for resources.
extern ac_storage &DM;
extern ac_regbank<ac_word> &RB;
extern ac_IF_ID &IF_ID;
extern ac_ID_EX &ID_EX;
extern ac_CPSR &CPSR;
extern ac_SPSR &SPSR;
extern bool &IF_stall;
extern bool &ID_stall;
extern bool &IF_flush;
extern bool &ID_flush;
extern bool &ac_wait_sig;
extern bool &ac_tgt_endian;
extern ac_reg<unsigned> &ac_pc;
extern unsigned &ac_start_addr;
extern unsigned long long &ac_instr_counter;
extern unsigned long long &ac_cycle_counter;
extern double &time_step;

#endif  //_AC_RESOURCES_H
