/******************************************************
 * Stage Module Implementation File.                  *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/
 

#include  "IF.H"

#include  "arm7_syscall.H"

void AC_IF::IF::behavior() {

  ac_instruction *instr, *format;
  unsigned  ins_id;
  arm7_syscall syscall;
  static int flushes_left=7;
  static ac_instr *the_nop = new ac_instr;
  char fetch[AC_WORDSIZE/8];

  cache_item* ins_cache;
  extern unsigned int decode_pc, quant;
  extern unsigned char buffer[AC_MAX_BUFFER];
  ac_instr *instr_vec;

  if( bhv_pc.read() >= dec_cache_size){
    cerr << "ArchC: Address out of bounds (pc=0x" << hex << bhv_pc.read() << ")." << endl;
    ac_stop();
    return;
  }
  else {
    if( start_up ){
      decode_pc = ac_start_addr;
      syscall.set_prog_args(argc, argv);
      start_up=0;
      init_dec_cache();
    }
    else{ 
      decode_pc = bhv_pc.read();
    }
 
  //!Handling System calls.
    if (decode_pc % 2) decode_pc--;
    switch( decode_pc ){
#define AC_SYSC(NAME,LOCATION) \
    case LOCATION: \
      if (flushes_left) { \
        fflush(0);\
        flushes_left--;\
      } \
      else { \
        fflush(0);\
        syscall.NAME(); \
        ac_instr_counter++; \
        flushes_left = 7; \
      } \
      regout.write( *the_nop); \
      if (! (ac_pc.read() % 2)) ac_pc.write(ac_pc.read() + 1); \
      else ac_pc.write(ac_pc.read() - 1); \
      break;  \


#include <ac_syscall.def>

#undef AC_SYSC

    default:
    ins_cache = (DEC_CACHE+decode_pc);
    if ( !ins_cache->valid ){
      *((ac_fetch*)(fetch)) = IM->read( decode_pc );

      quant = 0;
      ins_cache->instr_p = new ac_instr( Decode(ISA.decoder, buffer, quant));
      ins_cache->valid = 1;
    }
    instr_vec = ins_cache->instr_p;
    ins_id = instr_vec->get(IDENT);

    if( ins_id == 0 ) {
      cerr << "ArchC Error: Unidentified instruction. " << endl;
      cerr << "PC = " << hex << decode_pc << dec << endl;
      ac_stop();
      return;
    }

      instr = (ac_instruction *)ISA.instr_table[ins_id][1];
      format = (ac_instruction *)ISA.instr_table[ins_id][2];
      ISA.instruction.set_fields( *instr_vec  );
      format->set_fields( *instr_vec  );
      instr->set_fields( *instr_vec  );
      ISA.instruction.set_size(instr->get_size());
      ac_pc = decode_pc;
      ISA.instruction.behavior( (ac_stage_list) id );
      format->behavior((ac_stage_list) id );
      instr->behavior((ac_stage_list) id );
      regout.write( *instr_vec);
      ac_instr_counter++;
      break;
    }
    bhv_done.write(1);
  }
}

