/**
 * @file      ARM7_isa.ac
 * @author    Roberto Viana
 *
 *            GPEC
 *            http://www.gpec.ucdb.br/
 *
 *
 * @version   1.0
 * @date      
 * 
 */

#include "archc.H"
#include "ac_types.H"
#include "ac_parms.H"
#include  "arm7-isa.H"
#include  "ac_isa_init.cpp"

#define PC 15 // program counter
#define LR 14 // Link Register

ac_Uword ex_res, shift_carry, shifter_carry_out;
bool execute=false;
/************************************************************************/


/************************************************************************/
long signExtend(long bitSeq, int bitSeq_length){
	if(bitSeq_length <= 0)
		return bitSeq;
	
	if((bitSeq & (1 << bitSeq_length - 1)) != 0)
		bitSeq |= (((unsigned long)0xFFFFFFFF) << bitSeq_length);
	else 
		bitSeq &= (((unsigned long)0xFFFFFFFF) >> (32 - bitSeq_length));
	
	return bitSeq;
}

long rotateRight(int rotate_imm, long reg) {
	long temp = reg;

	if(rotate_imm <= 0){
		return temp;

	}
	//Masks
	unsigned long mask1 = ((unsigned long)0xFFFFFFFF) >> (32 - rotate_imm);
	unsigned long mask2 = ((unsigned long)0xFFFFFFFF) >> rotate_imm;
	//value which must be glued to the left of the shifted quantity
	unsigned long buff = temp & mask1; 
	
	temp = (temp >> rotate_imm) & mask2;
	buff <<= (32 - rotate_imm);
	temp |= buff;
	
	return temp;
}

void copySPSR(){

	CPSR.n=SPSR.n;
	CPSR.z=SPSR.z;
	CPSR.c=SPSR.c;
	CPSR.v=SPSR.v;
	CPSR.q=SPSR.q;
	CPSR.DMN=SPSR.DMN;
	CPSR.I=SPSR.I;
	CPSR.F=SPSR.F;
	CPSR.T=SPSR.T;
	CPSR.M4=SPSR.M4;
	CPSR.M3=SPSR.M3;
	CPSR.M2=SPSR.M2;
	CPSR.M1=SPSR.M1;
	CPSR.M0=SPSR.M0;

}

void ac_behavior( instruction ){

  switch( stage ) {
  case IF:
		ac_pc += 4; //points to the next instruction
		RB.write(PC, ac_pc); //update the program counter register
		IF_ID.npc=ac_pc;
		
    break;

  case ID:
    break;

  case EX:
		switch(cond){
					case 0x0: // EQ
						if(CPSR.z==1)execute=true;
					break;
					case 0x1: // NE
						if(CPSR.z==0)execute=true;						
					break; 
					case 0x2: // CS/HS
						if(CPSR.c==1)execute=true;						
					break;
					case 0x3: // CC/LO
						if(CPSR.c==0)execute=true;						
					break;
					case 0x4: // MI
						if(CPSR.n==1)execute=true;						
					break;
					case 0x5: // PL
						if(CPSR.n==0)execute=true;						
					break; 
					case 0x6: // VS
						if(CPSR.v==1)execute=true;						
					break;
					case 0x7: // VC
						if(CPSR.v==0)execute=true;						
					break; 
					case 0x8: // HI
						if(CPSR.c==1 && CPSR.z==0)execute=true;
					break;
					case 0x9: // LS
						if(CPSR.c==0 || CPSR.z==1)execute=true;
					break;
					case 0xA: // GE
						if(CPSR.n==CPSR.v)execute=true;
					break;
					case 0xB: // LT
						if(CPSR.n!=CPSR.v)execute=true;
					break; 
					case 0xC: // GT
						if(CPSR.z==0 && CPSR.n==CPSR.v)execute=true;
					break;
					case 0xD: // LE
						if(CPSR.z==1 || CPSR.n!=CPSR.v)execute=true;
					break;
					case 0xE: // AL
						execute=true;
					break;
					
					default: 
						execute = false;
					break;
				}
    break;

  default:
    break;
  }
};
/*
void ac_behavior( Type_MultiplyLong ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
    break;

  default:
    break;
  }
}
*/

void ac_behavior( Type_Branch ){

  switch( stage ) {
  case IF:
		break;

  case ID:
		if(execute==false)break;

		ID_EX.npc = IF_ID.npc;
		
		if(func3==5)
				ID_EX.signed_immed_24=offset;
		
		else if(func3==0){
				ID_EX.rm=rm;
				ID_EX.data1=RB.read(rm);
				
		}
    break;

  case EX:
		if(!execute)
    	break;

  default:
    break;
  }
}

void ac_behavior( Type_Multiply ){

  switch( stage ) {
  case IF:
		break;

  case ID:
		if(execute==false)break;

		ID_EX.npc = IF_ID.npc;
		ID_EX.rd=rd;
		ID_EX.rs=rs;
		ID_EX.rm=rm;

		if(func2==0){
	
				ID_EX.data1=RB.read(rm);
				ID_EX.data2=RB.read(rs);
		}
		else if(func2==1){
				ID_EX.data1=RB.read(rm);
				ID_EX.data2=RB.read(rs);
				ID_EX.data3=RB.read(rn);
		}
    break;

  case EX:
		if(!execute)
    	break;

  default:
    break;
  }
}

//! Common behaviour for all DataProc_PSRTransf Type instructions
void ac_behavior( Type_DataProc ){

  switch( stage ) {
  case IF:
		break;

  case ID:
		if(execute==false)break;
		ID_EX.npc = IF_ID.npc;
		ID_EX.rd=rd;
		ID_EX.rn=rn;
    ID_EX.data1=RB.read(rn);
 	
    break;

  case EX:
		if(!execute)
			break;
		if (I==1){
				ID_EX.data2=rotateRight(immed_8,rotate_imm);
		
				if(rotate_imm == 0)
					shifter_carry_out=CPSR.c;
				else if(rotate_imm != 0)
					shifter_carry_out=ID_EX.data2>>31;
		}

		else if (I==0){

				ID_EX.data2=RB.read(rm);
				shifter_carry_out= CPSR.c;
		}

    break;

  default:
    break;
  }
}

void ac_behavior( b ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		RB.write(PC, RB.read(PC) + (signExtend(ID_EX.signed_immed_24, 24) << 2));
    break;

  default:
    break;
  }
};

void ac_behavior( bl ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		RB.write(LR,RB.read(PC));
		RB.write(PC, RB.read(PC) + (signExtend(ID_EX.signed_immed_24, 24) << 2));
		
    break;

  default:
    break;
  }
};

void ac_behavior( bx ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		CPSR.T=RB.read(rm)>>0;
		RB.write(PC, ID_EX.data1 & 0xfffffffe);
    break;

  default:
    break;
  }
};


void ac_behavior( add ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
	
		ex_res=ID_EX.data1 + ID_EX.data2;
		RB.write(rd, ex_res);
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n= RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~ex_res & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~ex_res & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & ex_res & 0x80000000) );
		}

    cerr<< "Ricardo\n"<<RB.read(rd);
    break;

  default:
    break;
  }
};

void ac_behavior( adc ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		shift_carry= (0x00000000 | CPSR.c) << 31;
		ex_res=ID_EX.data1 + ID_EX.data2 + shift_carry;
		RB.write(rd, ex_res);
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=((ID_EX.data1 & ID_EX.data2 & shift_carry & 0x80000000)|
								(~ex_res & (ID_EX.data1 | ID_EX.data2 | shift_carry)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & shift_carry & ~ex_res & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 &  ~shift_carry & ex_res & 0x80000000) );
		}

    cerr<< "Ricardo\n"+RB.read(rd);
    break;

  default:
    break;
  }
};

void ac_behavior( sbc ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		shift_carry= (0x00000000 | CPSR.c) << 31;
		ex_res=ID_EX.data1 - ID_EX.data2 - ~shift_carry;
		RB.write(rd, ex_res);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & shift_carry & 0x80000000)|
								(~ex_res & (ID_EX.data1 | ID_EX.data2 | shift_carry)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & shift_carry & ~ex_res & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 &  ~shift_carry & ex_res & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( sub ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		
		ex_res=ID_EX.data1 - ID_EX.data2;
		RB.write(rd, ex_res);
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n= RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~ex_res & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~ex_res & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & ex_res & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( rsb ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		ex_res=ID_EX.data2 - ID_EX.data1;
		RB.write(rd, ex_res);
		
		if(s==1){
			if(rd==PC){
				copySPSR();
			}
		}
		else if(s==1){
			CPSR.n= RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~ex_res & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~ex_res & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & ex_res & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( rsc ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		
		shift_carry= (0x00000000 | CPSR.c) << 31;
		ex_res=ID_EX.data2 - ID_EX.data1 - ~shift_carry;
		RB.write(rd, ex_res);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & shift_carry & 0x80000000)|
								(~ex_res & (ID_EX.data1 | ID_EX.data2 | shift_carry)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & shift_carry & ~ex_res & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 &  ~shift_carry & ex_res & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( and1 ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		ex_res=ID_EX.data1 & ID_EX.data2;
		RB.write(rd, ex_res);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
	
    break;

  default:
    break;
  }
};

void ac_behavior( orr ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		ex_res=ID_EX.data1 | ID_EX.data2;
		RB.write(rd, ex_res);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
    break;

  default:
    break;
  }
};

void ac_behavior( eor ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		ex_res=ID_EX.data1 ^ ID_EX.data2;
		RB.write(rd, ex_res);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}

    break;

  default:
    break;
  }
};

void ac_behavior( bic ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		
		ex_res=ID_EX.data1 & ~ID_EX.data2;
		RB.write(rd, ex_res);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
    break;

  default:
    break;
  }
};

void ac_behavior( tst ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		ex_res=ID_EX.data1 & ID_EX.data2;
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=ex_res >> 31;
			if(ex_res==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
    break;

  default:
    break;
  }
};

void ac_behavior( teq ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		
		ex_res=ID_EX.data1 ^ ID_EX.data2;
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=ex_res >> 31;
			if(ex_res==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
    break;

  default:
    break;
  }
};

void ac_behavior( cmp ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		ex_res=ID_EX.data1 - ID_EX.data2;
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n= ex_res >> 31;

			if(ex_res==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~ex_res & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~ex_res & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & ex_res & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( cmn ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		ex_res=ID_EX.data1 + ID_EX.data2;
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n= ex_res >> 31;

			if(ex_res==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~ex_res & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~ex_res & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & ex_res & 0x80000000) );
		}

    break;

  default:
    break;
  }
};

void ac_behavior( mov ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		ex_res=ID_EX.data2;
		RB.write(rd, ex_res);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}		
    break;

  default:
    break;
  }
};

void ac_behavior( mvn ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		ex_res=~ID_EX.data2;
		RB.write(rd, ex_res);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}		
    break;

  default:
    break;
  }
};

void ac_behavior( mul ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		ex_res=ID_EX.data1*ID_EX.data2;
		RB.write(rd, ex_res);
		
		if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
		}
    break;

  default:
    break;
  }
};

void ac_behavior( mla ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		ex_res=(ID_EX.data1*ID_EX.data2)+ID_EX.data3;
		RB.write(rd, ex_res);

		if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
		}
    break;

  default:
    break;
  }
};

//!Instruction sys_call behavior method.
void ac_behavior( sys_call ) {

  switch( stage ) {
  case IF:
    break;
    
  case ID:
    break;
    
  case EX:
    exit(EXIT_FAILURE);
    break;
   
  default:
    break;
  }
};

void copySPSR();

