/**
 * @author    Horacio Ortiz
 *
 *            Engenharia de Computação 
 *            Universidade Catolica Dom Bosco (UCDB)
 *
 * @version   1.0
 * @date      Mon, 29 Oct 2007
 *
 */

#include "archc.H"
#include "ac_types.H"
#include "ac_parms.H"
#include  "arm7-isa.H"
#include  "ac_isa_init.cpp"

#define PC 15 // program counter

ac_Uword result, shift_carry, shifter_carry_out;

/************************************************************************/

long rotateRight(int rotate_imm, long reg) {
	long temp = reg;

	if(rotate_imm <= 0){
		return temp;

	}
	//Masks
	unsigned long mask1 = ((unsigned long)0xFFFFFFFF) >> (32 - rotate_imm);
	unsigned long mask2 = ((unsigned long)0xFFFFFFFF) >> rotate_imm;
	//value which must be glued to the left of the shifted quantity
	unsigned long buff = temp & mask1; 
	
	temp = (temp >> rotate_imm) & mask2;
	buff <<= (32 - rotate_imm);
	temp |= buff;
	
	return temp;
}

void copySPSR(){

	CPSR.n=SPSR.n;
	CPSR.z=SPSR.z;
	CPSR.c=SPSR.c;
	CPSR.v=SPSR.v;
	CPSR.q=SPSR.q;
	CPSR.DMN=SPSR.DMN;
	CPSR.I=SPSR.I;
	CPSR.F=SPSR.F;
	CPSR.T=SPSR.T;
	CPSR.M4=SPSR.M4;
	CPSR.M3=SPSR.M3;
	CPSR.M2=SPSR.M2;
	CPSR.M1=SPSR.M1;
	CPSR.M0=SPSR.M0;

}

void ac_behavior( instruction ){

  switch( stage ) {
  case IF:
		ac_pc += 4; //points to the next instruction
		RB.write(PC, ac_pc); //update the program counter register
		IF_ID.npc=ac_pc;
		
    break;

  case ID:
    break;

  case EX:


  default:
    break;
  }
};

void ac_behavior( Type_Multiply ){

  switch( stage ) {
  case IF:		
  case ID:
		ID_EX.npc = IF_ID.npc;
		ID_EX.rd=rd;
		ID_EX.rs=rs;
		ID_EX.rm=rm;

		if(func2==0){
	
				ID_EX.data1=RB.read(rm);
				ID_EX.data2=RB.read(rs);
		}
		else if(func2==1){
				ID_EX.data1=RB.read(rm);
				ID_EX.data2=RB.read(rs);
				ID_EX.data3=RB.read(rn);
		}
    break;

  case EX:
    break;

  default:
    break;
  }
}

// comportamento comum para todo o tipo data process
void ac_behavior( Type_DP ){

  switch( stage ) {
  case IF:
		break;

  case ID:

		ID_EX.npc = IF_ID.npc;
		ID_EX.rd=rd;
		ID_EX.rn=rn;
    ID_EX.data1=RB.read(rn);
 	
    break;

  case EX:
		if (I==1){
				ID_EX.data2=rotateRight(immed_8,rotate_imm);
		
				if(rotate_imm == 0)
					shifter_carry_out=CPSR.c;
				else if(rotate_imm != 0)
					shifter_carry_out=ID_EX.data2>>31;
		}

		else if (I==0){

				ID_EX.data2=RB.read(rm);
				shifter_carry_out= CPSR.c;
		}

    break;

  default:
    break;
  }
}

void ac_behavior( add ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:	result=ID_EX.data1 + ID_EX.data2;
		RB.write(rd, result);
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n= RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~result & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~result & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & result & 0x80000000) );
		}

    cerr<< "Ricardo\n"+RB.read(rd);
    break;

  default:
    break;
  }
};

void ac_behavior( adc ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		shift_carry= (0x00000000 | CPSR.c) << 31;
		result=ID_EX.data1 + ID_EX.data2 + shift_carry;
		RB.write(rd, result);
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=((ID_EX.data1 & ID_EX.data2 & shift_carry & 0x80000000)|
								(~result & (ID_EX.data1 | ID_EX.data2 | shift_carry)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & shift_carry & ~result & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 &  ~shift_carry & result & 0x80000000) );
		}

    cerr<< "Ricardo\n"+RB.read(rd);
    break;

  default:
    break;
  }
};

void ac_behavior( sbc ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		shift_carry= (0x00000000 | CPSR.c) << 31;
		result=ID_EX.data1 - ID_EX.data2 - ~shift_carry;
		RB.write(rd, result);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & shift_carry & 0x80000000)|
								(~result & (ID_EX.data1 | ID_EX.data2 | shift_carry)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & shift_carry & ~result & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 &  ~shift_carry & result & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( sub ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		
		result=ID_EX.data1 - ID_EX.data2;
		RB.write(rd, result);
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n= RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~result & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~result & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & result & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( rsb ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		result=ID_EX.data2 - ID_EX.data1;
		RB.write(rd, result);
		
		if(s==1){
			if(rd==PC){
				copySPSR();
			}
		}
		else if(s==1){
			CPSR.n= RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~result & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~result & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & result & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( rsc ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		
		shift_carry= (0x00000000 | CPSR.c) << 31;
		result=ID_EX.data2 - ID_EX.data1 - ~shift_carry;
		RB.write(rd, result);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;

			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & shift_carry & 0x80000000)|
								(~result & (ID_EX.data1 | ID_EX.data2 | shift_carry)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & shift_carry & ~result & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 &  ~shift_carry & result & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( and1 ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		result=ID_EX.data1 & ID_EX.data2;
		RB.write(rd, result);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
	
    break;

  default:
    break;
  }
};

void ac_behavior( orr ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		result=ID_EX.data1 | ID_EX.data2;
		RB.write(rd, result);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
    break;

  default:
    break;
  }
};

void ac_behavior( eor ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		result=ID_EX.data1 ^ ID_EX.data2;
		RB.write(rd, result);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}

    break;

  default:
    break;
  }
};

void ac_behavior( bic ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		
		result=ID_EX.data1 & ~ID_EX.data2;
		RB.write(rd, result);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
    break;

  default:
    break;
  }
};

void ac_behavior( tst ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		result=ID_EX.data1 & ID_EX.data2;
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=result >> 31;
			if(result==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
    break;

  default:
    break;
  }
};

void ac_behavior( teq ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		
		result=ID_EX.data1 ^ ID_EX.data2;
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=result >> 31;
			if(result==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}
    break;

  default:
    break;
  }
};

void ac_behavior( cmp ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		result=ID_EX.data1 - ID_EX.data2;
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n= result >> 31;

			if(result==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=~((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~result & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~result & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & result & 0x80000000) );
		}
    break;

  default:
    break;
  }
};

void ac_behavior( cmn ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		result=ID_EX.data1 + ID_EX.data2;
		
		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n= result >> 31;

			if(result==0)CPSR.z=1;
			else CPSR.z=1;

			CPSR.c=((ID_EX.data1 & ID_EX.data2 & 0x80000000)|
								(~result & (ID_EX.data1 | ID_EX.data2)) & 0x80000000);

			CPSR.v=((ID_EX.data1 & ID_EX.data2 & ~result & 0x80000000) |
							(~ID_EX.data1 & ~ID_EX.data2 & result & 0x80000000) );
		}

    break;

  default:
    break;
  }
};

void ac_behavior( mov ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		result=ID_EX.data2;
		RB.write(rd, result);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}		
    break;

  default:
    break;
  }
};

void ac_behavior( mvn ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:

		result=~ID_EX.data2;
		RB.write(rd, result);

		if(s==1){
			if(rd==PC){
				copySPSR();			
			}
		}
		else if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
			CPSR.c=shifter_carry_out;
		}		
    break;

  default:
    break;
  }
};

void ac_behavior( mul ){

  switch( stage ) {
  case IF:
		break;

  case ID:
    break;

  case EX:
		result=ID_EX.data1*ID_EX.data2;
		RB.write(rd, result);
		
		if(s==1){
			CPSR.n=RB.read(rd) >> 31;
			if(RB.read(rd)==0)CPSR.z=1;
			else CPSR.z=1;
		}
    break;

  default:
    break;
  }
};

//!Instruction sys_call behavior method.
void ac_behavior( sys_call ) {

  switch( stage ) {
  case IF:
    break;
    
  case ID:
    break;
    
  case EX:
    exit(EXIT_FAILURE);
    break;
   
  default:
    break;
  }
};

void copySPSR();

