<?php
$header = [
	$this->Paginator->sort('id', '#'),
	$this->Paginator->sort('username', 'Login'),
	$this->Paginator->sort('name', 'Nome')
];

$body = [];
$includeFields = ['id', 'username', 'name'];

foreach ($users as $k => $user):
	$body[$k] = $this->Common->buildBodyIndexRow($user, 'User', $includeFields);

    $actions = [
        $this->Html->link(__('Detalhes'), ['action' => 'view', $user['User']['id']], ['class' => 'btn btn-primary']),
        $this->Html->link(__('Editar'), ['action' => 'edit', $user['User']['id']], ['class' => 'btn btn-warning']),
        $this->Form->postLink(__('Excluir'), ['action' => 'delete', $user['User']['id']], ['class' => 'btn btn-danger'], __('Deseja realmente excluir o Usuário %s?', $user['User']['name']))
    ];
    $body[$k]['_actions_'] = $actions;
endforeach;
$buttons = [];
$buttons[] = $this->Html->link('Adicionar Usuário', ['action' => 'add'], ['class' => 'btn btn-info', 'icon' => 'plus-sign']);
?>

<?= $this->element('widgets/index_header', ['title' => "Listagem de Usuários", 'buttons' => $buttons]); ?>
<?= $this->element('widgets/table', ['body' => $body, 'header' => $header]); ?>
