<?php
$header = [
	$this->Paginator->sort('id', '#'),
	$this->Paginator->sort('name', __('Nome'))
];

$body = [];
$includeFields = ['id', 'name'];

foreach ($styles as $k => $style):
	$body[$k] = $this->Common->buildBodyIndexRow($style, 'Style', $includeFields);

    $actions = [
        $this->Html->link(__('Detalhes'), ['action' => 'view', $style['Style']['id']], ['class' => 'btn btn-primary']),
        $this->Html->link(__('Editar'), ['action' => 'edit', $style['Style']['id']], ['class' => 'btn btn-warning']),
        $this->Form->postLink(__('Excluir'), ['action' => 'delete', $style['Style']['id']], ['class' => 'btn btn-danger'], __('Deseja realmente excluir o modelo %s?', $style['Style']['name']))
    ];
    $body[$k]['_actions_'] = $actions;
endforeach;
$buttons = [];
$buttons[] = $this->Html->link('Adicionar Modelo', ['action' => 'add'], ['class' => 'btn btn-info', 'icon' => 'plus-sign']);
?>

<?= $this->element('widgets/index_header', ['title' => "Listagem de Modelos", 'buttons' => $buttons]); ?>
<?= $this->element('widgets/table', ['body' => $body, 'header' => $header]); ?>
