<?php
$header = [
	$this->Paginator->sort('id', '#'),
	$this->Paginator->sort('title', 'Enunciado'),
	$this->Paginator->sort('subject', 'Tema'),
	$this->Paginator->sort('Discipline.name', 'Disciplina'),
	$this->Paginator->sort('User.name', 'Professor'),
	$this->Paginator->sort('last_applied_at', 'Última aplicação')
];

$body = [];
$includeFields = ['id', 'title', 'subject', 'Discipline.name', 'User.name', 'last_applied_at'];

foreach ($questions as $k => $question):
	$body[$k] = $this->Common->buildBodyIndexRow($question, 'Question', $includeFields);
    $actions = [
        $this->Html->link(__('Detalhes'), ['action' => 'view', $question['Question']['id']], ['class' => 'btn btn-primary']),
        $this->Html->link(__('Editar'), ['action' => 'edit', $question['Question']['id']], ['class' => 'btn btn-warning']),
        $this->Form->postLink(__('Excluir'), ['action' => 'delete', $question['Question']['id']], ['class' => 'btn btn-danger'], __('Deseja realmente excluir o questão %s?', $question['Question']['id']))
    ];
    $body[$k]['_actions_'] = $actions;
endforeach;
$buttons = [];
$buttons[] = $this->Html->link('Adicionar Questão', ['action' => 'add'], ['class' => 'btn btn-info', 'icon' => 'plus-sign']);
?>

<?= $this->element('widgets/index_header', ['title' => "Listagem de Questões", 'buttons' => $buttons]); ?>
<?= $this->element('widgets/table', ['body' => $body, 'header' => $header]); ?>
