<?php
$header = [
	$this->Paginator->sort('id', '#'),
	$this->Paginator->sort('title', __('Título')),
	$this->Paginator->sort('discipline_id', __('Disciplina')),
	$this->Paginator->sort('subject', __('Tema')),
	$this->Paginator->sort('year', __('Ano')),
	$this->Paginator->sort('user_id', __('Professor')),
	$this->Paginator->sort('grade', __('Turma')),
];

$body = [];
$includeFields = ['id', 'title', 'Discipline.name', 'subject', 'year', 'User.name', 'grade'];

foreach ($exams as $k => $exam):
	$body[$k] = $this->Common->buildBodyIndexRow($exam, 'Exam', $includeFields);

    $actions = [
        $this->Html->link(__('Detalhes'), ['action' => 'view', $exam['Exam']['id']], ['class' => 'btn btn-primary']),
        $this->Html->link(__('Editar'), ['action' => 'edit', $exam['Exam']['id']], ['class' => 'btn btn-warning']),
        $this->Form->postLink(__('Excluir'), ['action' => 'delete', $exam['Exam']['id']], ['class' => 'btn btn-danger'], __('Deseja realmente excluir a Prova %s?', $exam['Exam']['title']))
    ];
    $body[$k]['_actions_'] = $actions;
endforeach;
$buttons = [];
$buttons[] = $this->Html->link('Adicionar Prova', ['action' => 'add'], ['class' => 'btn btn-info', 'icon' => 'plus-sign']);
?>

<?= $this->element('widgets/index_header', ['title' => "Listagem de Provas", 'buttons' => $buttons]); ?>
<?= $this->element('widgets/table', ['body' => $body, 'header' => $header]); ?>
