<?php
$header = [
	$this->Paginator->sort('id', '#'),
	$this->Paginator->sort('name', 'Nome')
];

$body = [];
$includeFields = ['id', 'name'];

foreach ($disciplines as $k => $discipline):
	$body[$k] = $this->Common->buildBodyIndexRow($discipline, 'Discipline', $includeFields);

    $actions = [
        $this->Html->link(__('Detalhes'), ['action' => 'view', $discipline['Discipline']['id']], ['class' => 'btn btn-primary']),
        $this->Html->link(__('Editar'), ['action' => 'edit', $discipline['Discipline']['id']], ['class' => 'btn btn-warning']),
        $this->Form->postLink(__('Excluir'), ['action' => 'delete', $discipline['Discipline']['id']], ['class' => 'btn btn-danger'], __('Deseja realmente excluir a disciplina %s?', $discipline['Discipline']['name']))
    ];
    $body[$k]['_actions_'] = $actions;
endforeach;
$buttons = [];
$buttons[] = $this->Html->link('Adicionar Disciplina', ['action' => 'add'], ['class' => 'btn btn-info', 'icon' => 'plus-sign']);
?>

<?= $this->element('widgets/index_header', ['title' => "Listagem de Disciplinas", 'buttons' => $buttons]); ?>
<?= $this->element('widgets/table', ['body' => $body, 'header' => $header]); ?>
