<?php
App::uses('AppModel', 'Model');
/**
 * Style Model
 *
 */
class Style extends AppModel {

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = [
		'name' => [
			'notEmpty' => [
				'rule' => ['notEmpty'],
				'message' => 'Informe um nome para o modelo'
			],
		],
	];

	public function beforeValidate($options = []) {
		if (!isset($this->data[$this->alias]['template']['size']) || $this->data[$this->alias]['template']['size'] == 0) {
			$this->invalidate('template', 'Selecione um arquivo para o modelo');
			return false;
		}

		$this->data[$this->alias]['template'] = file_get_contents($this->data[$this->alias]['template']['tmp_name']);

		return true;
	}
}
