<?php
App::uses('AppModel', 'Model');
/**
 * Exam Model
 *
 * @property Discipline $Discipline
 */
class Exam extends AppModel {

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = [
		'discipline_id' => [
			'numeric' => [
				'rule' => ['numeric'],
				'message' => 'Selecione uma disciplina'
			],
		],
		'subject' => [
			'notEmpty' => [
				'rule' => ['notEmpty'],
				'message' => 'Defina o tema da prova',
			],
		],
		'year' => [
			'numeric' => [
				'rule' => ['numeric'],
				'message' => 'Data da aplicação da prova',
			],
		],
		'user_id' => [
			'notEmpty' => [
				'rule' => ['notEmpty'],
				'message' => 'Selecione um professor',
			],
		],
		'grade' => [
			'notEmpty' => [
				'rule' => ['notEmpty'],
				'message' => 'Informe a turma',
			],
		],
		'style_id' => [
			'notEmpty' => [
				'rule' => ['notEmpty'],
				'message' => 'Informe o modelo da prova',
			],
		]
	];

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = [
		'Discipline',
		'User',
		'Style'
	];

/**
 *
 * @param  [type] $data [description]
 * @return [type]       [description]
 */
	public function register($data) {
		$style = $this->Style->read(null, $data[$this->alias]['style_id']);
		$discipline = $this->Discipline->read(null, $data[$this->alias]['discipline_id']);
		$user = $this->User->read(null, $data[$this->alias]['user_id']);

		$_placeHolders = [
			':professor:' => $user['User']['name'],
			':disciplina:' => $discipline['Discipline']['name'],
			':nome:' => $data[$this->alias]['title'],
			':turma:' => $data[$this->alias]['grade'],
			':logo:' => APP . 'webroot/img/beaker.jpg'
		];

		$common = str_replace(array_keys($_placeHolders), $_placeHolders, $style['Style']['template']);

		$tmplWoAnswer = str_replace(':questoes:', $this->_buildQuestions($data[$this->alias]['questions']), $common);
		$tmplWAnswer = str_replace(':questoes:', $this->_buildQuestions($data[$this->alias]['questions'], true), $common);

		$this->_makePdfFromTex($tmplWoAnswer, $data[$this->alias]['to_students']); // do aluno
		$this->_makePdfFromTex($tmplWAnswer, $data[$this->alias]['template']); // gabarito

		return $this->save($data);
	}

/**
 *
 * @param  string  $tex
 * @param  binary  $pdf
 * @return void
 */
	protected function _makePdfFromTex($tex, &$pdf) {
		$tmpfname = tempnam(APP . 'tmp/', 'Exam');
		$handle = fopen($tmpfname, "w");
		fwrite($handle, $tex);
		fclose($handle);
		chmod($tmpfname, 0777);

		shell_exec("cd " . APP . "tmp/ && /usr/bin/pdflatex --interaction batchmode {$tmpfname}");

		$filename = "{$tmpfname}.pdf";
		$handle = fopen($filename, "rb");
		$pdf = fread($handle, filesize($filename));
		fclose($handle);
		unlink($filename);

		unlink($tmpfname);
	}

/**
 *
 * @param  [type]  $questions      [description]
 * @param  boolean $includeAnswers [description]
 * @return [type]                  [description]
 */
	protected function _buildQuestions($questions, $includeAnswers = false) {
		$qTmpl = "\item %s\n\n";

		if ($includeAnswers) {
			$qTmpl = "\item %s \n\n%s\n\n";
		}

		$qData = $this->Discipline->Question->find('all', ['conditions' => ['id' => $questions], 'recursive' => -1]);
		$out = '';

		foreach ($qData as $question) {
			if ($includeAnswers) {
				$out .= sprintf($qTmpl, $question['Question']['title'], $question['Question']['answer']);
				continue;
			}

			$out .= sprintf($qTmpl, $question['Question']['title']);
		}

		return $out;
	}
}
