<?php
App::uses('AppController', 'Controller');
/**
 * Users Controller
 *
 * @property User $User
 * @property PaginatorComponent $Paginator
 */
class UsersController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator');

/**
 *
 * @return [type] [description]
 */
	public function login() {
		$this->layout = 'login';

		if (!$this->request->is('post')) {
			return;
		}

		if ($this->Auth->login()) {
			return $this->redirect($this->Auth->redirectUrl());
		} else {
			$this->__setFlash('Usuário ou senha incorreto.', 'warning');
		}
	}

/**
 *
 * @return [type] [description]
 */
	public function logout() {
    	return $this->redirect($this->Auth->logout());
	}

/**
 * index method
 *
 * @return void
 */
    public function index() {
        $this->User->recursive = 0;
        $this->set('users', $this->paginate());
    }

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function view($id = null) {
        if (!$this->User->exists($id)) {
            throw new NotFoundException(__('User inválido.'));
        }
        $options = ['conditions' => ['User.' . $this->User->primaryKey => $id]];
        $this->set('user', $this->User->find('first', $options));
    }

/**
 * add method
 *
 * @return void
 */
    public function add() {
        if ($this->request->is('post')) {
            $this->User->create();
            if ($this->User->save($this->request->data)) {
                $this->__setFlash(__('User salvo com sucesso!'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível salvar o User. Por favor, tente novamente.'), 'error');
            }
        }
    }

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function edit($id = null) {
        if (!$this->User->exists($id)) {
            throw new NotFoundException(__('User inválido.'));
        }
        if ($this->request->is('post') || $this->request->is('put')) {
            if ($this->User->save($this->request->data)) {
                $this->__setFlash(__('User atualizado com sucesso.'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível atualizar o user. Por favor, tente novamente.'), 'error');
            }
        } else {
            $options = ['conditions' => ['User.' . $this->User->primaryKey => $id]];
            $this->request->data = $this->User->find('first', $options);
            unset($this->request->data['User']['password']);
        }
    }

/**
 * delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function delete($id = null) {
        $this->User->id = $id;
        if (!$this->User->exists()) {
            throw new NotFoundException(__('User inválido.'));
        }
        $this->request->onlyAllow('post', 'delete');
        if ($this->User->delete()) {
            $this->__setFlash(__('User removido.'), 'success');
            $this->redirect(array('action' => 'index'));
        }
        $this->__setFlash(__('User não pode ser removido.'), 'error');
        $this->redirect(array('action' => 'index'));
    }
}
