<?php
App::uses('AppController', 'Controller');
/**
 * Styles Controller
 *
 * @property Style $Style
 * @property PaginatorComponent $Paginator
 */
class StylesController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator');

/**
 * index method
 *
 * @return void
 */
    public function index() {
        $this->Style->recursive = 0;
        $this->set('styles', $this->paginate());
    }

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function view($id = null) {
        if (!$this->Style->exists($id)) {
            throw new NotFoundException(__('Modelo inválido.'));
        }
        $options = ['conditions' => ['Style.' . $this->Style->primaryKey => $id]];
        $this->set('style', $this->Style->find('first', $options));
    }

/**
 * add method
 *
 * @return void
 */
    public function add() {
        if ($this->request->is('post')) {
            $this->Style->create();
            if ($this->Style->save($this->request->data)) {
                $this->__setFlash(__('Modelo salvo com sucesso!'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível salvar o Modelo. Por favor, tente novamente.'), 'danger');
            }
        }
    }

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function edit($id = null) {
        if (!$this->Style->exists($id)) {
            throw new NotFoundException(__('Modelo inválido.'));
        }
        if ($this->request->is('post') || $this->request->is('put')) {
            if ($this->Style->save($this->request->data)) {
                $this->__setFlash(__('Modelo atualizado com sucesso.'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível atualizar o Modelo. Por favor, tente novamente.'), 'danger');
            }
        } else {
            $options = ['conditions' => ['Style.' . $this->Style->primaryKey => $id]];
            $this->request->data = $this->Style->find('first', $options);
        }
    }

/**
 * delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function delete($id = null) {
        $this->Style->id = $id;
        if (!$this->Style->exists()) {
            throw new NotFoundException(__('Modelo inválido.'));
        }
        $this->request->onlyAllow('post', 'delete');
        if ($this->Style->delete()) {
            $this->__setFlash(__('Modelo removido.'), 'success');
            $this->redirect(array('action' => 'index'));
        }
        $this->__setFlash(__('Modelo não pode ser removido.'), 'danger');
        $this->redirect(array('action' => 'index'));
    }
}
