<?php
App::uses('AppController', 'Controller');
/**
 * Questions Controller
 *
 * @property Question $Question
 * @property PaginatorComponent $Paginator
 */
class QuestionsController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator');

/**
 * index method
 *
 * @return void
 */
    public function index() {
        $this->Question->recursive = 0;
        $this->set('questions', $this->paginate());
    }

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function view($id = null) {
        if (!$this->Question->exists($id)) {
            throw new NotFoundException(__('Question inválido.'));
        }
        $options = ['conditions' => ['Question.' . $this->Question->primaryKey => $id]];
        $this->set('question', $this->Question->find('first', $options));
    }

/**
 * add method
 *
 * @return void
 */
    public function add() {
        if ($this->request->is('post')) {
            $this->Question->create();
            if ($this->Question->save($this->request->data)) {
                $this->__setFlash(__('Question salvo com sucesso!'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível salvar o Question. Por favor, tente novamente.'), 'error');
            }
        }
        $disciplines = $this->Question->Discipline->find('list');
        $users = $this->Question->User->find('list');
        $this->set(compact('disciplines', 'users'));
    }

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function edit($id = null) {
        if (!$this->Question->exists($id)) {
            throw new NotFoundException(__('Question inválido.'));
        }
        if ($this->request->is('post') || $this->request->is('put')) {
            if ($this->Question->save($this->request->data)) {
                $this->__setFlash(__('Question atualizado com sucesso.'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível atualizar o question. Por favor, tente novamente.'), 'error');
            }
        } else {
            $options = ['conditions' => ['Question.' . $this->Question->primaryKey => $id]];
            $this->request->data = $this->Question->find('first', $options);
        }
        $disciplines = $this->Question->Discipline->find('list');
        $users = $this->Question->User->find('list');
        $this->set(compact('disciplines', 'users'));
    }

/**
 * delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function delete($id = null) {
        $this->Question->id = $id;
        if (!$this->Question->exists()) {
            throw new NotFoundException(__('Question inválido.'));
        }
        $this->request->onlyAllow('post', 'delete');
        if ($this->Question->delete()) {
            $this->__setFlash(__('Question removido.'), 'success');
            $this->redirect(array('action' => 'index'));
        }
        $this->__setFlash(__('Question não pode ser removido.'), 'error');
        $this->redirect(array('action' => 'index'));
    }

/**
 * Permite autocompletar
 * @return [type] [description]
 */
    public function autoComplete() {
    	$this->viewClass = 'Json';

    	if (!$this->request->is('ajax')) {
    		throw new MethodNotAllowedException('Essa ação não pode ser acessada dessa maneira');
    	}

    	$discipline = $this->request->query('discipline');
    	$term = $this->request->query('q');

    	$suggests = $this->Question->find('list', [
    		'conditions' => [
    			'or' => [
    				'title LIKE' => "%{$term}%",
    				'subject LIKE' => "%{$term}%",
    				'keywords LIKE' => "%{$term}%",
    			],
    			'discipline_id' => $discipline
    		],
    		'recursive' => -1
    	]);

    	$out = [];
    	foreach ($suggests as $id => $title) {
    		$out[] = ['id' => $id, 'title' => $title];
    	}

    	$this->set(compact('out'));
    	$this->set('_serialize', 'out');
    }
}
