<?php
App::uses('AppController', 'Controller');
/**
 * Exams Controller
 *
 * @property Exam $Exam
 * @property PaginatorComponent $Paginator
 */
class ExamsController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator');

/**
 * index method
 *
 * @return void
 */
    public function index() {
        $this->Exam->recursive = 0;
        $this->set('exams', $this->paginate());
    }

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function view($id = null) {
        if (!$this->Exam->exists($id)) {
            throw new NotFoundException(__('Prova inválida.'));
        }
        $options = ['conditions' => ['Exam.' . $this->Exam->primaryKey => $id]];
        $this->set('exam', $this->Exam->find('first', $options));
    }

/**
 * add method
 *
 * @return void
 */
    public function add() {
        if ($this->request->is('post')) {
            $this->Exam->create();
            if ($this->Exam->register($this->request->data)) {
                $this->__setFlash(__('Prova salva com sucesso!'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível salvar a Prova. Por favor, tente novamente.'), 'error');
            }
        }
        $disciplines = $this->Exam->Discipline->find('list');
        $users = $this->Exam->User->find('list');
        $questions = $this->Exam->Discipline->Question->find('list');
        $styles = $this->Exam->Style->find('list');

        $this->set(compact('disciplines', 'users', 'questions', 'styles'));
    }

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function edit($id = null) {
        if (!$this->Exam->exists($id)) {
            throw new NotFoundException(__('Prova inválida.'));
        }
        if ($this->request->is('post') || $this->request->is('put')) {
            if ($this->Exam->save($this->request->data)) {
                $this->__setFlash(__('Prova atualizada com sucesso.'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível atualizar a Prova. Por favor, tente novamente.'), 'error');
            }
        } else {
            $options = ['conditions' => ['Exam.' . $this->Exam->primaryKey => $id]];
            $this->request->data = $this->Exam->find('first', $options);
        }
        $disciplines = $this->Exam->Discipline->find('list');
        $users = $this->Exam->User->find('list');
        $questions = $this->Exam->Discipline->Question->find('list');
        $styles = $this->Exam->Style->find('list');

        $this->set(compact('disciplines', 'users', 'questions', 'styles'));
    }

/**
 * delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function delete($id = null) {
        $this->Exam->id = $id;
        if (!$this->Exam->exists()) {
            throw new NotFoundException(__('Prova inválida.'));
        }
        $this->request->onlyAllow('post', 'delete');
        if ($this->Exam->delete()) {
            $this->__setFlash(__('Prova removida.'), 'success');
            $this->redirect(array('action' => 'index'));
        }
        $this->__setFlash(__('Prova não pode ser removida.'), 'error');
        $this->redirect(array('action' => 'index'));
    }

/**
 *
 * @param  int    $id
 * @param  string $type
 * @return binary
 */
    public function download($id, $type) {
    	$this->Exam->id = $id;
        if (!$this->Exam->exists()) {
            throw new NotFoundException(__('Prova inválida.'));
        }

        $field = ($type == 'template' ? 'template' : 'to_students');
        $data = $this->Exam->find('first', [
        	'conditions' => ['id' => $id],
        	'fields' => ['id', 'title', $field],
        	'recursive' => -1
        ]);

        $this->response->body($data['Exam'][$field]);
        $this->response->type('pdf');
        $this->response->download(Inflector::slug($data['Exam']['title']) . '.pdf');

        return $this->response;
    }
}
