<?php
App::uses('AppController', 'Controller');
/**
 * Disciplines Controller
 *
 * @property Discipline $Discipline
 * @property PaginatorComponent $Paginator
 */
class DisciplinesController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator');

/**
 * index method
 *
 * @return void
 */
    public function index() {
        $this->Discipline->recursive = 0;
        $this->set('disciplines', $this->paginate());
    }

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function view($id = null) {
        if (!$this->Discipline->exists($id)) {
            throw new NotFoundException(__('Discipline inválido.'));
        }
        $options = ['conditions' => ['Discipline.' . $this->Discipline->primaryKey => $id]];
        $this->set('discipline', $this->Discipline->find('first', $options));
    }

/**
 * add method
 *
 * @return void
 */
    public function add() {
        if ($this->request->is('post')) {
            $this->Discipline->create();
            if ($this->Discipline->save($this->request->data)) {
                $this->__setFlash(__('Discipline salvo com sucesso!'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível salvar o Discipline. Por favor, tente novamente.'), 'error');
            }
        }
    }

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function edit($id = null) {
        if (!$this->Discipline->exists($id)) {
            throw new NotFoundException(__('Discipline inválido.'));
        }
        if ($this->request->is('post') || $this->request->is('put')) {
            if ($this->Discipline->save($this->request->data)) {
                $this->__setFlash(__('Discipline atualizado com sucesso.'), 'success');
                $this->redirect(['action' => 'index']);
            } else {
                $this->__setFlash(__('Não foi possível atualizar o discipline. Por favor, tente novamente.'), 'error');
            }
        } else {
            $options = ['conditions' => ['Discipline.' . $this->Discipline->primaryKey => $id]];
            $this->request->data = $this->Discipline->find('first', $options);
        }
    }

/**
 * delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function delete($id = null) {
        $this->Discipline->id = $id;
        if (!$this->Discipline->exists()) {
            throw new NotFoundException(__('Discipline inválido.'));
        }
        $this->request->onlyAllow('post', 'delete');
        if ($this->Discipline->delete()) {
            $this->__setFlash(__('Discipline removido.'), 'success');
            $this->redirect(array('action' => 'index'));
        }
        $this->__setFlash(__('Discipline não pode ser removido.'), 'error');
        $this->redirect(array('action' => 'index'));
    }
}
