<?php
/**
 * Application level Controller
 *
 * This file is application-wide controller file. You can put all
 * application-wide controller-related methods here.
 *
 * PHP 5
 *
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Controller
 * @since         CakePHP(tm) v 0.2.9
 */

App::uses('Controller', 'Controller');

/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @package     app.Controller
 * @link        http://book.cakephp.org/2.0/en/controllers.html#the-app-controller
 */
class AppController extends Controller {

    public $helpers = [
        'Common',
        'Html'      => ['className' => 'BootstrapHtml'],
        'Form'      => ['className' => 'BootstrapForm'],
        'Paginator' => ['className' => 'BootstrapPaginator']
    ];

    public $components = [
        'Session',
        'DebugKit.Toolbar',
        'Auth' => [
            'loginAction' => [
                'controller' => 'users',
                'action' => 'login'
            ],
            'loginRedirect' => [
            	'controller' => 'exams',
            	'action' => 'index'
            ],
            'authError' => 'Você não possui autorização para visualizar esta página!',
            'authenticate' => [
                'Form' => [
                    'passwordHasher' => [
                        'className' => 'Blowfish'
                    ]
                ]
            ]
        ]
    ];

    public function beforeRender()
    {
        if ($this->Auth->loggedIn()) {
            $this->set('activeUser', $this->Auth->user());
        }
    }


    /**
     * Wrapper para o método SessionComponent::setFlash
     * Aplica corretamente a estilização as mensagens.
     *
     * @param  string $message Mensagem que será exibida
     * @param  string $type    null|success|info|error
     * @return void
     */
    protected function __setFlash($message, $type = null)
    {
        if ($type === 'error') {
            $type = 'danger';
        }

        if ($type !== null) {
            $type = "alert-{$type}";
        }

        return $this->Session->setFlash(__($message), 'widgets/flash', compact('type'));
    }
}
