<?php
/**
 * Bake Template for Controller action generation.
 *
 * PHP 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       Cake.Console.Templates.default.actions
 * @since         CakePHP(tm) v 1.3
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */
?>

/**
 * <?php echo $admin ?>index method
 *
 * @return void
 */
    public function <?php echo $admin ?>index() {
        $this-><?php echo $currentModelName ?>->recursive = 0;
        $this->set('<?php echo $pluralName ?>', $this->paginate());
    }

/**
 * <?php echo $admin ?>view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function <?php echo $admin ?>view($id = null) {
        if (!$this-><?php echo $currentModelName; ?>->exists($id)) {
            throw new NotFoundException(__('<?php echo __($singularHumanName); ?> inválido.'));
        }
        $options = ['conditions' => ['<?php echo $currentModelName; ?>.' . $this-><?php echo $currentModelName; ?>->primaryKey => $id]];
        $this->set('<?php echo $singularName; ?>', $this-><?php echo $currentModelName; ?>->find('first', $options));
    }

<?php $compact = array(); ?>
/**
 * <?php echo $admin ?>add method
 *
 * @return void
 */
    public function <?php echo $admin ?>add() {
        if ($this->request->is('post')) {
            $this-><?php echo $currentModelName; ?>->create();
            if ($this-><?php echo $currentModelName; ?>->save($this->request->data)) {
<?php if ($wannaUseSession): ?>
                $this->__setFlash(__('<?php echo __($singularHumanName); ?> salvo com sucesso!'), 'success');
                $this->redirect(['action' => 'index']);
<?php else: ?>
                $this->flash(__('<?php echo ucfirst(strtolower($currentModelName)); ?> saved.'), array('action' => 'index'));
<?php endif; ?>
            } else {
<?php if ($wannaUseSession): ?>
                $this->__setFlash(__('Não foi possível salvar o <?php echo __($singularHumanName); ?>. Por favor, tente novamente.'), 'error');
<?php endif; ?>
            }
        }
<?php
    foreach (array('belongsTo', 'hasAndBelongsToMany') as $assoc):
        foreach ($modelObj->{$assoc} as $associationName => $relation):
            if (!empty($associationName)):
                $otherModelName = $this->_modelName($associationName);
                $otherPluralName = $this->_pluralName($associationName);
                echo "        \${$otherPluralName} = \$this->{$currentModelName}->{$otherModelName}->find('list');\n";
                $compact[] = "'{$otherPluralName}'";
            endif;
        endforeach;
    endforeach;
    if (!empty($compact)):
        echo "        \$this->set(compact(".join(', ', $compact)."));\n";
    endif;
?>
    }

<?php $compact = array(); ?>
/**
 * <?php echo $admin ?>edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function <?php echo $admin; ?>edit($id = null) {
        if (!$this-><?php echo $currentModelName; ?>->exists($id)) {
            throw new NotFoundException(__('<?php echo __($singularHumanName); ?> inválido.'));
        }
        if ($this->request->is('post') || $this->request->is('put')) {
            if ($this-><?php echo $currentModelName; ?>->save($this->request->data)) {
<?php if ($wannaUseSession): ?>
                $this->__setFlash(__('<?php echo __($singularHumanName); ?> atualizado com sucesso.'), 'success');
                $this->redirect(['action' => 'index']);
<?php else: ?>
                $this->flash(__('O <?php echo strtolower($singularHumanName); ?> foi salvo com sucesso.'), array('action' => 'index'));
<?php endif; ?>
            } else {
<?php if ($wannaUseSession): ?>
                $this->__setFlash(__('Não foi possível atualizar o <?php echo __($singularHumanName); ?>. Por favor, tente novamente.'), 'error');
<?php endif; ?>
            }
        } else {
            $options = ['conditions' => ['<?php echo $currentModelName; ?>.' . $this-><?php echo $currentModelName; ?>->primaryKey => $id]];
            $this->request->data = $this-><?php echo $currentModelName; ?>->find('first', $options);
        }
<?php
        foreach (array('belongsTo', 'hasAndBelongsToMany') as $assoc):
            foreach ($modelObj->{$assoc} as $associationName => $relation):
                if (!empty($associationName)):
                    $otherModelName = $this->_modelName($associationName);
                    $otherPluralName = $this->_pluralName($associationName);
                    echo "        \${$otherPluralName} = \$this->{$currentModelName}->{$otherModelName}->find('list');\n";
                    $compact[] = "'{$otherPluralName}'";
                endif;
            endforeach;
        endforeach;
        if (!empty($compact)):
            echo "        \$this->set(compact(".join(', ', $compact)."));\n";
        endif;
    ?>
    }

/**
 * <?php echo $admin ?>delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
    public function <?php echo $admin; ?>delete($id = null) {
        $this-><?php echo $currentModelName; ?>->id = $id;
        if (!$this-><?php echo $currentModelName; ?>->exists()) {
            throw new NotFoundException(__('<?php echo __($singularHumanName); ?> inválido.'));
        }
        $this->request->onlyAllow('post', 'delete');
        if ($this-><?php echo $currentModelName; ?>->delete()) {
<?php if ($wannaUseSession): ?>
            $this->__setFlash(__('<?php echo ucfirst(strtolower(__($singularHumanName))); ?> removido.'), 'success');
            $this->redirect(array('action' => 'index'));
<?php else: ?>
            $this->flash(__('<?php echo ucfirst(strtolower($singularHumanName)); ?> removido'), array('action' => 'index'));
<?php endif; ?>
        }
<?php if ($wannaUseSession): ?>
        $this->__setFlash(__('<?php echo ucfirst(strtolower(__($singularHumanName))); ?> não pode ser removido.'), 'error');
<?php else: ?>
        $this->flash(__('<?php echo ucfirst(strtolower($singularHumanName)); ?> não pode ser removido.'), array('action' => 'index'));
<?php endif; ?>
        $this->redirect(array('action' => 'index'));
    }
