/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

//valida numero inteiro com mascara
function mascaraInteiro(evento){
      var keyCode = evento.keyCode ? evento.keyCode : evento.which ? evento.which : evento.charCode;
      
      
      if ((keyCode < 48 || keyCode > 57) && (keyCode != 8 && keyCode!=9)){
                
               evento.keyCode ? evento.keyCode=0 : evento.which ? evento.which=0 : evento.charCode=0;
               
               return false;
        }
        return true;
}

// JavaScript Document
//adiciona mascara de cnpj
function MascaraCNPJ(cnpj, evento){
        if(!evento) evento = window.event;
        
        if(mascaraInteiro(evento))                
            return formataCampo(cnpj, '00.000.000/0000-00', evento);
        
        return false;
}

//adiciona mascara de cep
function MascaraCep(cep, evento){
    if(!evento) evento = window.event;
        
    if(mascaraInteiro(evento))
        return formataCampo(cep, '00000-000', evento);
    
    return false;
    
}

function MascaraCPF(cpf, evento){
	if(!evento) evento = window.event;
    
	
	if(mascaraInteiro(cpf)){
	        return formataCampo(cpf, '000.000.000-00', evento);
        }       
	
	return false;

}

//valida telefone
function ValidaTelefone(tel){
        exp = /\(\d{2}\)\ \d{4}\-\d{4}/
        if(!exp.test(tel.value))
                return false;
        return true;
}

//valida CEP
function ValidaCep(cep){
        exp = /\d{5}\-\d{3}/
        if(!exp.test(cep.value))
                return false;
        return true;
}

//valida data
function ValidaData(data){
        exp = /\d{2}\/\d{2}\/\d{4}/
        if(!exp.test(data.value))
                return false;
        return true;
}

//valida o CPF digitado
function ValidaCPF(Objcpf){
        var cpf = Objcpf.value;
        exp = /\.|\-/g
        cpf = cpf.toString().replace( exp, "" ); 
        var digitoDigitado = eval(cpf.charAt(9)+cpf.charAt(10));
        var soma1=0, soma2=0;
        var vlr =11;

        for(i=0;i<9;i++){
                soma1+=eval(cpf.charAt(i)*(vlr-1));
                soma2+=eval(cpf.charAt(i)*vlr);
                vlr--;
        }       
        soma1 = (((soma1*10)%11)==10 ? 0:((soma1*10)%11));
        soma2=(((soma2+(2*soma1))*10)%11);

        var digitoGerado=(soma1*10)+soma2;
        if(digitoGerado!=digitoDigitado)        
                return false;
        return true;
}

//valida o CNPJ digitado
function ValidaCNPJ(ObjCnpj){
        var cnpj = ObjCnpj.value;
        var valida = new Array(6,5,4,3,2,9,8,7,6,5,4,3,2);
        var dig1= new Number;
        var dig2= new Number;

        exp = /\.|\-|\//g
        cnpj = cnpj.toString().replace( exp, "" ); 
        var digito = new Number(eval(cnpj.charAt(12)+cnpj.charAt(13)));

        for(i = 0; i<valida.length; i++){
                dig1 += (i>0? (cnpj.charAt(i-1)*valida[i]):0);  
                dig2 += cnpj.charAt(i)*valida[i];       
        }
        dig1 = (((dig1%11)<2)? 0:(11-(dig1%11)));
        dig2 = (((dig2%11)<2)? 0:(11-(dig2%11)));

        if(((dig1*10)+dig2) != digito)  
                return false;
        return true;

}

//formata de forma generica os campos
function formataCampo(campo, Mascara, evento) { 
        var boleanoMascara; 

        var Digitato = evento.keyCode ? evento.keyCode : evento.which ? evento.which : evento.charCode;
        exp = /\-|\.|\/|\(|\)| /g
        campoSoNumeros = campo.value.toString().replace( exp, "" ); 

        var posicaoCampo = 0;    
        var NovoValorCampo="";
        var TamanhoMascara = campoSoNumeros.length;

        if (Digitato != 8) { // backspace 
                for(i=0; i<= TamanhoMascara; i++) { 
                        boleanoMascara  = ((Mascara.charAt(i) == "-") || (Mascara.charAt(i) == ".")
                                                                || (Mascara.charAt(i) == "/")) 
                        boleanoMascara  = boleanoMascara || ((Mascara.charAt(i) == "(") 
                                                                || (Mascara.charAt(i) == ")") || (Mascara.charAt(i) == " ")) 
                        if (boleanoMascara) { 
                                NovoValorCampo += Mascara.charAt(i); 
                                  TamanhoMascara++;
                        }else { 
                                NovoValorCampo += campoSoNumeros.charAt(posicaoCampo); 
                                posicaoCampo++; 
                          }              
                  }      
                campo.value = NovoValorCampo;
                  return true; 
        }else { 
                return true; 
        }
}